/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/05
 *
 */
package com.kickmogu.rhythm.core.ws.serializer;

import java.util.Iterator;

import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHandler;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import com.kickmogu.rhythm.core.Member;

public class MemberDeserializer extends DeserializerImpl {
	static Category log = Category.getInstance(MemberDeserializer.class.getName());

	public void startElement(String namespace, String localName, String prefix,
			Attributes attributes, DeserializationContext context)
			throws SAXException {

		if (value == null) {
			value = new Member();
		}
		super.startElement(namespace, localName, prefix, attributes, context);
	}

	public SOAPHandler onStartChild(String namespace, String localName,
			String prefix, Attributes attributes, DeserializationContext context)
			throws SAXException {

		MessageElement element = context.getCurElement();
		Member member = (Member) value;
		String elementName = element.getElementName().getLocalName();

		if (elementName.startsWith("com.kickmogu.rhythm.core.Member")) {
			//element = context.getElementByID(element.getHref());
		}

		Iterator itr = element.getChildElements();
		String stringValue = null;
		if (itr.hasNext()) {
			stringValue = itr.next().toString();
		}

		if ("id".equals(elementName)) {
			member.setId(stringValue == null ? 0 : Integer.parseInt(stringValue.toString()));
		} else if ("loginid".equals(elementName)) {
			member.setLoginid((String) stringValue.toString());
		} else if ("name".equals(elementName)) {
			member.setName((String) stringValue.toString());
		} else if ("passwd".equals(elementName)) {
			member.setPasswd((String) stringValue.toString());
		} else if ("sessionId".equals(elementName)) {
			member.setSessionId((String) stringValue);
		} else if ("payHour".equals(elementName)) {
			member.setPayHour(stringValue == null ? 0 : Integer.parseInt(stringValue.toString()));
		} else if ("trafficExpenses".equals(elementName)) {
			member.setTrafficExpenses(stringValue == null ? 0 : Integer.parseInt(stringValue.toString()));
		} else if ("trafficExpensesKind".equals(elementName)) {
			member.setTrafficExpensesKind(stringValue == null ? 0 : Integer.parseInt(stringValue.toString()));
		} else if ("restMinutes".equals(elementName)) {
			member.setRestMinutes(stringValue == null ? 0 : Integer.parseInt(stringValue.toString()));
		} else {
			log.error("unexcepted element name = " + elementName);
		}
		return new SOAPHandler(new MessageElement[] { element }, 1);
	}

}
