/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/05
 *
 */
package com.kickmogu.rhythm.core.ws.serializer;

import java.io.IOException;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Serializer;

import org.apache.axis.Constants;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.*;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import com.kickmogu.rhythm.core.Member;

public class MemberSerializer implements Serializer,
		org.apache.axis.encoding.Serializer {

	public String getMechanismType() {
		return Constants.AXIS_SAX;
	}

	public void serialize(QName name, Attributes attributes,
			java.lang.Object value, SerializationContext context) {
		Member target = (Member) value;
		try {
			context.startElement(name, attributes);

			AttributesImpl childAttributes = new AttributesImpl();
			context.serialize(new QName("id"), childAttributes,
					target.getId());
			context.serialize(new QName("loginid"), childAttributes,
					target.getLoginid());
			context.serialize(new QName("name"), childAttributes,
					target.getName());
			context.serialize(new QName("passwd"), childAttributes,
					target.getPasswd());
			context.serialize(new QName("sessionId"), childAttributes,
					target.getSessionId());
			context.serialize(new QName("payHour"), childAttributes,
					target.getPayHour());
			context.serialize(new QName("trafficExpenses"), childAttributes,
					target.getTrafficExpenses());
			context.serialize(new QName("trafficExpensesKind"), childAttributes,
					target.getTrafficExpensesKind());
			context.serialize(new QName("restMinutes"), childAttributes,
					target.getRestMinutes());
			context.endElement();
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}

	public Element writeSchema(java.lang.Class javaType, Types types) {
		/*
		Document document = null;
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder;
			builder = factory.newDocumentBuilder();
			DOMImplementation domImpl = builder.getDOMImplementation();
			document = domImpl.createDocument("", "types", null);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
		Element root = document.getDocumentElement();
		*/
		Element complexType = types.createElement("complexType");
		complexType .setAttribute("name", "Member");
		Element seq = types.createElement("all");
		complexType.appendChild(seq);

		String[] intElements = {"id", "payHour", "trafficExpenses", "restMinutes", "trafficExpensesKind"};
		Element element = null;
		for (int i = 0; i < intElements.length; i++) {
			element = types.createElement("element");
			element.setAttribute("name", intElements[i]);
			element.setAttribute("nillable", "false");
			element.setAttribute("type", "xsd:int");
			seq.appendChild(element);
		}

		String[] strElements = {"loginid", "name", "passwd", "sessionId"};
		for (int i = 0; i < strElements.length; i++) {
			element = types.createElement("element");
			element.setAttribute("name", strElements[i]);
			element.setAttribute("nillable", "true");
			element.setAttribute("type", "soapenc:string");
			seq.appendChild(element);
		}

		return complexType;
	}
	
	public static void main(String[] arg) {
		MemberSerializer ms = new MemberSerializer();
		ms.writeSchema(null, null);
	}
}
