/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/07
 *
 */
package com.kickmogu.rhythm.addressbook.ws;

import com.kickmogu.rhythm.core.*;
import com.kickmogu.rhythm.addressbook.*;
import com.kickmogu.rhythm.addressbook.dao.*;
import com.kickmogu.s2.DAOSequence;
import com.kickmogu.s2.S2Util;

public class AddressBookWs {
	AddressBookDao abdao = (AddressBookDao) S2Util.getS2Container().getComponent(AddressBookDao.class);
	AddressCategoryDao abcatdao = (AddressCategoryDao) S2Util.getS2Container().getComponent(AddressCategoryDao.class);
	AddressDao addrdao = (AddressDao) S2Util.getS2Container().getComponent(AddressDao.class);
	TelephoneDao teldao = (TelephoneDao) S2Util.getS2Container().getComponent(TelephoneDao.class);
	EmailAddressDao emaildao = (EmailAddressDao) S2Util.getS2Container().getComponent(EmailAddressDao.class);
	AddressBookAddressDao abaddrdao = (AddressBookAddressDao) S2Util.getS2Container().getComponent(AddressBookAddressDao.class);
	AddressBookTelephoneDao abteldao = (AddressBookTelephoneDao) S2Util.getS2Container().getComponent(AddressBookTelephoneDao.class);
	AddressBookEmailAddressDao abemaildao = (AddressBookEmailAddressDao) S2Util.getS2Container().getComponent(AddressBookEmailAddressDao.class);

	private void registTelephone(AddressBook abook) {
		AddressBookTelephone[] abtels = abteldao.list(abook.getRegistrant());
		for (int i = 0; i < abtels.length; i++) {
			abteldao.delete(abtels[i]);
		}
		Telephone[] tels = teldao.list(abook.getRegistrant());
		for (int i = 0; i < abtels.length; i++) {
			teldao.delete(tels[i]);
		}
		
		for (int i = 0; abook.getTels() != null && i < abook.getTels().length; i++) {
			Telephone tel = abook.getTels()[i];
			if (tel.getId() == -1) {
				tel.setId(DAOSequence.getNextId(Telephone.UNIQ_KEYNAME));
			}
			teldao.insert(tel);
			
			AddressBookTelephone abtel = new AddressBookTelephone();
			abtel.setId(DAOSequence.getNextId(AddressBookTelephone.UNIQ_KEYNAME));
			abtel.setAddressBookId(abook.getId());
			abtel.setTelephoneId(tel.getId());
			abteldao.insert(abtel);
		}
	}
	
	private void registAddress(AddressBook abook) {
		AddressBookAddress[] abaddrs = abaddrdao.list(abook.getRegistrant());
		for (int i = 0; i < abaddrs.length; i++) {
			abaddrdao.delete(abaddrs[i]);
		}
		Address[] addrs = addrdao.list(abook.getRegistrant());
		for (int i = 0; i < addrs.length; i++) {
			addrdao.delete(addrs[i]);
		}
		
		for (int i = 0; abook.getAddresses() != null && i < abook.getAddresses().length; i++) {
			Address addr = abook.getAddresses()[i];
			if (addr.getId() == -1) {
				addr.setId(DAOSequence.getNextId(Telephone.UNIQ_KEYNAME));
			}
			addrdao.insert(addr);
			
			AddressBookAddress abaddr = new AddressBookAddress();
			abaddr.setId(DAOSequence.getNextId(AddressBookAddress.UNIQ_KEYNAME));
			abaddr.setAddressBookId(abook.getId());
			abaddr.setAddressId(addr.getId());
			abaddrdao.insert(abaddr);
		}
	}
	
	private void registEmailAddress(AddressBook abook) {
		AddressBookEmailAddress[] abeaddrs = abemaildao.list(abook.getRegistrant());
		for (int i = 0; i < abeaddrs.length; i++) {
			abemaildao.delete(abeaddrs[i]);
		}
		EmailAddress[] eaddrs = emaildao.list(abook.getRegistrant());
		for (int i = 0; i < eaddrs.length; i++) {
			emaildao.delete(eaddrs[i]);
		}
		
		for (int i = 0; abook.getEmails() != null && i < abook.getEmails().length; i++) {
			EmailAddress eaddr = abook.getEmails()[i];
			if (eaddr.getId() == -1) {
				eaddr.setId(DAOSequence.getNextId(EmailAddress.UNIQ_KEYNAME));
			}
			emaildao.insert(eaddr);
			
			AddressBookEmailAddress eabaddr = new AddressBookEmailAddress();
			eabaddr.setId(DAOSequence.getNextId(AddressBookAddress.UNIQ_KEYNAME));
			eabaddr.setAddressBookId(abook.getId());
			eabaddr.setEmailAddressId(eaddr.getId());
			abemaildao.insert(eabaddr);
		}
	}
	
	public BaseResult add(Member loginMember, AddressBook abook) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		abook.setId(DAOSequence.getNextId(AddressBook.UNIQ_KEYNAME));
		abook.setRegistrant(loginMember.getId());
		abdao.insert(abook);
		registTelephone(abook);
		registAddress(abook);
		registEmailAddress(abook);
		return result;
	}

	public BaseResult update(Member loginMember, AddressBook abook) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		abdao.update(abook);
		registTelephone(abook);
		registAddress(abook);
		registEmailAddress(abook);
		return result;
	}

	public BaseResult delete(Member loginMember, AddressBook abook) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		abdao.delete(abook);
		return result;
	}
	
	public BaseResult addCategory(Member loginMember, String catname) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		AddressCategory cat = new AddressCategory();
		cat.setId(DAOSequence.getNextId(AddressCategory.UNIQ_KEYNAME));
		cat.setRegistrant(loginMember.getId());
		cat.setName(catname);
		abcatdao.insert(cat);
		return result;
	}

	public BaseResult updateCategory(Member loginMember, AddressCategory cat) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		abcatdao.update(cat);
		return result;
	}

	public BaseResult deleteCategory(Member loginMember, AddressCategory cat) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		abcatdao.delete(cat);
		AddressBook[] delAb = (AddressBook[]) list(loginMember, cat.getId()).getResult();
		for (int i = 0; i < delAb.length; i++) {
			delete(loginMember, delAb[i]);
		}
		return result;
	}

	public BaseResult listCategory(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(abcatdao.list(loginMember.getId()));
		return result;
	}


	public BaseResult getById(Member loginMember, int id) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(abdao.getAddressBook(loginMember.getId(), id));
		return result;
	}

	public BaseResult list(Member loginMember, int catid) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(abdao.list(loginMember.getId(), catid));
		return result;
	}

	public BaseResult listTelephone(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(teldao.list(loginMember.getId()));
		return result;
	}

	public BaseResult listAddress(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(addrdao.list(loginMember.getId()));
		return result;
	}

	public BaseResult listEmailAddress(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(emaildao.list(loginMember.getId()));
		return result;
	}
}
