/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/19
 *
 */
package com.kickmogu.rhythm.core.test;

import com.kickmogu.rhythm.core.*;
import com.thoughtworks.xstream.XStream;
import java.io.*;
import jp.co.dgic.testing.framework.DJUnitTestCase;

public class RhythmTreeTest extends DJUnitTestCase {
	RhythmTree root;
	RhythmTree firstChild;
	RhythmTree secondChild;
    XStream xstream = new XStream();
    Writer writer = null;
    Reader reader = null;

	protected void setUp() throws Exception {
		super.setUp();
		// XMLf[^o͂郉C^쐬
        root = new RhythmTree();
        root.setName("Ԑeł");
        firstChild = new RhythmTree();
        firstChild.setName("ŏ̎qł");
        secondChild = new RhythmTree();
        secondChild.setName("jł");
        RhythmTree mago1Child = new RhythmTree();
        mago1Child.setName("ŏ̎q̑P");
        RhythmTree mago2Child = new RhythmTree();
        mago2Child.setName("ŏ̎q̑2");
        root.addToChild(firstChild);
        firstChild.addToChild(mago1Child);
        firstChild.addToChild(mago2Child);
        secondChild.addToParent(root);

        writer = new FileWriter("c:/RhythmTree.xml");
        reader = new FileReader("c:/RhythmTree.xml");

        // XStreamCX^X𐶐AXMLf[^C^֏o
        xstream.toXML(root, writer);
        System.out.println("------------Tree------------");
        System.out.println(root.toString());
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void test001() throws Exception {
        // 폜Ă݂
        firstChild.remove();
        System.out.println("------------폜Tree------------");
        System.out.println(root.toString());
        // XMLǂݍ
        //      XMLf[^擾郊[_쐬

        // XStreamCX^X𐶐A[_CX^X𕜌
        RhythmTree newRoot = (RhythmTree)xstream.fromXML(reader);
        System.out.println("------------XMLǂݍTree------------");
        System.out.println(newRoot.toString());
	}
	
	public void test002() throws Exception {
        // jj̎qɂ
        firstChild.changeParent(secondChild);
        System.out.println("------------jj̎qɂTree------------");
        System.out.println(root.toString());
	}

	public void test003() throws Exception {
        // jj̎qɂ
		secondChild.moveSeq(0);
        System.out.println("------------j𒷒jɂTree------------");
        System.out.println(root.toString());
	}

	public void test004() throws Exception {
        System.out.println("------------XML\Tree------------");
        System.out.println(root.toXmlAll());
	}
}
