/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/11/29
 *
 */
package com.kickmogu.rhythm.core.ws;

import org.apache.log4j.Category;

import com.kickmogu.rhythm.core.*;
import com.kickmogu.rhythm.core.dao.*;
import com.kickmogu.s2.DAOSequence;
import com.kickmogu.s2.S2Util;

public class MemberWs {
	static Category log = Category.getInstance(MemberWs.class.getName());

	MemberDao memdao = (MemberDao) S2Util.getS2Container().getComponent(MemberDao.class);
	MailSettingDao mailsettingdao = (MailSettingDao) S2Util.getS2Container().getComponent(MailSettingDao.class);
	RoleMemberDao rmdao = (RoleMemberDao) S2Util.getS2Container().getComponent(RoleMemberDao.class);

	public BaseResult add(Member loginMember, Member member) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		member.setId( DAOSequence.getNextId(Member.UNIQ_KEYNAME));
		memdao.insert(member);
		result.setResult(member);
		return result;
	}

	public BaseResult update(Member loginMember, Member member) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		memdao.update(member);
		result.setResult(member);
		return result;
	}

	public BaseResult delete(Member loginMember, Member member) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		memdao.delete(member);
		result.setResult(member);
		return result;
	}

	public BaseResult getById(Member loginMember, int id) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(memdao.getMember(id));
		return result;
	}

	public BaseResult list(Member loginMember, int roleId) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(memdao.listMembers(roleId));
		return result;
	}

	public BaseResult listIndependent(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(memdao.listIndependent());
		return result;
	}

	public BaseResult authorize(String loginid, String password) {
		BaseResult result = new BaseResult();
		Member member = memdao.getMemberByLoginId(loginid);
		if (member == null) {
			result.setStatusCode(100);
			log.warn("authorize failed member not found:" + loginid + "," + password);
			return result;
		}
		if (!member.getPasswd().equals(password)) {
			result.setStatusCode(100);
			log.warn("authorize failed invalid password:" + loginid + "," + password);
			return result;
		}
		String sessionId = SessionManager.addSession(member.getId());
		member.setSessionId(sessionId);
		result.setResult(member);
		return result;
	}
	
	public BaseResult addRole(Member loginMember, int memberId, int roleId) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		RoleMember rm = new RoleMember();
		rm.setMemberId(memberId);
		rm.setRoleId(roleId);
		rmdao.insert(rm);
		return result;
	}

	public BaseResult removeRole(Member loginMember, int memberId, int roleId) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		RoleMember rm = new RoleMember();
		rm.setMemberId(memberId);
		rm.setRoleId(roleId);
		rmdao.delete(rm);
		return result;
	}
	
	public BaseResult listMailSetting(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(mailsettingdao.listMailSetting(loginMember.getId()));
		return result;
	}
	
	public BaseResult getMailSetting(Member loginMember, int memberId, int mailSettingId) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(mailsettingdao.getMailSetting(memberId, mailSettingId));
		return result;
	}

	public BaseResult addMailSetting(Member loginMember, int memberId, MailSetting mailSetting) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		mailSetting.setId(DAOSequence.getNextId(MailSetting.UNIQ_KEYNAME));
		mailSetting.setMemberId(memberId);
		mailsettingdao.insert(mailSetting);
		result.setResult(mailSetting);
		return result;
	}

	public BaseResult updateMailSetting(Member loginMember, MailSetting mailSetting) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		mailsettingdao.update(mailSetting);
		result.setResult(mailSetting);
		return result;
	}

	public BaseResult deleteMailSetting(Member loginMember, MailSetting mailSetting) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		mailsettingdao.delete(mailSetting);
		result.setResult(mailSetting);
		return result;
	}
}
