/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jp.co.iti.fagot.doc.DocBarEvent;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

public class DocBar
extends JToolBar {
    private static Hashtable icons = new Hashtable();
    protected JToggleButton mCurrentButton = null;
    protected Hashtable mToolItems = new Hashtable();
    public static final String SFX_IMAGE = ".image";
    public static final String SFX_SCRIPT = ".script";
    public static final String SFX_TOOLTIP = ".tooltip";
    public static final String SFX_CLASS = ".class";
    public static final String TOGGLED = "+";
    public static final String ACTION = "docbar.action";
    public static final String SELECT_ACTION = "select";
    public static final String MOVE_ACTION = "move";
    public static final String ZOOM_ACTION = "zoom";

    public void setPanel(int n) {
        this.removeAll();
        this.mToolItems = new Hashtable();
        this.mCurrentButton = null;
        ZProperties zProperties = DocManager.loadProperty("docbar");
        String[] stringArray = ZString.tokenize(zProperties.getProperty("panel." + n));
        this.loadTools(zProperties, stringArray);
        this.validate();
        this.repaint();
    }

    public Component getToolItem(String string) {
        return (Component)this.mToolItems.get(string);
    }

    public void loadTools(Properties properties, String[] stringArray) {
        JPanel jPanel = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Component component = null;
            if (stringArray[i].equals("-")) {
                component = Box.createHorizontalStrut(5);
            } else if (stringArray[i].equals("(")) {
                jPanel = new JPanel();
                jPanel.setAlignmentX(0.0f);
                jPanel.setLayout(new BoxLayout(jPanel, 0));
            } else if (stringArray[i].equals(")")) {
                component = jPanel;
                jPanel = null;
            } else {
                component = this.createTool(properties, stringArray[i]);
                this.mToolItems.put(stringArray[i], component);
                if (this.mCurrentButton == null && component instanceof JToggleButton && !(component instanceof JRadioButton)) {
                    this.mCurrentButton = (JToggleButton)component;
                    this.mCurrentButton.setSelected(true);
                    ZInstance.prop().put(ACTION, stringArray[i].substring(1));
                }
                if (component == null) {
                    ZDebug.err("Create tool failed.(" + stringArray[i] + ")");
                } else if (jPanel != null) {
                    jPanel.add(component);
                    component = null;
                }
            }
            if (component == null) continue;
            this.add(component);
        }
    }

    public Component createTool(Properties properties, String string) {
        String string2 = properties.getProperty(string + SFX_CLASS);
        Component component = null;
        if (string2 == null) {
            component = this.createButton(properties, string);
        } else if (string2.equals("Label")) {
            component = this.createLabel(properties, string);
        } else {
            Object obj;
            Class<?> clazz;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ZDebug.err("ClassNotFound:" + string2);
                return null;
            }
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                ZDebug.err("Class newInstance Failed:" + string2);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                ZDebug.err("Class newInstance Failed:" + string2);
                return null;
            }
            if (!(obj instanceof Component)) {
                ZDebug.err("Class is not instanceof Compenent:" + string2);
                return null;
            }
            component = (Component)obj;
            this.initializeComponent(properties, string, component);
        }
        return component;
    }

    protected Component createButton(Properties properties, String string) {
        String string2;
        ImageIcon imageIcon;
        boolean bl = false;
        if (string.startsWith(TOGGLED)) {
            bl = true;
            string = string.substring(1);
        }
        if ((imageIcon = new ImageIcon(string2 = DocManager.getConfigFile("docbar", properties.getProperty(string + SFX_IMAGE)))) == null) {
            ZDebug.err("Resouce not found:" + string2);
            return null;
        }
        AbstractButton abstractButton = bl ? new JToggleButton() : new JButton();
        abstractButton.setAlignmentY(0.5f);
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        abstractButton.setText(null);
        abstractButton.setIcon(imageIcon);
        String string3 = properties.getProperty(string + SFX_TOOLTIP);
        if (string3 == null) {
            string3 = string;
        }
        if (string3 != null) {
            abstractButton.setToolTipText(string3);
        }
        this.initializeComponent(properties, string, abstractButton);
        return abstractButton;
    }

    protected Component createLabel(Properties properties, String string) {
        String string2 = DocManager.getConfigFile("docbar", properties.getProperty(string + SFX_IMAGE));
        ImageIcon imageIcon = new ImageIcon(string2);
        if (imageIcon == null) {
            ZDebug.err("Resouce not found:" + string2);
            return null;
        }
        JLabel jLabel = new JLabel();
        jLabel.setAlignmentY(0.5f);
        jLabel.setText(null);
        jLabel.setIcon(imageIcon);
        String string3 = properties.getProperty(string + SFX_TOOLTIP);
        if (string3 == null) {
            string3 = string;
        }
        if (string3 != null) {
            jLabel.setToolTipText(string3);
        }
        Dimension dimension = jLabel.getPreferredSize();
        dimension.width = 69;
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
        return jLabel;
    }

    protected void initializeComponent(Properties properties, String string, Component component) {
        String string2 = properties.getProperty(string + SFX_SCRIPT);
        if (string2 == null) {
            if (component instanceof JToggleButton) {
                AbstractAction abstractAction = new AbstractAction(string){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (DocBar.this.mCurrentButton != null) {
                            DocBar.this.mCurrentButton.setSelected(false);
                        }
                        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                        jToggleButton.setSelected(true);
                        DocBar.this.mCurrentButton = jToggleButton;
                        ZInstance.prop().put(DocBar.ACTION, this.getValue("Name"));
                    }
                };
                ((JToggleButton)component).addActionListener(abstractAction);
            } else if (component instanceof JComboBox) {
                Dimension dimension = component.getPreferredSize();
                dimension.width = 69;
                ((JComboBox)component).setPreferredSize(dimension);
                ((JComboBox)component).setMinimumSize(dimension);
                ((JComboBox)component).setAlignmentX(0.0f);
            }
        } else {
            Object[] objectArray = new Object[]{component};
            DocManager.invokeDocBarFunction(string, "initialize", objectArray);
            if (component instanceof JComboBox) {
                AbstractAction abstractAction = new AbstractAction(string){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = (String)this.getValue("Name");
                        Object[] objectArray = new Object[]{actionEvent};
                        DocManager.invokeDocBarFunction(string, "actionPerformed", objectArray);
                    }
                };
                ((JComboBox)component).addActionListener(abstractAction);
            } else if (component instanceof JToggleButton) {
                if (string.startsWith("svg_")) {
                    AbstractAction abstractAction = new AbstractAction(string){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (DocBar.this.mCurrentButton != null) {
                                DocBar.this.mCurrentButton.setSelected(false);
                            }
                            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                            jToggleButton.setSelected(true);
                            DocBar.this.mCurrentButton = jToggleButton;
                            ZInstance.prop().put(DocBar.ACTION, this.getValue("Name"));
                            String string = (String)this.getValue("Name");
                            Object[] objectArray = new Object[]{new DocBarEvent(actionEvent, string)};
                            DocManager.invokeDocBarFunction(string, "actionPerformed", objectArray);
                        }
                    };
                    ((JToggleButton)component).addActionListener(abstractAction);
                } else {
                    AbstractAction abstractAction = new AbstractAction(string){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = (String)this.getValue("Name");
                            Object[] objectArray = new Object[]{actionEvent};
                            DocManager.invokeDocBarFunction(string, "actionPerformed", objectArray);
                        }
                    };
                    ((JToggleButton)component).addActionListener(abstractAction);
                }
            }
        }
    }

    public static ImageIcon getDocBarIcon(String string) {
        ImageIcon imageIcon = (ImageIcon)icons.get(string);
        if (null == imageIcon) {
            imageIcon = new ImageIcon(DocManager.getConfigFile("docbar", string));
            icons.put(string, imageIcon);
        }
        return imageIcon;
    }
}

