/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.fob;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import jp.co.iti.fagot.fob.FPropertyChangeEvent;
import jp.co.iti.fagot.fob.IFPropertyChangeListener;
import jp.co.iti.fagot.fob.IFUndoElement;
import jp.co.iti.fagot.util.ZDebug;

public class FobManager {
    protected boolean bTrace = false;
    protected Stack mUndoTran = null;
    protected Stack mUndo;
    protected Stack mRedo;
    protected Vector mListener = new Vector();
    protected boolean mIsModified = false;

    public FobManager() {
        this.reset();
    }

    public void setModified() {
        this.mIsModified = false;
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public void reset() {
        this.mUndoTran = null;
        this.mUndo = new Stack();
        this.mRedo = new Stack();
    }

    public boolean isTransaction() {
        return this.mUndoTran != null;
    }

    public void beginTransaction() {
        if (this.bTrace) {
            ZDebug.trace("begin");
        }
        if (this.mUndoTran == null) {
            this.mUndoTran = new Stack();
        } else {
            ZDebug.trace("Duplicate Transaction");
        }
    }

    public void commit() {
        if (this.mUndoTran == null) {
            if (this.bTrace) {
                ZDebug.trace("commit:none");
            }
        } else if (!this.mUndoTran.isEmpty()) {
            Vector vector = this.getFobs(this.mUndoTran);
            this.firePropertyChange(FPropertyChangeEvent.PRE_COMMIT, vector);
            this.mUndo.push(this.mUndoTran);
            if (this.bTrace) {
                ZDebug.trace("commit:" + this.mUndoTran.size() + " total:" + this.mUndo.size());
            }
            this.mRedo.removeAllElements();
            vector = this.getFobs(this.mUndoTran);
            this.firePropertyChange(FPropertyChangeEvent.COMMIT, vector);
            this.mIsModified = true;
        } else if (this.bTrace) {
            ZDebug.trace("commit:empty");
        }
        this.mUndoTran = null;
    }

    public void commitPlus() {
        if (this.mUndoTran == null) {
            if (this.bTrace) {
                ZDebug.trace("commit plus:none");
            }
        } else if (!this.mUndoTran.isEmpty()) {
            if (this.mUndo.isEmpty()) {
                if (this.bTrace) {
                    ZDebug.trace("commit plus -> commit");
                }
                this.commit();
            } else {
                Vector vector = this.getFobs(this.mUndoTran);
                this.firePropertyChange(FPropertyChangeEvent.PRE_COMMIT, vector);
                Stack stack = (Stack)this.mUndo.peek();
                stack.addAll(this.mUndoTran);
                if (this.bTrace) {
                    ZDebug.trace("commit plus:" + this.mUndoTran.size() + " total:" + this.mUndo.size() + " transize:" + stack.size());
                }
                this.mRedo.removeAllElements();
                vector = this.getFobs(this.mUndoTran);
                this.firePropertyChange(FPropertyChangeEvent.COMMIT, vector);
                this.mIsModified = true;
            }
        } else if (this.bTrace) {
            ZDebug.trace("commit plus:empty");
        }
        this.mUndoTran = null;
    }

    public void rollback() {
        if (this.mUndoTran == null) {
            if (this.bTrace) {
                ZDebug.trace("rollback:none");
            }
            return;
        }
        while (!this.mUndoTran.isEmpty()) {
            IFUndoElement iFUndoElement = (IFUndoElement)this.mUndoTran.pop();
            iFUndoElement.undo();
        }
        if (this.bTrace) {
            ZDebug.trace("rollback");
        }
        this.mUndoTran = null;
    }

    public void push(IFUndoElement iFUndoElement) {
        if (this.mUndoTran != null) {
            this.mUndoTran.push(iFUndoElement);
        }
    }

    public boolean canUndo() {
        return !this.mUndo.isEmpty();
    }

    public void undo() {
        if (this.bTrace) {
            ZDebug.trace("undo size:" + this.mUndo.size() + "," + this.mRedo.size());
        }
        if (this.canUndo()) {
            Vector vector = new Vector();
            Stack stack = (Stack)this.mUndo.pop();
            Stack<IFUndoElement> stack2 = new Stack<IFUndoElement>();
            while (!stack.isEmpty()) {
                IFUndoElement iFUndoElement = (IFUndoElement)stack.pop();
                iFUndoElement.undo();
                iFUndoElement.getFobs(vector);
                stack2.push(iFUndoElement);
            }
            this.mRedo.push(stack2);
            this.firePropertyChange(FPropertyChangeEvent.UNDO, vector);
        }
        if (this.bTrace) {
            ZDebug.trace("         :" + this.mUndo.size() + "," + this.mRedo.size());
        }
    }

    public boolean canRedo() {
        return !this.mRedo.isEmpty();
    }

    public void redo() {
        if (this.bTrace) {
            ZDebug.trace("undo size:" + this.mUndo.size() + "," + this.mRedo.size());
        }
        if (this.canRedo()) {
            Vector vector = new Vector();
            Stack stack = (Stack)this.mRedo.pop();
            Stack<IFUndoElement> stack2 = new Stack<IFUndoElement>();
            while (!stack.isEmpty()) {
                IFUndoElement iFUndoElement = (IFUndoElement)stack.pop();
                iFUndoElement.redo();
                iFUndoElement.getFobs(vector);
                stack2.push(iFUndoElement);
            }
            this.mUndo.push(stack2);
            this.firePropertyChange(FPropertyChangeEvent.REDO, vector);
        }
        if (this.bTrace) {
            ZDebug.trace("         :" + this.mUndo.size() + "," + this.mRedo.size());
        }
    }

    public Vector getFobs(Stack stack) {
        Vector vector = new Vector();
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            IFUndoElement iFUndoElement = (IFUndoElement)enumeration.nextElement();
            iFUndoElement.getFobs(vector);
        }
        return vector;
    }

    public void addPropertyChangeListener(IFPropertyChangeListener iFPropertyChangeListener) {
        this.mListener.add(iFPropertyChangeListener);
    }

    public void removePropertyChangeListener(IFPropertyChangeListener iFPropertyChangeListener) {
        this.mListener.remove(iFPropertyChangeListener);
    }

    public void firePropertyChange(String string, Vector vector) {
        FPropertyChangeEvent fPropertyChangeEvent = new FPropertyChangeEvent(string, vector);
        Enumeration enumeration = this.mListener.elements();
        while (enumeration.hasMoreElements()) {
            IFPropertyChangeListener iFPropertyChangeListener = (IFPropertyChangeListener)enumeration.nextElement();
            iFPropertyChangeListener.propertyChange(fPropertyChangeEvent);
        }
    }
}

