/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.Rectangle;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.fob.FInteger;
import jp.co.iti.fagot.fob.FString;
import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.PStyle;
import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;

public class GString
extends GRectangle {
    protected FString mText = new FString();
    protected FInteger mFormat = new FInteger();
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 4;
    public static final int BOTTOM = 8;
    public static final int SINGLE = 16;
    public static final int CLIP = 32;
    protected FString mFontName = new FString();
    protected FString mFontSize = new FString();
    protected double mX = 0.0;
    protected double mY = 0.0;
    protected LineBreakMeasurer mlbm = null;
    protected TextLayout mTl = null;
    protected Rectangle2D mPaintRect = null;

    public double getX() {
        return this.mX;
    }

    public double getY() {
        return this.mY;
    }

    public void paintContents(DocGraphics docGraphics) {
        if (this.mTl == null) {
            this.createTextLayout(docGraphics);
        }
        if (this.mTl != null) {
            this.mTl.draw(docGraphics.getGraphics(), (float)this.mX, (float)(this.mY + (double)this.mTl.getAscent()));
        }
    }

    protected boolean paintCheck(DocGraphics docGraphics) {
        boolean bl = true;
        this.createTextLayout(docGraphics);
        if (this.mTl != null) {
            DocGridControler docGridControler = docGraphics.getGridControler();
            Rectangle rectangle = docGraphics.getGraphics().getClipBounds();
            if (docGridControler.getScaleTransform().getScaleY() < 0.1) {
                bl = false;
            } else if (rectangle != null && ((double)rectangle.x > this.mPaintRect.getX() + this.mPaintRect.getWidth() || (double)(rectangle.x + rectangle.width) < this.mPaintRect.getX()) && ((double)rectangle.y > this.mPaintRect.getY() + this.mPaintRect.getHeight() || (double)(rectangle.y + rectangle.height) < this.mPaintRect.getY())) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected void createTextLayout(DocGraphics docGraphics) {
        int n;
        String string = this.getText();
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 < 0) {
            return;
        }
        DocGridControler docGridControler = docGraphics.getGridControler();
        this.mPaintRect = docGridControler.transform(this.getRect()).getBounds2D();
        ZResource zResource = ZApp.getTheApp().getResource();
        String string2 = this.getFontName();
        if (string2 == null) {
            string2 = zResource.getString("app.font.name");
        }
        if ((n = ZString.parseInt(this.getFontSize(), 0)) == 0) {
            n = zResource.getInt("app.font.size", 10);
        }
        AffineTransform affineTransform = docGridControler.getScaleTransform();
        PStyle pStyle = this.getStyle();
        this.mlbm = ZGraphicUtil.createLineBreakMeasurer(string, string2, new Float((double)n * affineTransform.getScaleX()), null, pStyle.getFillColor().get(), docGraphics.getGraphics().getFontRenderContext());
        ZDimension zDimension = null;
        float f = (float)this.mPaintRect.getX();
        float f2 = (float)this.mPaintRect.getY();
        if ((this.getFormat() & 1) != 0) {
            zDimension = ZGraphicUtil.getTextPreferredSize(this.mlbm, affineTransform, n2, 0.0);
            f = (float)((double)f + (this.mPaintRect.getWidth() - zDimension.getWidth()) / 2.0);
        } else if ((this.getFormat() & 2) != 0) {
            zDimension = ZGraphicUtil.getTextPreferredSize(this.mlbm, affineTransform, n2, 0.0);
            f = (float)((double)f + (this.mPaintRect.getWidth() - zDimension.getWidth()));
        }
        if ((this.getFormat() & 4) == 0 && (this.getFormat() & 8) != 0) {
            if (zDimension == null) {
                zDimension = ZGraphicUtil.getTextPreferredSize(this.mlbm, affineTransform, n2, 0.0);
            }
            f2 = (float)((double)f2 + (this.mPaintRect.getHeight() - zDimension.getHeight()));
        }
        this.mTl = this.mlbm.nextLayout((float)this.mPaintRect.getWidth());
        this.mX = f;
        this.mY = f2;
    }

    public void setText(String string) {
        this.mText.set(string);
        this.mlbm = null;
        this.mTl = null;
    }

    public String getText() {
        return this.mText.getString();
    }

    public void setFormat(int n) {
        this.mFormat.set(n);
    }

    public int getFormat() {
        return this.mFormat.get();
    }

    public void setFontName(String string) {
        this.mFontName.set(string);
        this.mlbm = null;
        this.mTl = null;
    }

    public String getFontName() {
        return this.mFontName.getString();
    }

    public void setFontSize(String string) {
        this.mFontSize.set(string);
        this.mlbm = null;
        this.mTl = null;
    }

    public String getFontSize() {
        return this.mFontSize.getString();
    }

    public void setFobManager(FobManager fobManager) {
        super.setFobManager(fobManager);
        this.mText.setFobManager(fobManager, this);
        this.mFormat.setFobManager(fobManager, this);
        this.mFontName.setFobManager(fobManager, this);
        this.mFontSize.setFobManager(fobManager, this);
    }

    public Object createClone() {
        return new GString();
    }

    public void copyAttribute(Object object) {
        super.copyAttribute(object);
        ((GString)object).setText(this.getText());
        ((GString)object).setFormat(this.getFormat());
        ((GString)object).setFontName(this.getFontName());
        ((GString)object).setFontSize(this.getFontSize());
    }
}

