/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.util.ZString;

public class UDialog
extends JDialog {
    public IZApp mApp;
    public String mDialogName;
    public boolean mIsOK = false;
    protected JComponent mComponent = null;
    protected JScrollPane mScroll = null;
    protected JButton mOK = null;
    protected JButton mCancel = null;
    protected JButton mUpdate = null;
    public static final String OK = "ok";
    public static final String CANCEL = "cancel";
    public static final String UPDATE = "update";

    public UDialog(IZApp iZApp, String string) {
        super(iZApp.getFrame(), false);
        this.mApp = iZApp;
        this.mDialogName = string;
        this.setTitle();
        this.getApp().getResource().loadGeometry(this, this.mDialogName);
    }

    public boolean doModal() {
        this.setModal(true);
        this.pack();
        this.show();
        return this.isOK();
    }

    public boolean isOK() {
        return this.mIsOK;
    }

    public void setComponent(JComponent jComponent, boolean bl) {
        if (bl) {
            this.mScroll = new JScrollPane();
            this.mScroll.setViewportView(jComponent);
            this.mComponent = jComponent;
            this.getContentPane().add("Center", this.mScroll);
        } else {
            this.mComponent = jComponent;
            this.getContentPane().add("Center", this.mComponent);
        }
    }

    public JComponent getComponent() {
        return this.mComponent;
    }

    public JScrollPane getScrollComponent() {
        return this.mScroll;
    }

    public void onOK() {
        this.mIsOK = true;
        this.setVisible(false);
    }

    public void onCancel() {
        this.mIsOK = false;
        this.setVisible(false);
    }

    public void onUpdate() {
    }

    protected void setTitle() {
        String string = this.getApp().getResource().getString("app." + this.mDialogName + ".title");
        if (string == null) {
            string = this.mDialogName;
        }
        this.setTitle(string);
    }

    public void hide() {
        this.getApp().getResource().saveGeometry(this, this.mDialogName);
        super.hide();
    }

    public void setControlPanel(String string) {
        JPanel jPanel = this.createControlPanel(string);
        this.getContentPane().add("South", jPanel);
    }

    public JPanel createControlPanel(String string) {
        String[] stringArray = ZString.tokenize(string);
        JPanel jPanel = new JPanel();
        for (int i = 0; i < stringArray.length; ++i) {
            AbstractAction abstractAction = null;
            Object var6_6 = null;
            if (stringArray[i].equals(OK)) {
                abstractAction = new AbstractAction(OK){

                    public void actionPerformed(ActionEvent actionEvent) {
                        UDialog.this.onOK();
                    }
                };
                this.mOK = new JButton(abstractAction);
                this.mOK.setText("OK");
                jPanel.add(this.mOK);
                continue;
            }
            if (stringArray[i].equals(CANCEL)) {
                abstractAction = new AbstractAction(CANCEL){

                    public void actionPerformed(ActionEvent actionEvent) {
                        UDialog.this.onCancel();
                    }
                };
                this.mCancel = new JButton(abstractAction);
                this.mCancel.setText("Cancel");
                jPanel.add(this.mCancel);
                continue;
            }
            if (!stringArray[i].equals(UPDATE)) continue;
            abstractAction = new AbstractAction(CANCEL){

                public void actionPerformed(ActionEvent actionEvent) {
                    UDialog.this.onUpdate();
                }
            };
            this.mUpdate = new JButton(abstractAction);
            this.mUpdate.setText("\u66f4\u65b0");
            jPanel.add(this.mUpdate);
        }
        return jPanel;
    }

    public IZApp getApp() {
        return this.mApp;
    }

    public String getDialogName() {
        return this.mDialogName;
    }

    public JButton getOKButton() {
        return this.mOK;
    }

    public JButton getCancelButton() {
        return this.mCancel;
    }

    public JButton getUpdateButton() {
        return this.mUpdate;
    }
}

