/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.ui;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.IZFileable;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;

public class UIFactory {
    protected IZApp mApp;
    protected ZResource mRes = null;
    protected JMenuBar mMenuBar;
    protected Hashtable mMenuItems = new Hashtable();
    protected Hashtable mMenus = new Hashtable();
    protected Hashtable mToolItems = new Hashtable();
    private static final String PFX_MENU = "menu.";
    private static final String PFX_TOOL = "tool.";
    private static final String SFX_IMAGE = ".image";
    private static final String SFX_LABEL = ".label";
    private static final String SFX_ACTION = ".action";
    private static final String SFX_TOOLTIP = ".tooltip";
    private static final String SFX_CLASS = ".class";
    private static final String MNEMONIC = "$";
    private static final String SUBMENU = "%";
    private static final String TOGGLED = "+";
    private static final String SEPARATOR = "-";

    public UIFactory(IZApp iZApp) {
        this.mApp = iZApp;
    }

    public UIFactory(IZApp iZApp, ZResource zResource) {
        this.mApp = iZApp;
        this.mRes = zResource;
    }

    public JMenuBar createMenuBar(String string) {
        ZResource zResource = this.getResource();
        if (zResource == null) {
            return null;
        }
        this.mMenuBar = this.createMenuBar();
        String[] stringArray = ZString.tokenize(zResource.getString(string));
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JMenu jMenu = this.createMenu(stringArray[i]);
            if (jMenu == null) continue;
            this.mMenuBar.add(jMenu);
        }
        return this.mMenuBar;
    }

    protected JMenu createMenu(String string) {
        String[] stringArray;
        JMenu jMenu = null;
        String string2 = this.getResource().getString(PFX_MENU + string + SFX_LABEL);
        if (string2 == null) {
            System.out.println("Resouce not found:menu." + string + SFX_LABEL);
            return null;
        }
        int n = string2.indexOf(MNEMONIC);
        if (n != -1) {
            stringArray = string2.substring(0, n) + string2.substring(n + 1);
            jMenu = new JMenu((String)stringArray);
            jMenu.setMnemonic(Character.toLowerCase(string2.charAt(n + 1)));
        } else {
            jMenu = new JMenu(string2);
        }
        stringArray = ZString.tokenize(this.getResource().getString(PFX_MENU + string));
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(SEPARATOR)) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(stringArray[n], jMenu.getPopupMenu());
            jMenu.add(jMenuItem);
        }
        this.mMenus.put(string, jMenu);
        return jMenu;
    }

    public JPopupMenu createContextMenu(JComponent jComponent, String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setInvoker(jComponent);
        String[] stringArray = ZString.tokenize(this.getResource().getString(PFX_MENU + string));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(SEPARATOR)) {
                jPopupMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(stringArray[i], jPopupMenu);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public JPopupMenu createContextMenu(JComponent jComponent, Vector vector) {
        String string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setInvoker(jComponent);
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector2.add(this.getResource().getString(PFX_MENU + string));
        }
        string = ZString.getCommonStrings(vector2);
        while (string.endsWith(SEPARATOR)) {
            string = string.substring(0, string.length() - SEPARATOR.length());
            string = ZString.trimRight(string);
        }
        String[] stringArray = ZString.tokenize(string);
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(SEPARATOR)) {
                if (!bl) {
                    jPopupMenu.addSeparator();
                }
                bl = true;
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(stringArray[i], jPopupMenu);
            jPopupMenu.add(jMenuItem);
            bl = false;
        }
        return jPopupMenu;
    }

    protected JMenuItem createMenuItem(String string, JPopupMenu jPopupMenu) {
        String string2;
        URL uRL;
        if (string.startsWith(SUBMENU)) {
            return this.createMenu(string.substring(1));
        }
        boolean bl = false;
        if (string.startsWith(TOGGLED)) {
            bl = true;
            string = string.substring(1);
        }
        JMenuItem jMenuItem = null;
        String string3 = this.getResource().getString(PFX_MENU + string + SFX_LABEL);
        if (System.getProperty("os.arch").equals("ppc") && string.equals("view_windows")) {
            string3 = this.getResource().getString("menu.view_mac.label");
        }
        String string4 = string3;
        char c = '\u0000';
        if (string3 == null) {
            ZDebug.err("not exist resource key:menu." + string + SFX_LABEL);
            string4 = string3 = new String(string);
        } else {
            int n = string3.indexOf(MNEMONIC);
            if (n != -1) {
                string4 = string3.substring(0, n) + string3.substring(n + 1);
                c = Character.toLowerCase(string3.charAt(n + 1));
            }
        }
        jMenuItem = bl ? new JCheckBoxMenuItem(string4) : new JMenuItem(string4);
        if (c != '\u0000') {
            jMenuItem.setMnemonic(c);
        }
        if ((uRL = this.getResource().getURL(PFX_MENU + string + SFX_IMAGE)) == null) {
            uRL = this.getResource().getURL("menu.default.image");
        }
        if (uRL != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(new ImageIcon(uRL));
            jMenuItem.setMargin(new Insets(0, 0, 1, 1));
        }
        if ((string2 = this.getResource().getString(PFX_MENU + string + SFX_ACTION)) == null) {
            string2 = string;
        }
        jMenuItem.setActionCommand(string2);
        Action action = this.getApp().getAction(string2);
        if (action != null) {
            jMenuItem.addActionListener(action);
            action.addPropertyChangeListener(new UIChangedListener(jMenuItem));
            jMenuItem.setEnabled(action.isEnabled());
            if (action instanceof ZAction) {
                jPopupMenu.addPopupMenuListener((ZAction)action);
            }
        } else {
            jMenuItem.setEnabled(false);
        }
        this.mMenuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    public JMenuBar getMenuBar() {
        return this.mMenuBar;
    }

    public JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.mMenuItems.get(string);
    }

    public JMenu getMenu(String string) {
        return (JMenu)this.mMenus.get(string);
    }

    public void updateRecent(IZFileable iZFileable, String string, String string2) {
        String string3;
        int n;
        int n2 = this.getResource().getInt(string, 5);
        if (string2 != null) {
            for (n = 1; n < n2 && (string3 = this.getResource().getString(string + n)) != null && !string3.equals(string2); ++n) {
            }
            --n;
            while (n > 0) {
                string3 = this.getResource().getString(string + n);
                this.getResource().putString(string + (n + 1), string3);
                --n;
            }
            this.getResource().putString(string + 1, string2);
        }
        String string4 = System.getProperty("user.dir");
        JMenu jMenu = this.getMenu(string);
        if (jMenu != null) {
            jMenu.removeAll();
            for (n = 1; n <= n2; ++n) {
                string3 = this.getResource().getString(string + n);
                if (string3 == null) continue;
                String string5 = string3;
                JMenuItem jMenuItem = new JMenuItem(string5);
                Action action = iZFileable.createRecentAction(string, string3);
                if (action != null) {
                    jMenuItem.addActionListener(action);
                    jMenuItem.setEnabled(action.isEnabled());
                    jMenu.add(jMenuItem);
                    continue;
                }
                ZDebug.err("Can't create action");
            }
        } else {
            ZDebug.err("not exist menu");
        }
    }

    public JToolBar createToolBar(String string) {
        ZResource zResource = this.getResource();
        if (zResource == null) {
            return null;
        }
        JToolBar jToolBar = new JToolBar();
        JPanel jPanel = null;
        String[] stringArray = ZString.tokenize(zResource.getString(string));
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(SEPARATOR)) {
                jToolBar.add(Box.createHorizontalStrut(5));
                continue;
            }
            if (stringArray[i].equals("(")) {
                jPanel = new JPanel();
                jPanel.setAlignmentX(0.0f);
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                continue;
            }
            if (stringArray[i].equals(")")) {
                jToolBar.add(jPanel);
                jPanel = null;
                continue;
            }
            if (jPanel == null) {
                jToolBar.add(this.createTool(stringArray[i]));
                continue;
            }
            jPanel.add(this.createTool(stringArray[i]));
        }
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public JComponent createTool(String string) {
        String string2 = this.getResource().getString(PFX_TOOL + string + SFX_CLASS);
        JComponent jComponent = null;
        if (string2 == null) {
            jComponent = this.createToolBarButton(string);
        } else {
            Object obj;
            Class<?> clazz;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("ClassNotFound:" + string2);
                return null;
            }
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Class newInstance Failed:" + string2);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Class newInstance Failed:" + string2);
                return null;
            }
            if (!(obj instanceof JComponent)) {
                System.err.println("Class is not instanceof Compenent:" + string2);
                return null;
            }
            jComponent = (JComponent)obj;
            this.mToolItems.put(string, jComponent);
        }
        return jComponent;
    }

    protected AbstractButton createToolBarButton(String string) {
        Action action;
        URL uRL;
        boolean bl = false;
        if (string.startsWith(TOGGLED)) {
            bl = true;
            string = string.substring(1);
        }
        if ((uRL = this.getResource().getURL(PFX_MENU + string + SFX_IMAGE)) == null) {
            System.out.println("Resouce not found:menu." + string + SFX_IMAGE);
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon == null) {
            System.out.println("Resouce not found:menu." + string + SFX_IMAGE + "=" + uRL.toString());
            return null;
        }
        AbstractButton abstractButton = bl ? new JToggleButton(imageIcon) : new JButton(imageIcon);
        abstractButton.setAlignmentY(0.5f);
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        String string2 = this.getResource().getString(PFX_MENU + string + SFX_ACTION);
        if (string2 == null) {
            string2 = string;
        }
        if ((action = this.getApp().getAction(string2)) != null) {
            abstractButton.setActionCommand(string2);
            action.addPropertyChangeListener(new UIChangedListener(abstractButton));
            abstractButton.addActionListener(action);
        } else {
            abstractButton.setEnabled(false);
        }
        String string3 = this.getResource().getString(PFX_TOOL + string + SFX_TOOLTIP);
        if (string3 == null && (string3 = this.getResource().getString(PFX_MENU + string + SFX_LABEL)) != null) {
            int n = string3.indexOf(36);
            if (n != -1) {
                string3 = string3.substring(0, n) + string3.substring(n + 1);
            }
            if ((n = string3.indexOf(40)) != -1) {
                string3 = string3.substring(0, n);
            }
        }
        if (string3 != null) {
            abstractButton.setToolTipText(string3);
        }
        this.mToolItems.put(string, abstractButton);
        return abstractButton;
    }

    public JComponent getToolItem(String string) {
        return (JComponent)this.mToolItems.get(string);
    }

    protected ZResource getResource() {
        if (this.mRes == null) {
            return this.getApp().getResource();
        }
        return this.mRes;
    }

    protected IZApp getApp() {
        return this.mApp;
    }

    private class UIChangedListener
    implements PropertyChangeListener {
        private AbstractButton mButton;

        UIChangedListener(AbstractButton abstractButton) {
            this.mButton = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("label")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.mButton.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.mButton.setEnabled(bl);
            } else if (string.equals("checked")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.mButton.setSelected(bl);
            }
        }
    }
}

