/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import jp.co.nri.rid.analyzer.BaseURL;
import jp.co.nri.rid.analyzer.FileNameStudio;
import jp.co.nri.rid.analyzer.LinkList;
import jp.co.nri.rid.analyzer.RWarningException;
import jp.co.nri.rid.analyzer.iExceptionCode;
import jp.co.nri.rid.analyzer.iMappingScript;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.importer.RIgnoreFiles;
import jp.co.nri.rid.xml.elementBooster;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HyperLinkMappingScript
implements iMappingScript,
iExceptionCode {
    private static final String[] names = new String[]{"attribute.href", "attribute.action", "form.action", "frame.src", "area.href", "cfform.action", "cflocation.url", "cfinclude.template", "cferror.template", "meta.content", "rid.href"};
    private static final String PAGEUNIT = "PageUnit";
    private static final String ZONEUNIT = "ZoneUnit";
    private static final String URLUNIT = "UrlUnit";
    private static final String NAME = "Name";
    private static final String KEY = "Key";
    private static final String EXIST = "Exist";
    private static final String TOP = "Top";
    private static final String PAGETYPE = "PageType";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String STATIC = "static";
    private static final String DYNAMIC = "dynamic";
    private static final String SERVER = "server";
    private static final String CREATOR = "Creator";
    private static final String ANALIZER = "analyzer";
    private static final String INTENSITY = "Intensity";
    private static final String REAL = "Real";
    private static final String METACONTENT = "meta.content";
    private elementBooster myElement;
    private BaseURL baseURL;
    private Document document;
    private elementBooster topZone;
    private Element topZoneElement;
    private NodeList urlUnitNodeList;
    private LinkList linkList;

    public HyperLinkMappingScript(elementBooster elementBooster2, LinkList linkList, BaseURL baseURL) {
        this.myElement = elementBooster2;
        this.baseURL = baseURL;
        this.linkList = linkList;
        this.document = elementBooster2.element().getOwnerDocument();
        this.topZone = elementBooster2.child(ZONEUNIT);
        this.topZoneElement = this.topZone.element();
        this.urlUnitNodeList = this.topZoneElement.getElementsByTagName(URLUNIT);
    }

    public String[] names() {
        return names;
    }

    public void hit(String string, String string2, elementBooster elementBooster2) throws RidException, RWarningException {
        String string3 = elementBooster2.text();
        if (METACONTENT.equals(string2)) {
            string3 = FileNameStudio.getMetaContentLink(string3);
        }
        if (null == string3) {
            return;
        }
        RWarningException rWarningException = new RWarningException();
        try {
            String string4 = this.target(string, string3);
            if (null == string4) {
                return;
            }
            Element element = this.linkList.get(string4);
            if (null == element) {
                element = this.linkList.appendUnit(string4);
                if ("rid.href".equals(string2)) {
                    element.setAttribute(INTENSITY, "Virtual");
                } else {
                    element.setAttribute(EXIST, TRUE);
                    element.setAttribute(INTENSITY, REAL);
                }
            } else {
                element.setAttribute(EXIST, TRUE);
            }
        }
        catch (RWarningException rWarningException2) {
            rWarningException.add(rWarningException2);
        }
        if (0 < rWarningException.length()) {
            throw rWarningException;
        }
    }

    private String target(String string, String string2) throws RidException, RWarningException {
        String string3;
        if (FileNameStudio.skip(string2)) {
            return null;
        }
        if (null != this.baseURL && null != (string3 = this.baseURL.getInnerPath(string, string2))) {
            string2 = string3;
        }
        if (FileNameStudio.isURL(string2 = FileNameStudio.cutParamForUrlUnit(string2))) {
            string3 = FileNameStudio.pureURL(string2);
            if (null != string3) {
                string3 = this.urlunit(string3);
            }
            return string3;
        }
        if (RIgnoreFiles.ignorefile(string2)) {
            return null;
        }
        string3 = null;
        if (string2.equals("/")) {
            string3 = null;
        } else if (string2.startsWith("/")) {
            try {
                string3 = FileNameStudio.fusion("/", string2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string3 = FileNameStudio.simplefusion("/", string2);
                if (null != string3) {
                    string3 = this.urlunit(string3);
                }
                return string3;
            }
            if (null == string3) {
                return null;
            }
        } else {
            try {
                string3 = FileNameStudio.fusion(string, string2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string3 = FileNameStudio.simplefusion(string, string2);
                if (null != string3) {
                    string3 = this.urlunit(string3);
                }
                return string3;
            }
            if (null == string3) {
                return null;
            }
        }
        String string4 = null;
        try {
            string4 = FileNameStudio.page(string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (null == string4) {
            return this.defaultfile(this.topZone, string3);
        }
        Element element = this.findZonePageUnit(string3, this.topZoneElement);
        if (null != element) {
            if (element.getTagName().equals(PAGEUNIT)) {
                return string3;
            }
            if (element.getTagName().equals(ZONEUNIT)) {
                return this.defaultfile(this.topZone, string3);
            }
        }
        if (FileNameStudio.isZone(string4)) {
            return this.defaultfile(this.topZone, string3);
        }
        if (FileNameStudio.isResource(string4)) {
            return null;
        }
        elementBooster elementBooster2 = FileNameStudio.zone(this.topZone, string3, ANALIZER);
        if (elementBooster2 == null) {
            throw new RWarningException("W2301", string3);
        }
        this.pageunit(elementBooster2, string4);
        return string3;
    }

    private String defaultfile(elementBooster elementBooster2, String string) throws RidException, RWarningException {
        String string2 = null;
        elementBooster elementBooster3 = null;
        if (null == string) {
            elementBooster3 = elementBooster2;
        } else {
            string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : new String(string);
            elementBooster3 = FileNameStudio.unit(elementBooster2, ZONEUNIT, KEY, string2);
            if (null == elementBooster3) {
                String string3 = string2 + "/index.html";
                elementBooster elementBooster4 = FileNameStudio.zone(elementBooster2, string3, ANALIZER);
                if (elementBooster4 == null) {
                    throw new RWarningException("W2301", string3);
                }
                this.pageunit(elementBooster4, "index.html");
                return string3;
            }
        }
        String string4 = elementBooster3.attribute(TOP);
        if (null != string4) {
            if (RIgnoreFiles.ignorename(string4)) {
                return null;
            }
            String string5 = null;
            string5 = null == string2 ? string4 : string2 + "/" + string4;
            if (null == FileNameStudio.unit(elementBooster2, PAGEUNIT, KEY, string5)) {
                this.pageunit(elementBooster3, string4);
            }
            return string5;
        }
        String string6 = null;
        string6 = null == string2 ? "index.html" : string2 + "/index.html";
        if (null != FileNameStudio.unit(elementBooster2, PAGEUNIT, KEY, string6)) {
            return string6;
        }
        string6 = null == string2 ? "index.htm" : string2 + "/index.htm";
        if (null != FileNameStudio.unit(elementBooster2, PAGEUNIT, KEY, string6)) {
            return string6;
        }
        string6 = null == string2 ? "index.html" : string2 + "/index.html";
        this.pageunit(elementBooster3, "index.html");
        return string6;
    }

    private Element findUnit(String string, NodeList nodeList) {
        for (int i = nodeList.getLength() - 1; 0 <= i; --i) {
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute(NAME);
            if (!string2.equalsIgnoreCase(string)) continue;
            return element;
        }
        return null;
    }

    private Element findZonePageUnit(String string, NodeList nodeList) {
        for (int i = nodeList.getLength() - 1; 0 <= i; --i) {
            Element element;
            String string2;
            Node node = nodeList.item(i);
            if (1 != node.getNodeType() || !ZONEUNIT.equals(string2 = node.getNodeName()) && !PAGEUNIT.equals(string2) || !string.equalsIgnoreCase((element = (Element)node).getAttribute(NAME))) continue;
            return element;
        }
        return null;
    }

    private Element findZonePageUnit(String string, Element element) {
        String[] stringArray = string.split("/");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            NodeList nodeList = element.getChildNodes();
            if (null != (element = this.findZonePageUnit(stringArray[i], nodeList))) continue;
            return null;
        }
        return element;
    }

    private String urlunit(String string) {
        try {
            string = new URI(string).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Element element = this.findUnit(string, this.urlUnitNodeList);
        if (null == element) {
            element = this.document.createElement(URLUNIT);
            element.setAttribute(NAME, string);
            element.setAttribute(CREATOR, ANALIZER);
            this.topZoneElement.appendChild(element);
        }
        return string;
    }

    private elementBooster pageunit(elementBooster elementBooster2, String string) throws RidException {
        elementBooster elementBooster3 = elementBooster2.add(PAGEUNIT);
        elementBooster3.attribute(NAME, string);
        elementBooster3.attribute(EXIST, FALSE);
        elementBooster3.attribute(CREATOR, ANALIZER);
        if (FileNameStudio.isStaticPage(string)) {
            elementBooster3.attribute(PAGETYPE, STATIC);
        } else {
            elementBooster3.attribute(PAGETYPE, DYNAMIC);
        }
        return elementBooster3;
    }
}

