/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkedPageList {
    private static final String LINKEDPAGE = "LinkedPage";
    private static final String LINKEDPAGEUNIT = "LinkedPageUnit";
    private static final String PAGE = "Page";
    private static final String RESOURCE = "Resource";
    private Hashtable list = null;
    private String from = null;
    private NodeList linkedPageNodeList;
    private Document document;
    private Element linkedPageTag;

    public LinkedPageList(Element element) {
        this.document = element.getOwnerDocument();
        this.linkedPageTag = this.getLinkedPageTag(element);
        this.linkedPageNodeList = this.linkedPageTag.getElementsByTagName(LINKEDPAGEUNIT);
    }

    public Element get(String string) {
        if (null == this.list) {
            this.buildList();
        }
        return (Element)this.list.get(string.toLowerCase());
    }

    public void reset(String string) {
        this.from = string;
        this.list = null;
    }

    public Element appendUnit(String string) {
        Element element = this.document.createElement(LINKEDPAGEUNIT);
        element.setAttribute(PAGE, this.from);
        element.setAttribute(RESOURCE, string);
        this.linkedPageTag.appendChild(element);
        this.list.put(string.toLowerCase(), element);
        return element;
    }

    private Element getLinkedPageTag(Element element) {
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        for (int i = nodeList.getLength() - 1; 0 <= i; --i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType() || !LINKEDPAGE.equals(node.getNodeName())) continue;
            element2 = (Element)node;
            break;
        }
        if (null == element2) {
            element2 = this.document.createElement(LINKEDPAGE);
            element.appendChild(element2);
        }
        return element2;
    }

    private void buildList() {
        this.list = new Hashtable();
        for (int i = this.linkedPageNodeList.getLength() - 1; 0 <= i; --i) {
            Element element = (Element)this.linkedPageNodeList.item(i);
            String string = element.getAttribute(PAGE);
            try {
                if (!this.from.equalsIgnoreCase(string)) continue;
                String string2 = element.getAttribute(RESOURCE);
                this.list.put(string2.toLowerCase(), element);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

