/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JProgressBar;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import jp.co.nri.rid.analyzer.BaseURL;
import jp.co.nri.rid.analyzer.HTMLAnalyzer;
import jp.co.nri.rid.analyzer.HyperLinkMappingScript;
import jp.co.nri.rid.analyzer.LinkList;
import jp.co.nri.rid.analyzer.LinkedPageList;
import jp.co.nri.rid.analyzer.MapXmlAnalizer;
import jp.co.nri.rid.analyzer.RWarningException;
import jp.co.nri.rid.analyzer.ResourceMappingScript;
import jp.co.nri.rid.analyzer.SSIMappingScript;
import jp.co.nri.rid.analyzer.SWFMappingScript;
import jp.co.nri.rid.analyzer.ScriptingMapper;
import jp.co.nri.rid.analyzer.iExceptionCode;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.importer.RIgnoreFiles;
import jp.co.nri.rid.mapper.Mapper;
import jp.co.nri.rid.xml.Attribute;
import jp.co.nri.rid.xml.SiteXmlAnalizer;
import jp.co.nri.rid.xml.documentBooster;
import jp.co.nri.rid.xml.elementBooster;
import org.w3c.dom.Document;

public class RHTMLAnalyzer
implements iExceptionCode {
    private static final String PAGEUNIT = "PageUnit";
    private static final String FILE = "File";
    private static final String PAGE = "Page";
    private static final String EXIST = "Exist";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String KEY_TEMPLATE = "rid.template.dir";
    private static final String MAP_PROGRESS = "progress_map.xml";
    private static final String XML_REPORT = "report.xml";
    private static final String ELEMENT_ROOT = "RidProject";
    private static final String SEPARATOR = "/";
    private static final String SERVER = "server";
    private static final String PAGETYPE = "PageType";
    private static final String ZONEUNIT = "ZoneUnit";
    private static final String LINKEDPAGE = "LinkedPage";
    private static final String DETAIL = "DetailInfo";
    private static final String ANALYZER_DETAILINFO = "analyzer.detailinfo";
    private documentBooster myDocument;
    private String myMapfile;
    private String myHtmldir;
    private Attribute NotExistsAttribute;
    private Attribute ExistsAttribute;

    public RHTMLAnalyzer(Document document, String string) throws RidException {
        ZResource zResource = ZApp.getTheApp().getResource();
        this.myDocument = new documentBooster(document);
        String string2 = zResource.getString(KEY_TEMPLATE);
        if (null == string2) {
            throw new RidException(new RidMessage().Error("E2020", KEY_TEMPLATE));
        }
        this.myMapfile = string + File.separator + string2 + File.separator + MAP_PROGRESS;
        this.myHtmldir = Ridual.getHtmlDir();
        this.ExistsAttribute = new Attribute(EXIST, TRUE);
        this.NotExistsAttribute = new Attribute(EXIST, FALSE);
    }

    public void analyze(JProgressBar jProgressBar, BaseURL baseURL) throws RidException {
        String string;
        Attribute[] attributeArray;
        CharSequence charSequence;
        Object object;
        RWarningException rWarningException = new RWarningException();
        documentBooster documentBooster2 = new documentBooster((Document)ZInstance.map().get("document.resource"));
        elementBooster elementBooster2 = documentBooster2.root();
        elementBooster2.removeChildren(LINKEDPAGE);
        elementBooster2.add(LINKEDPAGE);
        SiteXmlAnalizer siteXmlAnalizer = new SiteXmlAnalizer(this.myDocument);
        siteXmlAnalizer.resetLinkExist();
        SiteXmlAnalizer.UnitData[] unitDataArray = siteXmlAnalizer.collecting(PAGEUNIT);
        if (null == unitDataArray) {
            return;
        }
        HTMLAnalyzer hTMLAnalyzer = new HTMLAnalyzer();
        Mapper mapper = new Mapper();
        ScriptingMapper scriptingMapper = new ScriptingMapper();
        documentBooster documentBooster3 = new documentBooster((Document)ZInstance.map().get("document.site"));
        LinkList linkList = new LinkList(documentBooster3.root().element());
        LinkedPageList linkedPageList = new LinkedPageList(documentBooster2.root().element());
        ResourceMappingScript resourceMappingScript = new ResourceMappingScript(documentBooster2.root(), linkedPageList, baseURL);
        HyperLinkMappingScript hyperLinkMappingScript = new HyperLinkMappingScript(documentBooster3.root(), linkList, baseURL);
        SWFMappingScript sWFMappingScript = new SWFMappingScript(documentBooster3.root(), baseURL, hyperLinkMappingScript, resourceMappingScript, new HashMap());
        SSIMappingScript sSIMappingScript = new SSIMappingScript(documentBooster2.root(), resourceMappingScript);
        ZResource zResource = ZApp.getTheApp().getResource();
        try {
            object = new StringTokenizer(zResource.getString(ANALYZER_DETAILINFO), " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                charSequence = ((StringTokenizer)object).nextToken();
                attributeArray = "analyzer.detailinfo." + (String)charSequence;
                if (!zResource.getBoolean((String)attributeArray)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(zResource.getString((String)attributeArray + ".tag"));
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    hTMLAnalyzer.list.put(string, string);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        hTMLAnalyzer.addFilter(resourceMappingScript.names());
        hTMLAnalyzer.addFilter(hyperLinkMappingScript.names());
        hTMLAnalyzer.addFilter(sWFMappingScript.names());
        hTMLAnalyzer.addFilter(sSIMappingScript.names());
        try {
            hTMLAnalyzer.addFilter(new MapXmlAnalizer(new documentBooster(this.myMapfile)).getInTag());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RidException(new RidMessage().Error("E2030", parserConfigurationException.toString()));
        }
        try {
            object = new ReportXml();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RidException(new RidMessage().Error("E2030", parserConfigurationException.toString()));
        }
        int n = unitDataArray.length;
        string = SEPARATOR + n + " (pages)";
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(n);
        try {
            jProgressBar.setIndeterminate(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            jProgressBar.setValue(n2);
            jProgressBar.setString(n2 + string);
            String string2 = unitDataArray[i].file;
            if (RIgnoreFiles.ignorefile(string2)) continue;
            elementBooster elementBooster3 = unitDataArray[i].element;
            boolean bl = SERVER.equals(elementBooster3.attribute(PAGETYPE));
            Attribute attribute = new Attribute(FILE, string2);
            ((ReportXml)object).flash();
            try {
                charSequence = new StringBuffer(this.myHtmldir);
                ((StringBuffer)charSequence).append(File.separator);
                ((StringBuffer)charSequence).append(string2);
                elementBooster3.removeChildren(DETAIL);
                attributeArray = hTMLAnalyzer.analyze(((StringBuffer)charSequence).toString(), elementBooster3.add(DETAIL));
                if (hTMLAnalyzer.getEmptyStack()) {
                    rWarningException.add("W2030", string2);
                }
                if (!bl) {
                    ((ReportXml)object).add(PAGE, attribute, this.ExistsAttribute);
                }
                ((ReportXml)object).add(PAGE, attribute, attributeArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!bl) {
                    ((ReportXml)object).add(PAGE, attribute, this.NotExistsAttribute);
                }
            }
            catch (IOException iOException) {
                rWarningException.add("W2010", string2);
            }
            catch (BadLocationException badLocationException) {
                rWarningException.add("W2020", string2);
            }
            catch (Throwable throwable) {
                rWarningException.add("W2000", string2 + " (" + throwable.toString() + ")");
                throwable.printStackTrace();
            }
            try {
                mapper.Type1Xml(this.myDocument.root().element(), this.myMapfile, ((ReportXml)object).element.element());
            }
            catch (Exception exception) {
                // empty catch block
            }
            linkedPageList.reset(string2);
            try {
                scriptingMapper.mapping(((ReportXml)object).element, resourceMappingScript);
            }
            catch (RWarningException rWarningException2) {
                rWarningException.add(rWarningException2);
            }
            linkList.reset(string2);
            try {
                scriptingMapper.mapping(((ReportXml)object).element, hyperLinkMappingScript);
            }
            catch (RWarningException rWarningException3) {
                rWarningException.add(rWarningException3);
            }
            try {
                scriptingMapper.mapping(((ReportXml)object).element, sWFMappingScript);
            }
            catch (RWarningException rWarningException4) {
                rWarningException.add(rWarningException4);
            }
            try {
                scriptingMapper.mapping(((ReportXml)object).element, sSIMappingScript);
                continue;
            }
            catch (RWarningException rWarningException5) {
                rWarningException.add(rWarningException5);
            }
        }
        if (0 < rWarningException.length()) {
            throw new RidException(rWarningException.getMessage());
        }
    }

    private class ReportXml {
        private elementBooster myRoot;
        public elementBooster element;

        public ReportXml() throws ParserConfigurationException {
            documentBooster documentBooster2 = new documentBooster(RHTMLAnalyzer.XML_REPORT, RHTMLAnalyzer.ELEMENT_ROOT);
            this.myRoot = documentBooster2.root();
        }

        public void flash() {
            this.element = this.myRoot.newElement(RHTMLAnalyzer.ELEMENT_ROOT);
        }

        public void add(String string, Attribute attribute, Attribute[] attributeArray) {
            elementBooster elementBooster2 = this.element.add(string);
            elementBooster2.attribute(attribute.name, attribute.value);
            int n = attributeArray.length;
            for (int i = 0; i < n; ++i) {
                Attribute attribute2 = attributeArray[i];
                String string2 = attribute2.value;
                Attribute[] attributeArray2 = attribute2.options();
                if (null == string2 && null == attributeArray2) continue;
                elementBooster elementBooster3 = elementBooster2.add(attribute2.name);
                elementBooster3.text(string2);
                if (null == attributeArray2) continue;
                int n2 = attributeArray2.length;
                for (int j = 0; j < n2; ++j) {
                    elementBooster3.attribute(attributeArray2[j].name, attributeArray2[j].value);
                }
            }
        }

        public void add(String string, Attribute attribute, Attribute attribute2) {
            elementBooster elementBooster2 = this.element.add(string);
            elementBooster2.attribute(attribute.name, attribute.value);
            elementBooster elementBooster3 = elementBooster2.add(attribute2.name);
            elementBooster3.text(attribute2.value);
            Attribute[] attributeArray = attribute2.options();
            if (null != attributeArray) {
                int n = attributeArray.length;
                for (int i = 0; i < n; ++i) {
                    elementBooster3.attribute(attributeArray[i].name, attributeArray[i].value);
                }
            }
        }
    }
}

