/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import jp.co.iti.fagot.util.ZGraphicUtil;

public class EnvColorEditor
extends JPanel {
    protected JPanel mPanel = new JPanel();
    protected JTextField mText = null;
    protected JToggleButton mTButton = null;

    public EnvColorEditor(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mText = new JTextField(string);
        this.setTextColor();
        this.mText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvColorEditor.this.setTextColor();
            }
        });
        this.mPanel.add(this.mText);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.mText, gridBagConstraints);
        this.mTButton = new JToggleButton("Edit");
        this.mTButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvColorEditor.this.colorChooser();
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.mTButton, gridBagConstraints);
        this.mPanel.add(this.mTButton);
    }

    public JPanel getPanel() {
        return this.mPanel;
    }

    public JTextField getTextField() {
        return this.mText;
    }

    public void setString(String string) {
        this.mText.setText(string);
    }

    public String getString() {
        String string = this.mText.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    public JToggleButton getTButton() {
        return this.mTButton;
    }

    public void colorChooser() {
        Color color = ZGraphicUtil.stringToColor(this.getString());
        Color color2 = JColorChooser.showDialog(this.mPanel, "Choose a color", color);
        if (color2 != null && color2 != color) {
            this.setString(ZGraphicUtil.colorToString(color2));
            this.setTextColor();
        }
        this.mTButton.setSelected(false);
    }

    public void setTextColor() {
        Color color = ZGraphicUtil.stringToColor(this.getString());
        if (color != null) {
            this.mText.setForeground(ZGraphicUtil.inverseColor(color));
            this.mText.setBackground(color);
        } else {
            this.mText.setForeground(Color.black);
            this.mText.setBackground(Color.white);
        }
    }
}

