/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EnvDialog
extends JDialog {
    public JFrame mFrame;
    public String mDialogName;
    public boolean mIsOK = false;
    protected JComponent mComponent = null;
    protected JScrollPane mScroll = null;
    protected JPanel mButtonPanel = null;
    protected JButton mOk = null;
    protected JButton mCancel = null;

    public EnvDialog(JFrame jFrame, String string) {
        super((Frame)jFrame, false);
        this.mFrame = jFrame;
        this.mDialogName = string;
        this.setTitle();
    }

    public boolean doModal() {
        this.setModal(true);
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = (int)((double)dimension.width * 0.9);
        int n2 = (int)((double)dimension.height * 0.9);
        int n3 = Math.min(n, this.getWidth());
        int n4 = Math.min(n2, this.getHeight());
        this.setSize(new Dimension(n3, n4));
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.getRootPane().setDefaultButton(this.mOk);
        this.show();
        return this.isOK();
    }

    public boolean isOK() {
        return this.mIsOK;
    }

    protected void setTitle() {
        this.setTitle(this.mDialogName);
    }

    public void hide() {
        super.hide();
    }

    public void setComponent(JComponent jComponent, boolean bl) {
        this.mComponent = jComponent;
        if (bl) {
            this.mScroll = new JScrollPane();
            this.mScroll.setViewportView(this.mComponent);
            this.getContentPane().add("Center", this.mScroll);
        } else {
            this.getContentPane().add("Center", this.mComponent);
        }
    }

    public void onOK() {
        this.mIsOK = true;
        this.setVisible(false);
    }

    public void onCancel() {
        this.mIsOK = false;
        this.setVisible(false);
    }

    public void setControlPanel(JComponent jComponent) {
        JPanel jPanel = this.createControlPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.setComponent(jComponent, true);
        this.getContentPane().add((Component)jPanel, "South");
    }

    public JPanel createControlPanel() {
        this.mButtonPanel = new JPanel();
        this.mOk = new JButton("Ok");
        this.mCancel = new JButton("Cancel");
        this.mOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvDialog.this.onOK();
            }
        });
        this.mCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvDialog.this.onCancel();
            }
        });
        this.mButtonPanel.add(this.mOk);
        this.mButtonPanel.add(this.mCancel);
        return this.mButtonPanel;
    }

    public String getDialogName() {
        return this.mDialogName;
    }

    public JButton getOKButton() {
        return this.mOk;
    }

    public void setOkText(String string) {
        this.mOk.setText(string);
    }

    public String getOkText() {
        return this.mOk.getText();
    }

    public void setCancelText(String string) {
        this.mCancel.setText(string);
    }

    public String getCancelText() {
        return this.mCancel.getText();
    }

    public JPanel getButtonPanel() {
        return this.mButtonPanel;
    }

    public JButton getCancelButton() {
        return this.mCancel;
    }

    public JComponent getComponent() {
        return this.mComponent;
    }

    public JScrollPane getScrollComponent() {
        return this.mScroll;
    }
}

