/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.export;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.fob.xml.XDocument;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.doc.RidExecAction;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.export.ExportDialog;
import jp.co.nri.rid.export.exporter;

public class ExportSvgDialog {
    protected JPanel mPanel = null;
    protected JCheckBox mBrowser = null;
    protected JComboBox mBrowserLst = null;
    protected JTextField mImportComment = null;

    public boolean show(String string, boolean bl) {
        JLabel jLabel;
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        ExportDialog exportDialog = new ExportDialog(jFrame, "SVG");
        this.mPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        if (bl) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jLabel = new JLabel("Comment");
            this.mPanel.add(jLabel);
            gridBagConstraints.gridx = 1;
            this.mPanel.add(new JLabel(" "));
            gridBagConstraints.gridx = 2;
            this.mImportComment = this.createImportComment();
            gridBagLayout.setConstraints(this.mImportComment, gridBagConstraints);
            this.mPanel.add(this.mImportComment);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jLabel = new JLabel("Browser:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        this.mBrowser = this.createBrowserCheckBox();
        gridBagLayout.setConstraints(this.mBrowser, gridBagConstraints);
        this.mPanel.add(this.mBrowser);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        this.mBrowserLst = this.createBrowserComboBox();
        gridBagLayout.setConstraints(this.mBrowserLst, gridBagConstraints);
        this.mPanel.add(this.mBrowserLst);
        exportDialog.setControlPanel(this.mPanel);
        exportDialog.getRootPane().setDefaultButton(exportDialog.getOKButton());
        exportDialog.doModal();
        boolean bl2 = exportDialog.isOK();
        if (bl2) {
            this.showSVG(string, bl);
        }
        return bl2;
    }

    private JCheckBox createBrowserCheckBox() {
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl = zResource.getBoolean("svg.browser");
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        return jCheckBox;
    }

    private JTextField createImportComment() {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString("svg.comment");
        JTextField jTextField = new JTextField(string, 35);
        return jTextField;
    }

    private String getSVGComment() {
        String string = this.mImportComment.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private JComboBox createBrowserComboBox() {
        String string;
        String string2;
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        ZResource zResource = ZApp.getTheApp().getResource();
        int n = 1;
        while ((string2 = zResource.getString(string = "generate.browser_command." + Integer.toString(n))) != null) {
            jComboBox.addItem(this.makeObj(string2));
            ++n;
        }
        return jComboBox;
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private void showSVG(String string, boolean bl) {
        Object object;
        Object object2;
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putBoolean("svg.browser", this.mBrowser.isSelected());
        int n = this.mBrowserLst.getSelectedIndex();
        String string2 = "generate.browser_command." + Integer.toString(n + 1);
        zResource.putString("generate.browser_command", zResource.getString(string2));
        if (bl) {
            zResource.putString("svg.comment", this.getSVGComment());
        }
        if (this.mBrowser.isSelected()) {
            object2 = zResource.getString("generate.browser_command") + " ";
            try {
                string = new File(string).toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            if (!RidExecAction.exec((String)object2, string)) {
                object = new RidMessage();
                MessageDialog.showError(((RidMessage)object).Error("E1901", (String)object2 + " " + string));
            }
        }
        if (bl) {
            object2 = (DocDocument)((Object)ZInstance.map().get("document.document"));
            ((XDocument)((Object)object2)).beginTransaction();
            try {
                object = ZInstance.prop().getProperty("pj.dir");
                ZResource zResource2 = ZApp.getTheApp().getResource();
                String string3 = (String)object + File.separator + zResource2.getString("rid.docs.dir");
                exporter exporter2 = new exporter();
                exporter2.export(string3, string, 1);
                ((XDocument)((Object)object2)).commit();
            }
            catch (Throwable throwable) {
                ZDebug.trace("failed");
                throwable.printStackTrace();
                ((XDocument)((Object)object2)).rollback();
            }
        }
    }
}

