/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.generator;

import java.io.File;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.generator.GenerateNavibar;
import jp.co.nri.rid.generator.GenerateParser;
import jp.co.nri.rid.generator.GenerateRefresh;
import jp.co.nri.rid.mapper.Mapper;
import jp.co.nri.rid.mapper.XmlUtil;
import jp.co.nri.rid.snapshot.erase;
import jp.co.nri.rid.snapshot.xcopy;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateProduct
extends GenerateParser {
    public static final String RID_TEMPLATE_DIR = "rid.template.dir";
    public static final String RID_PARTS_DIR = "rid.parts.dir";
    public static final String RID_TEAM_DIR = "rid.team.dir";
    public static final String RID_PAGESVG_DIR = "rid.pagesvg.dir";
    protected String pr_url = "";
    protected String pr_templateDir = "";
    protected String pr_partsDir = "";
    protected String pr_outDir = "";
    protected String pr_htmlDir = "";
    protected String pr_svgDir = "";

    public boolean generate(Document document, String string) throws RidException, Exception {
        boolean bl = false;
        RidMessage ridMessage = new RidMessage();
        this.getDir(string);
        erase erase2 = new erase();
        bl = erase2.directory(this.pr_outDir);
        if (!bl) {
            ZDebug.trace(ridMessage.Warning("W4003", this.pr_outDir));
        }
        GenerateParser.ProjectInfo projectInfo = new GenerateParser.ProjectInfo();
        projectInfo = this.documentParser(document, "", this.parentPath(this.pr_outDir, this.pr_htmlDir));
        bl = this.generateProduct(projectInfo);
        return bl;
    }

    public String getUrl() {
        return this.pr_url;
    }

    private void setUrl(String string) {
        this.pr_url = string;
    }

    private void getDir(String string) {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string2 = zResource.getString(RID_TEMPLATE_DIR);
        String string3 = zResource.getString(RID_PARTS_DIR);
        String string4 = zResource.getString(RID_TEAM_DIR);
        String string5 = zResource.getString(RID_PAGESVG_DIR);
        this.pr_templateDir = string + File.separator + string2;
        this.pr_outDir = string + File.separator + string4;
        this.pr_htmlDir = Ridual.getHtmlDir();
        this.pr_partsDir = string + File.separator + string3;
        this.pr_svgDir = string + File.separator + string5;
    }

    private boolean generateProduct(GenerateParser.ProjectInfo projectInfo) throws Exception {
        boolean bl = false;
        GenerateParser.ZoneInfo zoneInfo = projectInfo.zone;
        bl = this.productZone(zoneInfo, null);
        if (bl) {
            String string;
            Object object;
            if (zoneInfo.page_lst.size() != 0) {
                object = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(0);
                this.setUrl(((GenerateParser.PageInfo)object).url);
                string = ((GenerateParser.PageInfo)object).name;
            } else {
                this.setUrl(this.pr_outDir + File.separator + "Blank" + "_frame.html");
                string = "Blank";
            }
            object = new GenerateRefresh();
            bl = ((GenerateRefresh)object).generateRefresh(this.pr_templateDir, this.pr_outDir, string);
        }
        return bl;
    }

    private boolean productZone(GenerateParser.ZoneInfo zoneInfo, GenerateParser.ZoneInfo zoneInfo2) throws Exception {
        Object object;
        boolean bl = false;
        if (!zoneInfo.top) {
            xcopy xcopy2 = new xcopy();
            xcopy2.makeDir(this.pr_outDir + File.separator + zoneInfo.file);
        }
        if (zoneInfo.page_lst.size() > 0) {
            for (int i = 0; i < zoneInfo.page_lst.size(); ++i) {
                object = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(i);
                bl = this.productPage(zoneInfo, (GenerateParser.PageInfo)object);
                if (bl) continue;
                return false;
            }
        } else {
            this.productFrame(zoneInfo, null);
        }
        for (int i = 0; i < zoneInfo.zone_lst.size(); ++i) {
            object = (GenerateParser.ZoneInfo)zoneInfo.zone_lst.elementAt(i);
            bl = this.productZone((GenerateParser.ZoneInfo)object, zoneInfo);
            if (bl) continue;
            return false;
        }
        GenerateNavibar generateNavibar = new GenerateNavibar();
        bl = generateNavibar.generate("Product", this.pr_templateDir, this.pr_outDir, zoneInfo, zoneInfo2);
        return bl;
    }

    private boolean productPage(GenerateParser.ZoneInfo zoneInfo, GenerateParser.PageInfo pageInfo) throws RidException, Exception {
        boolean bl = false;
        this.productFrame(zoneInfo, pageInfo);
        this.generateProductSample(pageInfo);
        this.generateProductInfo(pageInfo);
        return true;
    }

    private boolean productFrame(GenerateParser.ZoneInfo zoneInfo, GenerateParser.PageInfo pageInfo) throws RidException, Exception {
        String string;
        boolean bl = false;
        xcopy xcopy2 = new xcopy();
        RidMessage ridMessage = new RidMessage();
        String string2 = this.pr_templateDir + File.separator + "_frameProduct.html";
        if (!xcopy2.fileExists(string2)) {
            throw new RidException(ridMessage.Error("E4001", string2));
        }
        String string3 = this.pr_templateDir + File.separator + "_frame_map.xml";
        if (!xcopy2.fileExists(string3)) {
            throw new RidException(ridMessage.Error("E4001", string3));
        }
        if (pageInfo != null) {
            pageInfo.url = string = this.pr_outDir + File.separator + pageInfo.file + "_frame.html";
        } else {
            string = zoneInfo.top ? this.pr_outDir + File.separator + "Blank" + "_frame.html" : this.pr_outDir + File.separator + zoneInfo.file + File.separator + "Blank" + "_frame.html";
        }
        Document document = this.generateFrameMapData(zoneInfo.name, pageInfo);
        Mapper mapper = new Mapper();
        if (!mapper.Type1(string2, string3, document, string)) {
            throw new RidException(ridMessage.Error("E4002", "Mapper" + mapper.getErrorString()));
        }
        return true;
    }

    private Document generateFrameMapData(String string, GenerateParser.PageInfo pageInfo) throws Exception {
        XmlUtil xmlUtil = new XmlUtil();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("RidProject");
        documentImpl.appendChild(element);
        String string2 = string + "_navi.html";
        Element element2 = xmlUtil.createSubElement(element, "frame_data");
        element2.setAttribute("name", "navi");
        xmlUtil.createOrSetTextValue(element2, "src", string2);
        if (pageInfo != null) {
            String string3 = pageInfo.name + "_sample.html";
            element2 = xmlUtil.createSubElement(element, "frame_data");
            element2.setAttribute("name", "sample");
            xmlUtil.createOrSetTextValue(element2, "src", string3);
            String string4 = pageInfo.name + "_info.html";
            element2 = xmlUtil.createSubElement(element, "frame_data");
            element2.setAttribute("name", "info");
            xmlUtil.createOrSetTextValue(element2, "src", string4);
            String string5 = this.replaceWebFileSeparator(pageInfo.path + File.separator + pageInfo.file);
            element2 = xmlUtil.createSubElement(element, "frame_data");
            element2.setAttribute("name", "main");
            xmlUtil.createOrSetTextValue(element2, "src", string5);
        }
        return documentImpl;
    }

    private boolean generateProductInfo(GenerateParser.PageInfo pageInfo) throws RidException, Exception {
        boolean bl = false;
        xcopy xcopy2 = new xcopy();
        RidMessage ridMessage = new RidMessage();
        String string = this.pr_templateDir + File.separator + "_info.html";
        if (!xcopy2.fileExists(string)) {
            throw new RidException(ridMessage.Error("E4001", string));
        }
        String string2 = this.pr_outDir + File.separator + pageInfo.file + "_info.html";
        Mapper mapper = new Mapper();
        Document document = this.generateInfoData(pageInfo);
        if (!mapper.Type2(string, document, string2)) {
            throw new RidException(ridMessage.Error("E4002", mapper.getErrorString()));
        }
        return true;
    }

    private Document generateInfoData(GenerateParser.PageInfo pageInfo) throws Exception {
        XmlUtil xmlUtil = new XmlUtil();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("RidProject");
        documentImpl.appendChild(element);
        for (int i = 0; i < pageInfo.attr_lst.size(); ++i) {
            GenerateParser.Attribute attribute = (GenerateParser.Attribute)pageInfo.attr_lst.elementAt(i);
            xmlUtil.createOrSetTextValue(element, attribute.name, attribute.value);
        }
        return documentImpl;
    }

    private boolean generateProductSample(GenerateParser.PageInfo pageInfo) throws RidException, Exception {
        Object object;
        String string;
        String string2;
        boolean bl = false;
        xcopy xcopy2 = new xcopy();
        RidMessage ridMessage = new RidMessage();
        if (!pageInfo.svg.equals("")) {
            string2 = this.pr_svgDir + File.separator + pageInfo.svg;
            string = this.pr_outDir + File.separator + pageInfo.file + "_svg.svg";
            bl = xcopy2.file(string2, string);
        } else if (!pageInfo.doc.equals("")) {
            string2 = this.Document2SampleFile(pageInfo.doc);
            string = this.pr_svgDir + File.separator + string2;
            object = this.pr_outDir + File.separator + pageInfo.file + "_" + string2;
            bl = xcopy2.file(string, (String)object);
        }
        string2 = this.pr_templateDir + File.separator + "_sample.html";
        if (!xcopy2.fileExists(string2)) {
            throw new RidException(ridMessage.Error("E4001", string2));
        }
        string = this.pr_outDir + File.separator + pageInfo.file + "_sample.html";
        Mapper mapper = new Mapper();
        object = this.generateSampleData(pageInfo);
        if (!mapper.Type2(string2, (Document)object, string)) {
            throw new RidException(ridMessage.Error("E4002", mapper.getErrorString()));
        }
        return true;
    }

    private Document generateSampleData(GenerateParser.PageInfo pageInfo) throws Exception {
        XmlUtil xmlUtil = new XmlUtil();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("RidProject");
        documentImpl.appendChild(element);
        xmlUtil.createOrSetTextValue(element, "Title", pageInfo.name + "_sample.html");
        if (!pageInfo.svg.equals("")) {
            xmlUtil.createOrSetTextValue(element, "sample", "<embed src=\"" + pageInfo.name + "_svg.svg" + "\" height=\"300\" width=\"400\" type=\"image/svg-xml\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\">");
        } else if (!pageInfo.doc.equals("")) {
            String string = this.Document2SampleFile(pageInfo.doc);
            String string2 = this.trimPath(pageInfo.file + "_" + string);
            xmlUtil.createOrSetTextValue(element, "sample", "<a href=\"" + string2 + "\" target=\"_blank\">" + string2 + "</a>");
        } else {
            xmlUtil.createOrSetTextValue(element, "sample", "<br><br><br><center> Now Thinking!</center>");
        }
        return documentImpl;
    }

    private String Document2SampleFile(String string) throws Exception {
        String string2;
        String string3;
        String string4 = string;
        String string5 = this.getDocfileExt(string);
        ZResource zResource = ZApp.getTheApp().getResource();
        int n = 1;
        while (!this.isNullString(string3 = zResource.getString(string2 = "command.doc.ext." + Integer.toString(n)))) {
            if (string3.equalsIgnoreCase(string5)) {
                string2 = "command.doc.view." + Integer.toString(n);
                String string6 = zResource.getString(string2);
                if (this.isNullString(string6)) break;
                string4 = this.getDocfileName(string) + "." + string6;
                break;
            }
            ++n;
        }
        return string4;
    }

    private String getDocfileExt(String string) throws Exception {
        String string2 = "";
        int n = string.indexOf(".");
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private String getDocfileName(String string) throws Exception {
        String string2 = string;
        int n = string.indexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String trimPath(String string) {
        int n = string.lastIndexOf("/");
        if (n == string.length()) {
            return "";
        }
        return string.substring(n + 1);
    }
}

