/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.o3w;

import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.nri.rid.o3w.O3W_Xml;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class O3W_Exporter
extends O3W_Xml {
    private static final String PAGETYPE_SERVER = "server";
    private static final String PAGETYPE_DYNAMIC = "dynamic";
    private static final String WEB_FILESEPARATOR = "/";
    Vector PageUnitList = new Vector();
    Vector NextPageList = new Vector();
    Element top_zone_elem = null;
    Element zone_elem = null;
    Element link_elem = null;
    String export_file = "";

    public int Export(Element element, String string) throws Exception {
        this.init();
        return this.analyzeZoneUnit(element, string);
    }

    private void init() throws Exception {
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        Element element = docDocument.getDocumentElement();
        this.top_zone_elem = (Element)XPathAPI.selectSingleNode((Node)element, (String)"ZoneUnit");
        this.link_elem = (Element)XPathAPI.selectSingleNode((Node)element, (String)"Link");
    }

    private int analyzeZoneUnit(Element element, String string) throws Exception {
        this.zone_elem = element;
        int n = this.checkZoneAttributes(element);
        if (n == 0) {
            String string2;
            this.export_file = string2 = element.getAttribute("File");
            String string3 = element.getAttribute("ControlId");
            String string4 = element.getAttribute("Top");
            String string5 = element.getAttribute("Error");
            String string6 = element.getAttribute("DefaultDSID");
            if (!this.IsTopZoneUnit(string2)) {
                string4 = string2 + WEB_FILESEPARATOR + string4;
                string5 = string2 + WEB_FILESEPARATOR + string5;
            }
            this.crtPageList(element);
            this.xmlExport(string, string3, string6, string4, string5);
        }
        return n;
    }

    private int checkZoneAttributes(Element element) throws Exception {
        int n = element.getAttribute("ControlId").equals("") ? 1 : (element.getAttribute("Top").equals("") ? 2 : (element.getAttribute("Error").equals("") ? 3 : 0));
        return n;
    }

    private boolean IsTopZoneUnit(String string) throws Exception {
        boolean bl = false;
        String string2 = this.top_zone_elem.getAttribute("File");
        if (string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private void crtPageList(Element element) throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)"PageUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            clsPageUnit clsPageUnit2 = new clsPageUnit();
            clsPageUnit2.file = element2.getAttribute("File");
            clsPageUnit2.flag = false;
            this.PageUnitList.add(clsPageUnit2);
        }
    }

    private void setPageList(String string) throws Exception {
        for (int i = 0; i < this.PageUnitList.size(); ++i) {
            clsPageUnit clsPageUnit2 = (clsPageUnit)this.PageUnitList.elementAt(i);
            if (!clsPageUnit2.file.equals(string)) continue;
            clsPageUnit2.flag = true;
            break;
        }
    }

    private boolean getPageList(String string) throws Exception {
        boolean bl = false;
        for (int i = 0; i < this.PageUnitList.size(); ++i) {
            clsPageUnit clsPageUnit2 = (clsPageUnit)this.PageUnitList.elementAt(i);
            if (!clsPageUnit2.file.equals(string)) continue;
            bl = clsPageUnit2.flag;
            break;
        }
        return bl;
    }

    private void xmlExport(String string, String string2, String string3, String string4, String string5) throws Exception {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("ControlDefinition");
        documentImpl.appendChild(element);
        Element element2 = documentImpl.getDocumentElement();
        Element element3 = this.createSubElement(element2, "ControlId");
        this.setTextValue(element3, string2);
        if (!string3.equals("")) {
            element3 = this.createSubElement(element2, "DefaultDSID");
            this.setTextValue(element3, string3);
        }
        this.createControlProcess(element2, this.setTopCtrlProc(string4));
        this.createControlProcess(element2, this.setErrorCtrlProc(string5));
        this.exportControlProcess(element2, string4);
        while (!this.NextPageList.isEmpty()) {
            String string6 = (String)this.NextPageList.get(0);
            if (!this.getPageList(string6)) {
                this.exportControlProcess(element2, string6);
            }
            this.NextPageList.remove(0);
        }
        this.writeDocment2XMLFile(string, (Document)documentImpl);
    }

    private O3W_Xml.clsControlProcess setTopCtrlProc(String string) throws Exception {
        O3W_Xml.clsControlProcess clsControlProcess2 = new O3W_Xml.clsControlProcess();
        O3W_Xml.clsNextPage clsNextPage2 = new O3W_Xml.clsNextPage();
        Vector<O3W_Xml.clsNextPage> vector = new Vector<O3W_Xml.clsNextPage>();
        clsNextPage2.ProcRet = "";
        clsNextPage2.NextPageId = this.getNextPageId(string);
        clsNextPage2.NextPageJSPPath = this.getFileName(string);
        clsNextPage2.ControlId = "";
        clsNextPage2.DataStoreId = "";
        vector.add(clsNextPage2);
        clsControlProcess2.PageId = "NoPageID";
        clsControlProcess2.ActionId = "NoActionID";
        clsControlProcess2.PLTr = "";
        clsControlProcess2.NextPage = vector;
        return clsControlProcess2;
    }

    private O3W_Xml.clsControlProcess setErrorCtrlProc(String string) throws Exception {
        O3W_Xml.clsControlProcess clsControlProcess2 = new O3W_Xml.clsControlProcess();
        O3W_Xml.clsNextPage clsNextPage2 = new O3W_Xml.clsNextPage();
        Vector<O3W_Xml.clsNextPage> vector = new Vector<O3W_Xml.clsNextPage>();
        clsNextPage2.ProcRet = "";
        clsNextPage2.NextPageId = this.getNextPageId(string);
        clsNextPage2.NextPageJSPPath = this.getFileName(string);
        clsNextPage2.ControlId = "";
        clsNextPage2.DataStoreId = "";
        vector.add(clsNextPage2);
        clsControlProcess2.PageId = "*PageID";
        clsControlProcess2.ActionId = "*ActionID";
        clsControlProcess2.PLTr = "";
        clsControlProcess2.NextPage = vector;
        return clsControlProcess2;
    }

    private String getNextPageId(String string) throws Exception {
        String string2 = string.substring(Math.max(0, string.lastIndexOf(WEB_FILESEPARATOR) + 1));
        String string3 = string2.substring(0, Math.max(0, string2.lastIndexOf(".")));
        return string3;
    }

    private String getFileName(String string) throws Exception {
        String string2 = string.substring(Math.max(0, string.lastIndexOf(WEB_FILESEPARATOR) + 1));
        return string2;
    }

    private void exportControlProcess(Element element, String string) throws Exception {
        String string2 = this.getPageType(string);
        if (string2.equals(PAGETYPE_SERVER)) {
            this.exportServer(element, string);
        } else if (string2.equals(PAGETYPE_DYNAMIC)) {
            this.exportDynamic(element, string);
        }
        this.setPageList(string);
        Vector vector = this.getLinkUnitList(string);
        for (int i = 0; i < vector.size(); ++i) {
            LinkUnit linkUnit = (LinkUnit)vector.elementAt(i);
            this.NextPageList.add(linkUnit.to);
        }
    }

    public void exportDynamic(Element element, String string) throws Exception {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = this.getLinkUnitList(string);
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            LinkUnit linkUnit = (LinkUnit)vector2.elementAt(i);
            String string6 = this.getPageType(linkUnit.to);
            if (string6.equals(PAGETYPE_SERVER)) continue;
            if (linkUnit.comment.indexOf(";") != -1) {
                object = new StringTokenizer(linkUnit.comment, ";");
                int n = 1;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    if (n == 1) {
                        string2 = ((StringTokenizer)object).nextToken();
                    }
                    if (n == 2) {
                        string3 = ((StringTokenizer)object).nextToken();
                    }
                    if (n == 3) {
                        string4 = ((StringTokenizer)object).nextToken();
                    }
                    if (n == 4) {
                        string5 = ((StringTokenizer)object).nextToken();
                    }
                    ++n;
                }
            }
            object = new O3W_Xml.clsNextPage();
            ((O3W_Xml.clsNextPage)object).ProcRet = linkUnit.condition;
            ((O3W_Xml.clsNextPage)object).NextPageId = this.getNextPageId(linkUnit.to);
            ((O3W_Xml.clsNextPage)object).NextPageJSPPath = this.getFileName(linkUnit.to);
            ((O3W_Xml.clsNextPage)object).ControlId = this.getControlId(string4);
            ((O3W_Xml.clsNextPage)object).DataStoreId = string5;
            if (!this.IstargetZone(string)) {
                ((O3W_Xml.clsNextPage)object).ControlId = "";
                ((O3W_Xml.clsNextPage)object).DataStoreId = "";
            }
            vector.add(object);
        }
        if (vector.size() != 0) {
            O3W_Xml.clsControlProcess clsControlProcess2 = new O3W_Xml.clsControlProcess();
            if (this.IstargetZone(string)) {
                clsControlProcess2.PageId = string2;
                clsControlProcess2.ActionId = string3;
            } else {
                clsControlProcess2.PageId = this.getSubPageId(string4);
                clsControlProcess2.ActionId = this.getSubActionId(string4);
            }
            clsControlProcess2.PLTr = "";
            clsControlProcess2.NextPage = vector;
            this.createControlProcess(element, clsControlProcess2);
        }
    }

    public void exportServer(Element element, String string) throws Exception {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = this.getLinkUnitList(string);
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            LinkUnit linkUnit = (LinkUnit)vector2.elementAt(i);
            String string6 = this.getPageType(linkUnit.to);
            if (string6.equals(PAGETYPE_SERVER)) continue;
            if (linkUnit.comment.indexOf(";") != -1) {
                object = new StringTokenizer(linkUnit.comment, ";");
                int n = 1;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    if (n == 1) {
                        string2 = ((StringTokenizer)object).nextToken();
                    }
                    if (n == 2) {
                        string3 = ((StringTokenizer)object).nextToken();
                    }
                    if (n == 3) {
                        string4 = ((StringTokenizer)object).nextToken();
                    }
                    if (n == 4) {
                        string5 = ((StringTokenizer)object).nextToken();
                    }
                    ++n;
                }
            }
            object = new O3W_Xml.clsNextPage();
            ((O3W_Xml.clsNextPage)object).ProcRet = linkUnit.condition;
            ((O3W_Xml.clsNextPage)object).NextPageId = this.getNextPageId(linkUnit.to);
            ((O3W_Xml.clsNextPage)object).NextPageJSPPath = this.getFileName(linkUnit.to);
            ((O3W_Xml.clsNextPage)object).ControlId = this.getControlId(string4);
            ((O3W_Xml.clsNextPage)object).DataStoreId = string5;
            vector.add(object);
        }
        if (vector.size() != 0) {
            O3W_Xml.clsControlProcess clsControlProcess2 = new O3W_Xml.clsControlProcess();
            clsControlProcess2.PageId = string2;
            clsControlProcess2.ActionId = string3;
            clsControlProcess2.PLTr = this.getPLTr(string);
            clsControlProcess2.NextPage = vector;
            this.createControlProcess(element, clsControlProcess2);
        }
    }

    public boolean IstargetZone(String string) throws Exception {
        boolean bl = false;
        bl = this.IsTopZoneUnit(this.export_file) ? string.indexOf(WEB_FILESEPARATOR) == -1 : string.indexOf(this.export_file) != -1;
        return bl;
    }

    public String getPageType(String string) throws Exception {
        Object object;
        Element element;
        String string2 = "";
        NodeList nodeList = XPathAPI.selectNodeList((Node)this.zone_elem, (String)"PageUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element = (Element)nodeList.item(i);
            object = element.getAttribute("File");
            if (!((String)object).equals(string)) continue;
            string2 = element.getAttribute("PageType");
        }
        if (string2.equals("")) {
            String string3;
            Object object2;
            DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
            element = docDocument.getDocumentElement();
            object = (Element)XPathAPI.selectSingleNode((Node)element, (String)"ZoneUnit");
            String string4 = "";
            string4 = string.substring(0, Math.max(0, string.lastIndexOf(WEB_FILESEPARATOR)));
            if (!string4.equals("")) {
                Object var8_9 = null;
                object2 = new StringTokenizer(string4, WEB_FILESEPARATOR);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string3 = "ZoneUnit[@Name='" + ((StringTokenizer)object2).nextToken() + "']";
                    object = (Element)XPathAPI.selectSingleNode((Node)object, (String)string3);
                }
            }
            nodeList = XPathAPI.selectNodeList((Node)object, (String)"PageUnit");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object2 = (Element)nodeList.item(i);
                string3 = object2.getAttribute("File");
                if (!string3.equals(string)) continue;
                string2 = object2.getAttribute("PageType");
            }
        }
        return string2;
    }

    private Vector getLinkUnitList(String string) throws Exception {
        Vector<LinkUnit> vector = new Vector<LinkUnit>();
        NodeList nodeList = XPathAPI.selectNodeList((Node)this.link_elem, (String)"LinkUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)element, (String)"Connect0");
            String string2 = element2.getAttribute("Key");
            Element element3 = (Element)XPathAPI.selectSingleNode((Node)element, (String)"Connect1");
            String string3 = element3.getAttribute("Key");
            if (!string2.equals(string)) continue;
            LinkUnit linkUnit = new LinkUnit();
            linkUnit.from = string2;
            linkUnit.to = string3;
            linkUnit.comment = element.getAttribute("Comment");
            linkUnit.condition = element.getAttribute("Condition");
            vector.add(linkUnit);
        }
        return vector;
    }

    private String getControlId(String string) throws Exception {
        if (string == null || string.equals("")) {
            return "";
        }
        String string2 = string;
        if (string.indexOf("ReturnPageInfo") != -1) {
            string2 = this.getSubControlId(string);
        }
        return string2;
    }

    private String getPLTr(String string) throws Exception {
        String string2 = "";
        NodeList nodeList = XPathAPI.selectNodeList((Node)this.zone_elem, (String)"PageUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string3 = element.getAttribute("File");
            if (!string3.equals(string)) continue;
            string2 = element.getAttribute("Comment");
            break;
        }
        return string2;
    }

    class LinkUnit {
        String from;
        String to;
        String condition;
        String comment;

        LinkUnit() {
        }
    }

    class clsPageUnit {
        String file;
        boolean flag;

        clsPageUnit() {
        }
    }
}

