/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.search;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import jp.co.nri.rid.search.SPCellRenderer;
import jp.co.nri.rid.search.SPColumnModelListener;
import jp.co.nri.rid.search.SPColumnNames;
import jp.co.nri.rid.search.SPHeaderRenderer;

class SPTableColumnModel
extends DefaultTableColumnModel {
    private static final String SCCSID = "@(#)SPTableColumnModel.java";
    private static final String RCSID = "$Id: SPTableColumnModel.java,v 1.21 2003-07-03 19:09:11+09 nsmr Exp $";
    private static final int[][] WIDTH_ARRAY = new int[][]{{0, 125}, {3, 300}, {4, 175}, {9, 125}, {11, 100}, {12, 100}, {13, 100}, {15, 50}, {20, 125}, {22, 175}, {24, 100}};
    static final int DEFAULT_COLUMN_WIDTH = 75;
    static int[] initialWidths;
    private static int[][] columnWidthArray;
    static final int[] INTEGER_COLUMNS;
    private int target;

    SPTableColumnModel(int n) {
        int[] nArray;
        this.target = n;
        if (columnWidthArray == null) {
            columnWidthArray = new int[9][];
        }
        if (initialWidths == null) {
            this.initDefaultColumnWidths();
        }
        if ((nArray = SPColumnNames.get(n)) == null) {
            return;
        }
        int[] nArray2 = this.getAdjustedWidths();
        SPCellRenderer sPCellRenderer = new SPCellRenderer(n);
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            int n2 = nArray[i];
            String string = SPColumnNames.toString(n2);
            tableColumn.setHeaderValue(string);
            if (nArray2 == null) {
                this.setDefaultColumnWidth(tableColumn, n2);
            } else if (i < 0 || nArray2.length <= i) {
                this.setDefaultColumnWidth(tableColumn, n2);
            } else {
                tableColumn.setPreferredWidth(nArray2[i]);
            }
            tableColumn.setHeaderRenderer(new SPHeaderRenderer());
            if (n == 3) {
                tableColumn.setCellRenderer(sPCellRenderer);
            }
            this.addColumn(tableColumn);
        }
        this.addColumnModelListener(new SPColumnModelListener());
    }

    private void initDefaultColumnWidths() {
        int n;
        initialWidths = new int[28];
        for (n = 0; n < 28; ++n) {
            SPTableColumnModel.initialWidths[n] = 75;
        }
        for (n = 0; n < WIDTH_ARRAY.length; ++n) {
            if (WIDTH_ARRAY[n] == null || WIDTH_ARRAY[n].length < 2) continue;
            SPTableColumnModel.initialWidths[SPTableColumnModel.WIDTH_ARRAY[n][0]] = WIDTH_ARRAY[n][1];
        }
    }

    private void setDefaultColumnWidth(TableColumn tableColumn, int n) {
        if (n < 0 || initialWidths.length <= n) {
            tableColumn.setPreferredWidth(75);
            return;
        }
        tableColumn.setPreferredWidth(initialWidths[n]);
    }

    public boolean getColumnSelectionAllowed() {
        return true;
    }

    int[] getAdjustedWidths() {
        if (this.target < 0 || 9 < this.target) {
            return null;
        }
        return columnWidthArray[this.target];
    }

    static boolean isIntegerColumn(int n) {
        for (int i = 0; i < INTEGER_COLUMNS.length; ++i) {
            if (INTEGER_COLUMNS[i] != n) continue;
            return true;
        }
        return false;
    }

    void setAdjustedWidths(int[] nArray) {
        if (this.target < 0 || 9 < this.target) {
            return;
        }
        SPTableColumnModel.columnWidthArray[this.target] = nArray;
    }

    static {
        INTEGER_COLUMNS = new int[]{6, 7, 8, 16, 18, 19, 23, 27};
    }
}

