/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.table.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import jp.co.nri.rid.table.editor.CECAdapter;
import jp.co.nri.rid.table.editor.iCellEditorComponent;

public class ColorCEC
extends JPanel
implements iCellEditorComponent,
FocusListener {
    private JButton myButton = new JButton("...");
    private JTextField myTextField;

    public ColorCEC(boolean bl, ActionListener actionListener) {
        super(new BorderLayout());
        this.myButton.addActionListener(actionListener);
        this.myButton.addActionListener(new actionChoose(this));
        this.myTextField = new JTextField();
        this.myTextField.setBorder(null);
        this.myTextField.addActionListener(actionListener);
        if (actionListener instanceof CECAdapter) {
            ((CECAdapter)actionListener).editor(this);
        }
        this.editable(bl);
        this.add((Component)this.myTextField, "Center");
        this.add((Component)this.myButton, "East");
        this.addFocusListener(this);
    }

    public String text() {
        return this.myTextField.getText();
    }

    public void text(String string) {
        int n = 0;
        try {
            n = this.hex(string);
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        this.ButtonColor(n);
        if (null == string) {
            this.myTextField.setText(null);
        } else {
            this.myTextField.setText(string);
        }
    }

    public JComponent component() {
        return this;
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    public void ButtonColor(int n) {
        this.myButton.setBackground(this.color(n));
        this.myButton.setForeground(this.color(0xFFFFFF - n));
    }

    public Color color(int n) {
        int n2 = 0xFF & n >>> 16;
        int n3 = 0xFF & n >>> 8;
        int n4 = 0xFF & n;
        return new Color(n2, n3, n4);
    }

    private Color color(String string) {
        int n = 0;
        try {
            n = this.hex(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.color(n);
    }

    public String text(Color color) {
        if (null == color) {
            return null;
        }
        int n = (0xFF & color.getRed()) << 16;
        int n2 = (0xFF & color.getGreen()) << 8;
        int n3 = 0xFF & color.getBlue();
        int n4 = n | n2 | n3;
        return "#" + this.hex(n4, 6);
    }

    public int hex(String string) throws NumberFormatException {
        int n;
        int n2;
        if (null == string) {
            return 0;
        }
        if (0 >= string.length()) {
            return 0;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if ('#' != stringBuffer.charAt(0)) {
            return 0;
        }
        stringBuffer.deleteCharAt(0);
        for (n2 = stringBuffer.length() - 1; 0 <= n2; --n2) {
            n = stringBuffer.charAt(n2);
            if (48 <= n && 57 >= n || 65 <= n && 70 >= n || 97 <= n && 102 >= n) continue;
            return 0;
        }
        n2 = Integer.parseInt(new String(stringBuffer), 16);
        switch (string.length()) {
            case 7: {
                return n2;
            }
            case 4: {
                n = n2 >> 8;
                int n3 = n2 >> 4 & 0xF;
                int n4 = n2 & 0xF;
                return n << 20 | n3 << 12 | n4 << 4;
            }
        }
        return 0;
    }

    private String hex(int n, int n2) {
        String string;
        int n3;
        String string2 = "00000000";
        if (string2.length() < n2) {
            n2 = string2.length();
        }
        if (0 >= (n3 = n2 - (string = Integer.toHexString(n)).length())) {
            return string;
        }
        return string2.substring(0, n3) + string;
    }

    public void focus(boolean bl, JTable jTable) {
        if (bl) {
            this.myTextField.setForeground(jTable.getSelectionForeground());
            this.myTextField.setBackground(jTable.getSelectionBackground());
        } else {
            this.myTextField.setBackground(jTable.getBackground());
            this.myTextField.setForeground(jTable.getForeground());
        }
    }

    public void editable(boolean bl) {
        this.setEnabled(bl);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.myTextField.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected class exColorChooser
    extends JColorChooser
    implements ActionListener {
        private Color color;

        protected exColorChooser() {
        }

        public Color exshow(Component component, String string, Color color) {
            JDialog jDialog = JColorChooser.createDialog(component, string, true, this, this, null);
            this.setColor(color);
            jDialog.setLocationRelativeTo(null);
            this.color = null;
            jDialog.show();
            return this.color;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.color = this.getColor();
        }
    }

    protected class actionChoose
    implements ActionListener {
        protected ColorCEC myCEC;

        public actionChoose(ColorCEC colorCEC2) {
            this.myCEC = colorCEC2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            exColorChooser exColorChooser2 = new exColorChooser();
            Color color = exColorChooser2.exshow(this.myCEC, "color", ColorCEC.this.color(this.myCEC.text()));
            if (null == color) {
                return;
            }
            this.myCEC.text(ColorCEC.this.text(color));
        }
    }
}

