/*
 * @(#)DocGridControler.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.doc;

import java.awt.Shape;

import java.awt.geom.AffineTransform;

import java.util.Stack;
import java.util.Enumeration;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZReverseEnumeration;
/**
 * ftHgObhRg[[
 * @author  N
 * @version 1.01 2001/01/07
 */
public class DocGridControler {

	/**
	 * RXgN^
	 */
	public DocGridControler(){
	}

	/**
	 * RXgN^
	 * @param state Obh{L|}ݒ
	 */
	public DocGridControler(boolean state){
		setEnable( state ) ;
	}

	/**
	 * ObhԂ̐ݒ
	 * @param state Obh{L|}ݒ
	 */
	public void setEnable(boolean state){
	mState = state ;
	}

	/**
	 * ObhԊu̐ݒ
	 * @param nX ObhԊu
	 * @param nY ObhԊu
	 */
	public void setGrid(double nX, double nY){
	mX = nX ;
	mY = nY ;
	}

	/**
	 * ړJn
	 * @param pt Jnʒu
	 * @param nMode ړ[h
	 */
	public void setMoveStart(ZPoint pt,byte nMode){
	mStartPoint = pt ;
	mMoveMode   = nMode ;
	}

	/**
	 * ړ
	 * @param pt Jnʒu
	 * @param mask ړ}XN
	 */
	public void setMoving(ZPoint pt,int mask) {
	mMovePoint = pt ;
	mMoveMask  = mask ;
	}

	//## ϊ #########################################################
	/**
	 * ϊ𖖔ɒǉ
	 * @param trans Wϊ
	 */
	public void pushTransform(PTransform trans){
	mTrans.push(trans);
	createHashTransform();
	}

	/**
	 * ̕ϊ
	 */
	public void popTransform(){
//	ZDebug.trace("Pop:"+mTrans.size());
	mTrans.pop();
	createHashTransform();
	}

	/**
	 * nbVpWϊ̍쐬
	 */
	protected void createHashTransform() {
	// Wւ̕ϊ
	mHashTrans = null;
	Enumeration elm = new ZReverseEnumeration(mTrans) ;
	while ( elm.hasMoreElements() ) {
		PTransform     gtrans = (PTransform)elm.nextElement();
		if ( mHashTrans == null ) {
			mHashTrans = new PTransform(gtrans);
		} else {
			mHashTrans.add( gtrans );
		}
	}

	// _Wւ̕ϊ
	mHashTransLP = null;
	elm = new ZReverseEnumeration(mTrans) ;
	PTransform  prev = (PTransform)elm.nextElement();
	while ( elm.hasMoreElements() ) {
		PTransform     gtrans = (PTransform)elm.nextElement();
		if ( mHashTransLP == null ) {
			mHashTransLP = new PTransform(prev);
		} else {
			mHashTransLP.add( prev );
		}
		prev = gtrans;
	}

	// [JWւ̕ϊ
	mHashInverse = null;
	mHashInverseZone = null;
	elm = mTrans.elements() ;
	while ( elm.hasMoreElements() ) {
		PTransform     gtrans = (PTransform)elm.nextElement();
		if ( mHashInverse == null ) {
			mHashInverse = new PTransform(gtrans);
			mHashInverseZone = new PTransform(gtrans);
		} else {
			mHashInverse.add( gtrans );
		}
	}

	}

	//## Wϊ######################################################
	/**
	 * Wϊ(Point)
	 */
	public ZPoint transform(ZPoint point){
	ZPoint pt = new ZPoint( point );
	if ( mHashTrans != null ) {
		pt = mHashTrans.transform( pt );
	}
	return pt;
	}

	/**
	 * Wϊ(Point)
	 * WϊX^bN̈ԉɂϊ͕W_Wnւ̕ϊł̂
	 * ԍŌ̕ϊȂŘ_W擾
	 */
	public ZPoint transformToLP(ZPoint point){
	ZPoint pt = new ZPoint( point );
	if ( mHashTransLP != null ) {
		pt = mHashTransLP.transform( pt );
	}
	return pt;
	}

	/**
	 * Wϊ(Shape)
	 */
	public Shape transform(Shape sp){
	Shape out = sp;
	if ( mHashTrans != null ) {
		out = mHashTrans.getTransform().createTransformedShape( sp );
	}
	return out;
	}

	/**
	 * Wϊ
	 * `ɂāAZo鎞Ȃǂɗp邽߁A
	 * YW̃XP[ϊ݂̂Kp
	 * ItZbgϊAV[Oϊ͖
	 * @param dy YW
	 */
	public double transformY(double dy){
	double transy = dy;
	if ( mHashTrans != null ) {
		transy *= mHashTrans.getTransform().getScaleY();
	}
	return transy;
	}

	/**
	 * Wtϊ(Point)
	 */
	public ZPoint inverseTransform(ZPoint point){
	ZPoint pt = new ZPoint( point );
	if ( mHashInverse != null ) {
		pt = mHashInverse.inverseTransform( pt );
	}
	return pt;
	}

	/**
	 * ϊ̎擾
	 * @ret AffineTransform
	 */
	public AffineTransform getTransform(){
	if ( mHashInverse != null ) {
		return mHashInverse.getTransform();
	}
	return null;
	}

	/**
	 * {̂ݕϊ̎擾
	 * @ret AffineTransform
	 */
	public AffineTransform getScaleTransform(){
	if ( mHashInverse != null ) {
		return mHashInverse.getScaleTransform();
	}
	return null;
	}


	//## l ###########################################################
	/**
	 * N_̎擾
	 */
	public ZPoint getStartPoint() {
	return inverseTransform( mStartPoint ) ;
	}

	/**
	 * ړ_̎擾
	 */
	public ZPoint getMovePoint() {
	return inverseTransform( mMovePoint ) ;
	}

	/**
	 * ړItZbg̎擾
	 */
	public ZPoint getOffset() {
	return getMovePoint().minus( getStartPoint() ) ;
	}

	/**
	 * ړItZbg̎擾
	 */
	public ZPoint getPhigicalOffset() {
	return mMovePoint.minus( mStartPoint ) ;
	}

	/**
	 * ړ[h̐ݒ
	 * pr̂߂ɁAړ[hύXƂɂ悤
	 */
	public void setMoveMode( byte mode ) {
	mMoveMode = mode;
	}

	/**
	 * ړ[h̎擾
	 */
	public byte getMoveMode() {
	return ( mMoveMode ) ;
	}

	/**
	 * ړ}XN̎擾
	 */
	public int getMoveMask() {
	return ( mMoveMask ) ;
	}

	//## Obh̎擾 ###############################################
	/**
	 * N_Obh̎擾
	 */
	public ZPoint getStartGrid() {
	return ( getGrid( getStartPoint() ) ) ;
	}

	/**
	 * ړObh̎擾
	 */
	public ZPoint getMoveGrid() {
	return ( getGrid( getMovePoint() ) ) ;
	}

	/**
	 * ړObh̎擾Zonep
	 */
	public ZPoint getMoveGridZone() {
//	ZDebug.trace("mMovePoint;"+mMovePoint);
	ZPoint pt = new ZPoint( mMovePoint );
/*
	ZPoint pt2 = new ZPoint( mMovePoint );
	ZPoint pt3 = new ZPoint( mMovePoint );
	ZPoint pt4 = new ZPoint( mMovePoint );
	if ( mHashInverse != null ) {
		pt = mHashInverse.inverseTransform( pt );
	}
	ZDebug.trace();
*/
	Enumeration elm = mTrans.elements() ;
	while ( elm.hasMoreElements() ) {
		PTransform     gtrans = (PTransform)elm.nextElement();
//		ZDebug.trace("trans;"+gtrans);
		pt = gtrans.inverseTransform(pt);
//		ZDebug.trace("trans;"+pt);
	}
/*
	ZDebug.trace();
	elm = new ZReverseEnumeration(mTrans) ;
	while ( elm.hasMoreElements() ) {
		PTransform     gtrans = (PTransform)elm.nextElement();
		ZDebug.trace("trans;"+gtrans);
		pt3 = gtrans.inverseTransform(pt3);
		ZDebug.trace("trans;"+pt3);
	}
	ZDebug.trace("mTrans;"+pt);
	ZDebug.trace("mTrans2;"+pt2);
	ZDebug.trace("mTrans2;"+pt3);
*/
	return ( getGrid( pt ) ) ;
	}

	/**
	 * ړItZbgObh̎擾
	 */
	public ZPoint getOffsetGrid() {
	return ( getGrid( getOffset() ) ) ;
	}

	/**
	 * Obh̎擾
	 */
	public ZPoint getGrid(ZPoint pt) {
	return new ZPoint(getGrid(HORZ,pt.getX()),getGrid(VERT,pt.getY())) ;
	}

	/**
	 * Obh̎擾
	 */
	public double getGrid(byte mode, double val ) {
	if ( mState ) {
		double nGrid = (mode==HORZ) ? mX : mY ;
	
		// ߎ_̎擾
		double nNear  = (double)((int)( val/nGrid ))*(int)(nGrid*10)/10 ;
		double nNear2 = (double)((int)( val/nGrid )+1)*(int)(nGrid*10)/10 ;
		return ( ((nNear2-val)>(val-nNear)) ? nNear : nNear2 ) ;
	}
	return ( val );
	}

	/**
	 * Obh̎擾
	 * w肵W傫_A܂͏_
	 */
	public double getOverGrid(byte mode, double val, int over ) {
	if ( mState ) {
		double nGrid = (mode==HORZ) ? mX : mY ;
	
		// ߎ_̎擾
		if ( over == -1 ) {
			double nNear  = (double)((int)( val/nGrid ))*(int)(nGrid*10)/10 ;
			return nNear;
		} else {
			double nNear2 = (double)((int)( val/nGrid )+1)*(int)(nGrid*10)/10 ;
			return nNear2;
		}
	}
	return ( val );
	}

	//## GfB^ #####################################################
	/**
	 * GfB^̐ݒ
	 * @param editor Rei
	 */
	public void setEditor(DocPane editor) {
	mEditor = editor;
	}

	/**
	 * GfB^̎擾
	 * @return Rei
	 */
	public DocPane getEditor() {
	return mEditor;
	}

	//## Agr[g################################################
	/**
	 * Obh`(X)
	 */
	protected double	mX		= 10 ;

	/**
	 * Obh`(X)
	 */
	protected double	mY		= 10 ;

	/**
	 * Obh̗L
	 */
	protected boolean	mState	= true ;

	/**
	 * N_
	 */
	protected ZPoint	mStartPoint	= new ZPoint(0,0) ;

	/**
	 * ړ_
	 */
	protected ZPoint	mMovePoint	= new ZPoint(0,0) ;

	/**
	 * ړ[h
	 */
	protected byte		mMoveMode   = 0 ;

	/**
	 * ړ}XN
	 */
	protected int		mMoveMask	= 0 ;

	/**
	 * `F
	 */
	final static protected byte	HORZ	= 0 ;

	/**
	 * `Fc
	 */
	final static protected byte	VERT	= 1 ;

    /**
     * Wϊ
     */
	protected Stack			mTrans = new Stack();

	/**
	 * GfB^
	 */
	protected DocPane mEditor = null ;

	/**
	 * nbVpWϊ
	 */
	protected PTransform mHashTrans = null ;

	/**
	 * nbVpWϊF_Wn
	 */
	protected PTransform mHashTransLP = null ;

	/**
	 * nbVpWϊFtϊ
	 */
	protected PTransform mHashInverse = null ;

	/**
	 * nbVpWϊFtϊ(DisplayScalê)
	 */
	protected PTransform mHashInverseZone = null ;
}
