/**
 * @(#)DocPane.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Vector;
import java.util.Enumeration;

import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.text.JTextComponent;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.IZApp;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.gob.GElement;

import jp.co.iti.fagot.util.ZKeyMap;
import jp.co.iti.fagot.util.ZDebug;
/**
 * `yC
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class DocPane extends DocComponent {

	/**
	 * RXgN^
	 */
	public DocPane() {
	}

	/**
	 * RXgN^
	 * @param panel plʎq
	 */
	public DocPane(String panelId){
	super(panelId);
	}

	//## I[oCh #################################################
	/**
	 * wiF̎擾
	 */
	public Color getBackground() {
	Color bg = null;
	// \(RXgN^)ł̓plIdnullɂȂĂ邽߁A
	if ( getDocument() != null ) {
		bg = getDocument().getBackground(getPanelId());
	}

	if ( bg == null ) {
		bg = super.getBackground() ;
	}
	return bg;
	}

	/**
	 * R|[lgɍœKȃTCY̎擾
	 */
	public Dimension getPreferredSize() {
	Dimension dim = null;
	// \(RXgN^)ł̓plIdnullɂȂĂ邽߁A
	if ( getDocument() != null ) {
		dim = getDocument().getPreferredSize(getPanelId());
	}

	if ( dim == null ) {
		dim = super.getPreferredSize() ;
	}
	return dim;
	}

	//##  ########################################################
	/**
	 * ʒ̍W̎擾
	 * @ret pt ̍W(_W)
	 */
	public ZPoint getCenter() {
	DocElement root = (DocElement)getDocument().getRootElement(getPanelId());

	if ( getParent() == null || !(getParent() instanceof JViewport) ) {
		return null;
	}

	JViewport port  = (JViewport)getParent();
	Point ptTL = port.getViewPosition();

	// W
	ZPoint ptCenter = new ZPoint( ptTL.x + port.getWidth()/2,
								  ptTL.y + port.getHeight()/2 );

	if ( root == null ) {
		return ptCenter;
	}

	// _Wɕϊ
	ZPoint ptret    = root.getDisplayScaledTransform(getPanelId()).inverseTransform(ptCenter);
	return ptret;
	}

	/**
	 * ʂ̈ړ
	 * @param pt ̍W(_W)
	 */
	public void setCenter(ZPoint pt) {
	DocElement root = (DocElement)getDocument().getRootElement(getPanelId());
	ZPoint ptCenter = null;
	if ( root != null ) {
		ptCenter = root.getDisplayScaledTransform(getPanelId()).transform(pt);
	} else {
		ptCenter = pt;
	}

	setPaintMode(false);

	if ( getParent() == null || !(getParent() instanceof JViewport) ) {
		return;
	}
	JViewport port  = (JViewport)getParent();

	// ʂ̍ptCenterʂ̔TCŸʒu
	Dimension dim = port.getSize();
	Dimension dc  = getSize();

	Point ptTL = new Point( (int)(ptCenter.getX() - dim.width/2 ),
							(int)(ptCenter.getY() - dim.height/2) ) ;

	// ʒu␳
	if (     ptTL.x<0 )                    { ptTL.x=0 ; }
	else if( ptTL.x>(dc.width-dim.width) ) { ptTL.x=dc.width-dim.width ;}
	if (     ptTL.y<0 )                    { ptTL.y=0 ; }
	else if( ptTL.y>(dc.height-dim.height)){ ptTL.y=dc.height-dim.height;}

	port.setViewPosition( ptTL );
	updateCenter( pt );
	setPaintMode(true);
	}

	/**
	 * ʒ̍W̕ۑ
	 */
	public void updateCenter() {
	if ( mPainted && canPaint() ) {
		ZPoint pt = getCenter();
		updateCenter( pt );
	}
	}

	/**
	 * ʒ̍W̕ۑ
	 * @param pt W
	 */
	public void updateCenter(ZPoint pt) {
	DocElement root = (DocElement)getDocument().getRootElement(getPanelId());
	if ( root != null ) {
		XElementNS elm = root.getChildElement(".ViewInfo."+getPanelId(),null);
		elm.setDoubleAttr("DisplayX", pt.getX());
		elm.setDoubleAttr("DisplayY", pt.getY());
//		ZDebug.trace("UPDATE:"+root.getAttribute("Name"));
//		ZDebug.printStack();
//		ZDebug.trace("	upd XY:"+pt.getX()+","+pt.getY());
	}
	}

	/**
	 * \`̕ύX
	 * @param rt `
	 */
	public void updateRect(ZRectangle rect) {
	double inset = 100;
	JViewport port = (JViewport)getParent();
	Dimension dim  = port.getSize();
	double dx = dim.width/ Math.max(dim.width,rect.getWidth()+inset*2);
	double dy = dim.height/Math.max(dim.height,rect.getHeight()+inset*2);
	double dz = Math.min(dx,dy);
	
	// |[g̍ăCAEg
	String szPanelId = getPanelId();
	DocDocument doc = getDocument();
	DocElement root = (DocElement)doc.getRootElement(szPanelId);
	root.setDisplayScale( szPanelId, dz );
	port.doLayout();

	// ʒu𒆉
//	ZDebug.trace(" center:"+rect.getCenter());
	setCenter( rect.getCenter() );

	// O`ʒuɖ߂Ȃ
	mPainted = true;
	}

	//## ` ########################################################
	/**
	 * hLg̐ݒ
	 * @param doc hLg
	 * @see JComponent#accessibleContext
	 */
	public void setDocument(DocDocument doc) {
	super.setDocument(doc);
	mPainted = false;
	updateGobs();
	}

	/**
	 * pl̏\F`ʒuÔƂɖ߂
	 */
	public void editRestart() {
	mPainted = false;
	}

	/**
	 * RecXVꂽ
	 */
	public void updateGobs() {
	mUpdateGobs = true;
	}

	/**
	 * RecXVꂽH
	 */
	public boolean isUpdateGobs() {
	return mUpdateGobs;
	}

	/**
	 * CAEg̍œK
	 */
	public void updateLayout() {
		ZRectangle rect = getGobRect();
		if ( rect != null ) updateRect(rect);
		repaint();
	
/*
	ZRectangle rect = null;
	Enumeration elm = gobs.elements();
	while ( elm.hasMoreElements() ) {
		GElement gob = (GElement)elm.nextElement();
		ZRectangle rt = gob.getTransformedBounds();
		if ( rect == null ) {
			rect = rt;
		} else {
			rect.union( rt );
		}
	}
	if ( rect != null ) {
		updateRect(rect);
	}
	repaint();
*/
	}
	
	private ZRectangle getGobRect(){
		ZRectangle rect = null;
		Vector gobs = getDocument().createGobs(getPanelId());
		Enumeration elm = gobs.elements();
		while ( elm.hasMoreElements() ) {
			GElement gob = (GElement)elm.nextElement();
			ZRectangle rt = gob.getTransformedBounds();
			if ( rect == null )	rect = rt;
			else				rect.union(rt);
		}
		
		return rect;
	}

	/**
	 * `Gg̍XV
	 */
	public void createGobs() {
	// gUNV̊Jn
	DocDocument doc = getDocument();
	boolean isTran = doc.isTransaction();
	if ( !isTran ) {
		doc.beginTransaction();
	}

	Vector gobs = GobManager.getElement(getPanelId());

	gobs.removeAllElements();
	gobs.addAll( doc.createGobs(getPanelId()) );
	mUpdateGobs = false;

	// R~bg
	if ( !isTran ) {
		doc.commitPlus();
	}

	if ( !mPainted ) {
		mPainted = true;
		Dimension dim = doc.getLogicalSize();
		ZPoint pt = new ZPoint(dim.getWidth()/2,dim.getHeight()/2);
		// `掞͑O\ʒuɈړ
		DocElement root = (DocElement)doc.getRootElement(getPanelId());
		if ( root != null ) {
			XElementNS elm = root.findChildElement(".ViewInfo."+getPanelId(),null);
/*
			if ( elm != null ) {
				pt.setX( elm.getDoubleAttr("DisplayX", pt.getX()) );
				pt.setY( elm.getDoubleAttr("DisplayY", pt.getY()) );
			}
*/
			String dspx = elm.getAttribute("DisplayX");
			if ((dspx == null) || (dspx.length() <= 0)){
				updateLayout();
				return;
			}else {
				pt.setX( elm.getDoubleAttr("DisplayX", pt.getX()) );
				pt.setY( elm.getDoubleAttr("DisplayY", pt.getY()) );
			}
//			ZDebug.trace("SetCenter;"+pt.toString());
		}
		setCenter(pt);
	}
	}

	/**
	 * ĕ`惂[h̐ݒ
	 * @param mode stO
	 */
	public void setPaintMode(boolean mode) {
	mCanPaint = mode;
	}

	/**
	 * ĕ`惂[h̎擾
	 */
	public boolean canPaint() {
	return mCanPaint;
	}

	//## R|[lg ################################################
	/**
	 * UIA_v^̍쐬
	 * @return UIA_v^
	 */
	public DocUIAdapter createUIAdapter() {
	return new DocUIAdapter(this);
	}

	/**
	 * ObhRg[̍쐬
	 * @param grid ObhRg[
	 */
	public DocGridControler createGridControler() {
	DocGridControler grid = new DocGridControler();
	grid.setEditor( this ) ;
	return grid;
	}

	//## L[}bv ####################################################
	/**
	 * ftHgL[}bv𐶐܂
	 * @param app AvP[V
	 */
	public Vector createDefaultKeyMap(IZApp app) {
	Vector keyMap = new Vector();
	return keyMap ;
	}

	/**
	 * L[}bv𐶐܂
	 */
	public void setKeyMap(Vector keymap) {

	Enumeration elm = elm=keymap.elements() ;
	while( elm.hasMoreElements() ) {
		ZKeyMap key = (ZKeyMap)elm.nextElement();
		ZAction act = (ZAction)key.getAction();
		// Cvbg}bvƃANV}bv̑ΉÂ
		getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
			key.getKeyStroke(), act.getActionName());
		getActionMap().put(act.getActionName(), act);
	}
	}

	/**
	 * L[}bv폜܂
	 */
	public void removeKeyMap(Vector keymap) {

	Enumeration elm = elm=keymap.elements() ;
	while( elm.hasMoreElements() ) {
		ZKeyMap key = (ZKeyMap)elm.nextElement();
		ZAction act = (ZAction)key.getAction();
		// Cvbg}bvƃANV}bv̑ΉÂ
		getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).remove(
			key.getKeyStroke());
		getActionMap().remove(act.getActionName());
	}
	}

	//## ҏW ####################################################
	/**
	 * ҏWR|[lg̐ݒ
	 * @param elm  ҏWΏۃGg
	 * @param rect ʒu(_W)
	 * @param isMulti sҏW̗L
	 */
	public void setEditElement(DocElement elm, ZRectangle rect,boolean isMulti) {
	DocElement root = (DocElement)getDocument().getRootElement(getPanelId());
	ZRectangle rtTrans = new ZRectangle(root.getDisplayScaledTransform(getPanelId()).transform(rect).getBounds2D());

	// L[}bv̍폜
	removeKeyMap( createDefaultKeyMap(ZApp.getTheApp()) );

	// Gg̕ۑƓ̓R|[lg̍쐬
	mEditElement = elm ;
	mEditRect    = rect;
	mEditComponent = null;
	if(isMulti) {
		mEditComponent = new JTextArea();
	} else {
		mEditComponent = new JTextField();
		((JTextField)mEditComponent).addActionListener( new DocEditActionListener() );
	}
	String szKey = "Doc "+rtTrans.getX()+" "+rtTrans.getY()+" "+rtTrans.getWidth()+" "+rtTrans.getHeight();
	mEditComponent.setText( elm.getText() ) ;
	add(szKey,mEditComponent);
	validate();
	}

	/**
	 * ҏWI
	 * @ret ҏWLZꂽH
	 */
	public boolean editEnd() {
	if ( mEditComponent != null ) {
		// gUNVJn
		String szText = mEditElement.getText();
		getDocument().beginTransaction();

		mEditElement.setText( mEditComponent.getText() );
		remove( mEditComponent );
		mEditComponent = null;
		mEditElement   = null;
		mEditRect      = null;

		// gUNVI
		if ( szText.length() > 0 ) {
			getDocument().commit();
		} else {
			getDocument().commitPlus();
		}

		updateGobs();
		validate();
		repaint();

		// L[}bv̍Đݒ
		setKeyMap( createDefaultKeyMap(ZApp.getTheApp()) );
		requestFocus();

		return true;
	}
	return false;
	}

	//## ҏWANVXi[ #################################
	/**
	 * ҏWA^[L[Ŋm
	 */
	protected class DocEditActionListener implements ActionListener {
	/**
	 * ANV̎s
	 * @param evt Cxg
	 */
	public void actionPerformed(ActionEvent evt) {
	editEnd();
	}
	}

	//## Agr[g################################################
    /**
     * hLgXVāAĕ`悳ĂȂ
     */
	protected boolean 		mUpdateGobs = true;

    /**
     * `tO
     */
	protected boolean 		mPainted = false;

    /**
     * `\H
     * 쒆̏ꍇ́A`sɐݒ肷
     */
	protected boolean 		mCanPaint = true;

	/**
	 * ҏWΏۃGg
	 */
	protected DocElement 	mEditElement = null;

	/**
	 * ҏW`
	 */
	protected ZRectangle 	mEditRect = null;

	/**
	 * ҏWR|[lg
	 */
	protected JTextComponent mEditComponent = null;
}
