/*
 * @(#)FVector.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.fob;

import java.util.Vector;
import java.util.Enumeration;

import jp.co.iti.fagot.util.ZDebug;
/**
 * Vector
 *
 * ̃NXɓo^vfƂĎ̂̂l
 *
 * <ul>
 * <li> FElement̔hNX	FobManagerL
 * <li> IFobElement				FobManagerL
 * <li> IFobContainer			FobManagerL
 * <li> ̑̃NX			ȂɂȂ
 * </ul>
 *
 * Vectorł̓IuWFNǧo(containsȂ) equals\bhgpĂ邪
 * IuWFNg̒lςƂremovełȂȂ̂ŁAindexOf
 *
 * @author  gG
 * @version 1.01 2001/01/07
 */
public class FVector extends FElement {

	/**
	 * RXgN^
	 */
	public FVector() {
	super( new Vector() );
	}

	/**
	 * Element̓o^
	 */
	public synchronized void add(Object data) {
	add( ((Vector)getData()).size(), data );
	}

	/**
	 * Element̓o^
	 */
	public synchronized void add(int nIndex, Object data) {
	if ( mMgr != null ) {
		mMgr.push( new FUndoInsertElement(this,nIndex,data) );
	}
	addNoUndo( nIndex, data );
	
	// }l[W̓o^
	FobManager mgr = getFobManager();
	if ( mgr != null ) {
		if ( data instanceof FElement ) {
//			System.out.println("Add FElement");
			((FElement)data).setFobManager( mgr, getUsrData() );
		} else if ( data instanceof IFobElement ) {
			((IFobElement)data).setFobManager( mgr, getUsrData() );
		} else if ( data instanceof IFobContainer ) {
			((IFobContainer)data).setFobManager( mgr );
		} else {
//			System.out.println("UnknownType");
		}
	}
	}

	/**
	 * Element̓o^
	 */
	public synchronized void addNoUndo(int nIndex, Object data) {
	((Vector)getData()).add( nIndex, data );
	}

	/**
	 * Element̍폜
	 */
	public synchronized void remove(Object data) {
	int nIndex = indexOf( data );
	removeElementAt( nIndex );
	}

	/**
	 * Element̍폜
	 */
	public synchronized void removeElementAt(int nIndex) {
	if ( mMgr != null ) {
		Object data = elementAt(nIndex);
		mMgr.push( new FUndoRemoveElement(this,nIndex,data) );
	}
	removeElementAtNoUndo( nIndex );
	}

	/**
	 * Element̍폜
	 */
	public synchronized void removeElementAtNoUndo(int nIndex) {
	((Vector)getData()).removeElementAt( nIndex );
	}

	/**
	 * Element̍폜
	 */
	public synchronized void removeAll() {
	while ( !isEmpty() ) {
		removeElementAt(0);
	}
	}

	/**
	 * Element̗L
	 */
	public synchronized boolean isEmpty() {
	return ( ((Vector)getData()).isEmpty() );
	}

	/**
	 * ܂ނH
	 */
	public synchronized boolean contains( Object data ) {
	return ( indexOf( data )!=-1 );
	}

	/**
	 * TCY̎擾
	 */
	public synchronized int size() {
	return ( ((Vector)getData()).size() );
	}

	/**
	 * Element̎擾
	 */
	public synchronized Object elementAt(int nIndex) {
	return ((Vector)getData()).elementAt(nIndex);
	}

	/**
	 * vf̈ʒu܂
	 */
	public synchronized int indexOf( Object data ) {
	int nIndex = 0;
	Enumeration elm = elements();
	while ( elm.hasMoreElements() ) {
		Object obj = elm.nextElement();
		if ( obj == data ) {
//			ZDebug.trace("     find..."+data);
			return nIndex;
		}
//		ZDebug.trace("     xxxx..."+data+"!="+obj);
		nIndex++;
	}
	return -1;
	}

	/**
	 * Enumeration̎擾
	 */
	public synchronized Enumeration elements() {
	return ( ((Vector)getData()).elements() ) ;
	}

	/**
	 * tEnumeration̎擾
	 */
	public synchronized Enumeration r_elements() {
	return new Enumeration() {
		Vector mVector = (Vector)getData();
	    int    mCount = 0;

		public boolean hasMoreElements() {
			return mCount < mVector.size();
		}

		public Object nextElement() {
			if (mCount < mVector.size()) {
				return mVector.elementAt(mVector.size()-(++mCount));
			}
			return null;
		}
	};
	}

	//## FAGOT ########################################################
	/**
	 * }l[W̐ݒ
	 * @param mgr }l[W
	 * @param usrData [Uf[^(Cӂ̃[Uf[^)
	 */
	public void setFobManager( FobManager mgr, Object usrData ) {
	super.setFobManager( mgr, usrData );
	Enumeration elm = elements() ;
	while( elm.hasMoreElements() ) {
		Object obj = elm.nextElement();

		// }l[W̓o^
		if ( obj instanceof FElement ) {
			((FElement)obj).setFobManager( mgr, usrData );
		} else if ( obj instanceof IFobContainer ) {
			((IFobContainer)obj).setFobManager( mgr );
		}
	}
	}

	//## CLONE ########################################################
	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new FVector();
	}

	/**
	 * Agr[g̕
	 * @param obj ̃IuWFNg
	 */
	public void copyAttribute( Object obj ) {
	Enumeration elm = elements() ;
	while ( elm.hasMoreElements() ) {
		Object item  = elm.nextElement();
		if ( item instanceof FElement ) {
			((FVector)obj).add(((FElement)item).clone());
		} else if ( obj instanceof IFobContainer ) {
			((FVector)obj).add(((IFobContainer)item).clone());
		} else {
			ZDebug.err("not yet supportFclone"+item.toString());
		}
	}
	}

	//## TuNXFAhDIuWFNgiinsert,removeʁj#########
	/**
	 * FVectorpundoIuWFNg
	 */
	public class FUndoVectorElement implements IFUndoElement {
	/**
	 * RXgN^
	 * @param org    IWiIuWFNg
	 * @param nIndex ʒu
	 * @param obj    l
	 */
	public FUndoVectorElement(FVector org, int nIndex, Object obj) {
	mOrg    = org    ;
	mIndex  = nIndex ;
	mObj    = obj    ;
	}

	/**
	 * AhD
	 */
	public void undo() {
	}

	/**
	 * hD
	 */
	public void redo() {
	}

	/**
	 * IWiIuWFNg̎擾
	 */
	public void getFobs( Vector items ) {
	items.add( mOrg );
	items.add( mObj );
	}

	//## Agr[g################################################
	/**
	 * IWiIuWFNg
	 */
	protected FVector  mOrg    = null ;
	
	/**
	 * ʒu
	 */
	protected int      mIndex  = -1   ;
	
	/**
	 * l
	 */
	protected Object   mObj    = null ;
	}

	//## TuNXFAhDIuWFNgiinsertpj##################
	/**
	 * FVectorpundoIuWFNg(insertp)
	 */
	public class FUndoInsertElement extends FUndoVectorElement {
	/**
	 * RXgN^
	 * @param org    IWiIuWFNg
	 * @param nIndex ʒu
	 * @param obj    l
	 */
	public FUndoInsertElement(FVector org, int nIndex, Object obj) {
	super( org, nIndex, obj ) ;
	}

	/**
	 * AhD
	 */
	public void undo() {
//	mOrg.removeNoUndo(mObj);
	mOrg.removeElementAtNoUndo(mIndex);
	}

	/**
	 * hD
	 */
	public void redo() {
	mOrg.addNoUndo(mIndex,mObj);
	}
	}

	//## TuNXFAhDIuWFNgiremovepj##################
	/**
	 * FVectorpundoIuWFNg(removep)
	 */
	public class FUndoRemoveElement extends FUndoVectorElement {
	/**
	 * RXgN^
	 * @param org    IWiIuWFNg
	 * @param nIndex ʒu
	 * @param obj    l
	 */
	public FUndoRemoveElement(FVector org, int nIndex, Object obj) {
	super( org, nIndex, obj ) ;
	}

	/**
	 * AhD
	 */
	public void undo() {
	mOrg.addNoUndo(mIndex,mObj);
	}

	/**
	 * hD
	 */
	public void redo() {
	mOrg.removeElementAtNoUndo(mIndex);
	}
	}
}
