/*
 * @(#)XElementNS.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.fob.xml;

import java.awt.Color;

import java.util.Enumeration;
import java.util.Vector;
import java.util.Hashtable;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.IFUndoElement;

import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * undoableGg
 *
 * @author  N
 * @version 1.01 2001/03/22
 */
public class XElementNS extends ElementNSImpl {

	/**
	 * RXgN^
	 * @param doc   I[ihLg
	 * @param ns    l[Xy[X
	 * @param name  ^O
	 */
	public XElementNS(DocumentImpl doc, String ns, String name) throws DOMException {
	super(doc,ns,name);
	}

	/**
	 * ftHgRXgN^
	 */
	public XElementNS() throws DOMException {
	super(null,null);
	}

	/**
	 * ftHgRXgN^ƃyAŗp
	 * @param doc   I[ihLg
	 * @param ns    l[Xy[X
	 * @param name  ^O
	 */
	public void constructElement( DocumentImpl doc, String ns, String name) {
//	setOwnerDocument(doc) ;
	setDocument(doc);

	this.namespaceURI = ns;			// ElementNSImpl
	this.name = name;				// ElementImpl

//	needsSyncData(true);
	this.flags = (short) ( this.flags | SYNCDATA );	// NodeImpl.needsSyncData
	}

	/**
	 * hLg̐ݒ
	 * ElementImpl.setOwnerDocument̓veNgĂ̂ŃI[oCh
	 * @param doc   I[ihLg
	 */
	public void setDocument( DocumentImpl doc ) {
	this.ownerNode = doc;	// NodeImpl
	this.ownerDocument = doc;		// ParentNode

//	if (attributes != null) {
//		attributes.setOwnerDocument(doc);
//	}
	}

	//## I[oChFhLg ###############################
	/**
	 * }
	 */
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
	FobManager mgr = ((XDocument)getOwnerDocument()).getFobManager();
	mgr.push( new XUndoInsertElement(this,newChild,refChild) );
	return insertBeforeNoUndo(newChild,refChild);
	}

	/**
	 * }(undoȂ)
	 */
    public Node insertBeforeNoUndo(Node newChild, Node refChild) throws DOMException {
	return super.insertBefore(newChild,refChild);
	}

	/**
	 * 폜
	 */
    public Node removeChild(Node oldChild) throws DOMException {
	FobManager mgr = ((XDocument)getOwnerDocument()).getFobManager();
	Node refChild = oldChild.getNextSibling();
	mgr.push( new XUndoRemoveElement(this,oldChild,refChild) );
	return removeChildNoUndo(oldChild);
	}

	/**
	 * 폜(undoȂ)
	 */
    public Node removeChildNoUndo(Node oldChild) throws DOMException {
	Node nd = super.removeChild(oldChild);
	if ( oldChild instanceof XElementNS ) {
		((XElementNS)oldChild).firePropertyChanged( "removed", null, null ) ;
	}
	return nd;
	}

	/**
	 * u
	 */
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
	ZDebug.trace("replace:"+oldChild.toString());
	return super.removeChild(oldChild);
	}

	//## { ######################################################
	/**
	 * Agr[g̐ݒ
	 * @param szName   Agr[g
	 * @param newValue l
	 */
	public void setAttribute(String szName,String newValue) {
	FobManager mgr = ((XDocument)getOwnerDocument()).getFobManager();
	String oldValue = getAttribute(szName);
//	ZDebug.trace("name;"+szName+" set:"+newValue+" old:"+oldValue+":");
	if ( !oldValue.equals(newValue) ) {
		mgr.push( new XUndoSetAttribute(this,szName,newValue,oldValue) );
		setAttributeNoUndo( szName, newValue );
	}
	}

	/**
	 * Agr[g̐ݒ(undoȂ)
	 * @param szName  Agr[g
	 * @param szValue l
	 */
	public void setAttributeNoUndo(String szName,String szValue) {
	String oldValue = getAttribute(szName);
//	if ( szName.equals("font-size") )ZDebug.trace("font-size:"+oldValue+":"+szValue);
	super.setAttribute( szName, szValue );
	firePropertyChanged( szName, oldValue, szValue ) ;
	}

	/**
	 * Agr[g̍폜
	 * @param szName  Agr[g
	 */
	public void removeAttribute(String szName) {
	FobManager mgr = ((XDocument)getOwnerDocument()).getFobManager();
	String oldValue = getAttribute(szName);
	if ( oldValue.length() != 0 ) {
		mgr.push( new XUndoSetAttribute(this,szName,"",oldValue) );
		removeAttributeNoUndo( szName );
	}
	}

	/**
	 * Agr[g̍폜(undoȂ)
	 * @param szName  Agr[g
	 */
	public void removeAttributeNoUndo(String szName) {
	String oldValue = getAttribute(szName);
	super.removeAttribute( szName );
	firePropertyChanged( szName, oldValue, "" ) ;
	}

	//## ^ϊ ########################################################
	/**
	 * Agr[g̐ݒ
	 * @param szName Agr[g
	 * @param value  l
	 */
	public void setBooleanAttr(String szName,boolean value) {
	setAttribute( szName, ((value)?"true":"false"));
	}

	/**
	 * Agr[g̎擾
	 * @param szName Agr[g
	 * @param defaultValue lݒ肳ĂȂꍇ̖߂l
	 */
	public boolean getBooleanAttr(String szName,boolean defaultValue) {
	String szValue = getAttribute(szName);
	if ( szValue.equals("true") ) {
		return true;
	} else if ( szValue.equals("false") ) {
		return false;
	}
	return defaultValue;
	}

	/**
	 * Agr[g̐ݒ
	 * @param szName Agr[g
	 * @param value  l
	 */
	public void setByteAttr(String szName,byte value) {
	setAttribute( szName, Byte.toString(value));
	}

	/**
	 * Agr[g̎擾
	 * @param szName Agr[g
	 * @param defaultValue lݒ肳ĂȂꍇ̖߂l
	 */
	public byte getByteAttr(String szName,byte defaultValue) {
	return ZString.parseByte(getAttribute(szName),defaultValue);
	}

	/**
	 * Agr[g̐ݒ
	 * @param szName Agr[g
	 * @param value  l
	 */
	public void setIntAttr(String szName,int value) {
	setAttribute( szName, Integer.toString(value));
	}

	/**
	 * Agr[g̎擾
	 * @param szName Agr[g
	 * @param defaultValue lݒ肳ĂȂꍇ̖߂l
	 */
	public int getIntAttr(String szName,int defaultValue) {
	return ZString.parseInt(getAttribute(szName),defaultValue);
	}

	/**
	 * Agr[g̐ݒ
	 * @param szName Agr[g
	 * @param value  l
	 */
	public void setDoubleAttr(String szName,double value) {
	setAttribute( szName, Double.toString(value));
	}

	/**
	 * Agr[g̎擾
	 * @param szName Agr[g
	 * @param defaultValue lݒ肳ĂȂꍇ̖߂l
	 */
	public double getDoubleAttr(String szName,double defaultValue) {
	return ZString.parseDouble(getAttribute(szName),defaultValue);
	}

	/**
	 * Agr[g̎擾
	 * @param szName Agr[g
	 * @param value  l
	 */
	public Color getColorAttr(String szName) {
	return ZGraphicUtil.stringToColor(getAttribute(szName));
	}

	//## Ggn #############################################
	/**
	 * GǧāAAgr[g擾
	 *
	 * @param tag   ^O
	 * @param where 
	 * @param attr  KvȃAgr[g
	 */
	public String getChildElementAttribute(String tag,String where,String attr) {
	XElementNS elm = findChildElement(tag,where);
	if ( elm != null ) {
		return elm.getAttribute(attr);
	}
	return "";
	}

	/**
	 * Gǧ
	 *
	 * ytag̎wz
	 * 낢Ȍ`Őݒł悤ɂ
	 * ^O̊Kwǂꍇ́Ae^O.q^Ǒ`ŊKwLq
	 * ^OKw̓Xy[Xŋ؂ĕLq\
	 * [gKw炽ǂꍇ́A擪.Lq
	 *
	 * @param tag   ^O
	 * @param where 
	 */
	protected XElementNS findElement(String tag,String where) {
	String[] tagInfo = ZString.tokenize(tag);

//	ZDebug.trace(getTagName()+".find:"+tag+":where="+where);

	// ^Oɂ
	for ( int nIndex=0 ; nIndex<tagInfo.length ; nIndex++ ) {
		boolean isAbsolute = false;
		if ( tagInfo[nIndex].startsWith(".") ) {
			// . n܂Ăΐ΃pX
			tagInfo[nIndex] = tagInfo[nIndex].substring(1);
			isAbsolute=true;
		}

		if ( tagInfo[nIndex].equals(getTagName()) && isMatch( where ) ) {
			// Ã^OƓŁAΎ
			return this;
		} else if ( tagInfo[nIndex].startsWith(getTagName()) ) {
			// ̃^O̎qłΎqǂ
			tagInfo[nIndex] = tagInfo[nIndex].substring( getTagName().length() );
		} else if ( isAbsolute ) {
			// ΃pXwŁÃ^O̎qłȂΌI
			tagInfo[nIndex] = null;
		}
	}

	// q̍쐬
	String szTag = null;
	for ( int nIndex=0 ; nIndex<tagInfo.length ; nIndex++ ) {
		if ( tagInfo[nIndex] != null ) {
			if ( szTag == null ) {
				szTag = tagInfo[nIndex];
			} else {
				szTag += " "+tagInfo[nIndex];
			}
		}
	}
	if ( szTag != null ) {
		return findChildElement( szTag,where );
	}
	return null;
	}

	/**
	 * qGǧ
	 *
	 * @param tag   ^O(qGg̏)
	 * @param where 
	 */
	public XElementNS findChildElement(String tag,String where) {
	if ( where == null ) {
		// nbVe[u猟
		// \̂߁AύXȂ(=q^Õm[h)nbVe[uɓo^
		// where ꍇ́AΏۃm[hς\̂ŁAo^Ȃ
		XElementNS node = (XElementNS)mHash.get( tag );
		if ( node != null ) {
			return node;
		}
	}
	NodeList list = getChildNodes();
	for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
		Node child = list.item(nAt);
		if ( child instanceof XElementNS ) {
			XElementNS node = ((XElementNS)child).findElement(tag,where);
			if ( node != null ) {
				if ( where == null ) {
					// \̂߁AύXȂ(=q^Õm[h)nbVe[uɓo^
					mHash.put( tag, node );
				}
				return node;
			}
		}
	}
	return null;
	}

	/**
	 * Gǧ
	 *
	 * @param tag   ^O(Xy[Xŋ؂ĕLq\)
	 */
	protected Vector findElements(String tag) {
	Vector children = new Vector();
	String[] tagInfo = ZString.tokenize(tag);

	// ^Oɂ
	for ( int nIndex=0 ; nIndex<tagInfo.length ; nIndex++ ) {
		boolean isAbsolute = false;
		if ( tagInfo[nIndex].startsWith(".") ) {
			// . n܂Ăΐ΃pX
			tagInfo[nIndex] = tagInfo[nIndex].substring(1);
			isAbsolute=true;
		}

		if ( tagInfo[nIndex].equals(getTagName())) {
			// Ã^OƓŁAΎ
			children.add( this ) ;
		} else if ( tagInfo[nIndex].startsWith(getTagName()) ) {
			// ̃^O̎qłΎqǂ
			tagInfo[nIndex] = tagInfo[nIndex].substring( getTagName().length() );
		} else if ( isAbsolute ) {
			// ΃pXwŁÃ^O̎qłȂΌI
			tagInfo[nIndex] = null;
		}
	}

/*
	// g̔
	for ( int nIndex=0; nIndex<tagInfo.length ; nIndex++ ) {
		if ( tagInfo[nIndex].equals(getTagName()) ) {
			children.add( this ) ;
		}
	}
*/
	// q̍쐬
	String szTag = null;
	for ( int nIndex=0 ; nIndex<tagInfo.length ; nIndex++ ) {
		if ( tagInfo[nIndex] != null ) {
			if ( szTag == null ) {
				szTag = tagInfo[nIndex];
			} else {
				szTag += " "+tagInfo[nIndex];
			}
		}
	}
	if ( szTag != null ) {
		children.addAll( findChildElements(szTag) );
	}
	return children;
	}

	/**
	 * qGǧ
	 *
	 * @param tag   ^O(Xy[Xŋ؂ĕLq\)
	 */
	public Vector findChildElements(String tag) {
	Vector children = new Vector();
	NodeList list = getChildNodes();
	for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
		Node child = list.item(nAt);
		if ( child instanceof XElementNS ) {
			children.addAll(((XElementNS)child).findElements(tag));
		}
	}
	return children;
	}

	/**
	 * Ƀqbg邩
	 *
	 * {IɂSQLƓ`ɂ
	 * ^O̊Kwǂꍇ́Ae^O.q^Ǒ`ŊKwLq
	 *
	 * @param tag ^O
	 * @param where   
	 */
	protected boolean isMatch(String where) {
	if ( where == null ) {
		return true;
	}
	// 
	boolean bMatch = false;
	String[] szMatch = ZString.tokenfirst(where,"=");
	if ( szMatch.length==2 ) {
		String szValue = getAttribute(szMatch[0]);
		if ( szValue != null && szValue.equalsIgnoreCase(szMatch[1]) ) {
//			ZDebug.trace("where:::"+where+":::    value:"+szValue+":::==:::"+szMatch[1]);
			bMatch = true;
		}
	}
	return bMatch;
	}

	/**
	 * qGg̎擾
	 * ݂Ȃꍇ͍쐬
	 *
	 * @param tag   ^O(qGg̏)
	 */
	public XElementNS getChildElement(String tag,String where) {
	XElementNS node = findChildElement( tag, where );
	if ( node == null ) {
//		ZDebug.trace("createChildElement");
		node = createChildElement( tag );
		if ( where == null ) {
			// \̂߁AύXȂ(=q^Õm[h)nbVe[uɓo^
			mHash.put( tag, node );
		} else {
			// Agr[gݒ
			String[] szMatch = ZString.tokenfirst(where,"=");
			node.setAttribute(szMatch[0],szMatch[1]);
		}
	}
	return node;
	}

	/**
	 * qGg̍쐬
	 *
	 * @param tag   ^O(qGg̏)
	 */
	public XElementNS createChildElement(String tag) {
//	ZDebug.trace(tag);
	if ( tag.startsWith(".") ) {
		tag = tag.substring(1);
	}
	String[] childTag = ZString.tokenfirst(tag,".");

	XElementNS child = null;

	if ( childTag[1] != null ) {
		// ^OKw\ɂȂĂꍇ
		child = findChildElement("."+childTag[0],null);
		if ( child == null ) {
			child = (XElementNS)getOwnerDocument().createElementNS(null,childTag[0]);
//			ZDebug.trace("CreateElement:"+getTagName()+""+childTag[0]);
			appendChild(child);
		}
		return child.createChildElement(childTag[1]);
	}

	child = (XElementNS)getOwnerDocument().createElementNS(null,childTag[0]);
	appendChild(child);
	return child;
	}

	//## vpeB`FWXi[ ###################################
	/**
     * ԕύXXi[̓o^
     * @param lis Xi[
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
	mListener.add(listener);
	}

	/**
     * ԕύXXi[̍폜
     * @param lis Xi[
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
	mListener.remove(listener);
	}

	/**
     * ԕύX̒ʒm
	 * @param evt Cvbg{bNXCxg
	 */
	public void firePropertyChanged( String event, Object oldValue, Object newValue ) {
	// Cxg̒ʒm
	PropertyChangeEvent evt = new PropertyChangeEvent(this,event,oldValue,newValue);
	firePropertyChanged(evt);
	}

	/**
     * ԕύX̒ʒm
	 * @param evt Cvbg{bNXCxg
	 */
	public void firePropertyChanged( PropertyChangeEvent evt ) {
	if ( mLock ) {
		return;
	}
	mLock = true;
	Enumeration elm = mListener.elements();
	while ( elm.hasMoreElements() ) {
		PropertyChangeListener listener = (PropertyChangeListener)elm.nextElement();
		listener.propertyChange( evt );
	}
	mLock = false;
	}

	//## TuNXFAhDIuWFNgiinsert,removeʁj#########
	/**
	 * XElementpundoIuWFNg
	 */
	public class XUndoElement implements IFUndoElement {
	/**
	 * RXgN^
	 * @param org IWiIuWFNg
	 * @param obj XVIuWFNg
	 * @param ref QƃIuWFNg
	 */
	public XUndoElement(XElementNS org, Object obj, Object ref) {
	mOrg = org ;
	mObj = obj ;
	mRef = ref ;
	}

	/**
	 * AhD
	 */
	public void undo() {
	}

	/**
	 * hD
	 */
	public void redo() {
	}

	/**
	 * IWiIuWFNg̎擾
	 */
	public void getFobs( Vector items ) {
	items.add( mOrg );
	items.add( mObj );
	}

	//## Agr[g################################################
	/**
	 * IWiIuWFNg
	 */
	protected XElementNS  mOrg = null ;
	
	/**
	 * XVIuWFNg
	 */
	protected Object      mObj = null ;
	
	/**
	 * QƃIuWFNg
	 */
	protected Object      mRef = null ;
	}

	//## TuNXFAhDIuWFNgiinsertpj##################
	/**
	 * XElementpundoIuWFNg(insertp)
	 */
	public class XUndoInsertElement extends XUndoElement {
	/**
	 * RXgN^
	 * @param org IWiIuWFNg
	 * @param obj XVIuWFNg
	 * @param ref QƃIuWFNg
	 */
	public XUndoInsertElement(XElementNS org, Node obj, Node ref) {
	super( org, obj, ref );
	}

	/**
	 * AhD
	 */
	public void undo() {
	mOrg.removeChildNoUndo((Node)mObj);
	}

	/**
	 * hD
	 */
	public void redo() {
	mOrg.insertBeforeNoUndo((Node)mObj,(Node)mRef);
	}
	}

	//## TuNXFAhDIuWFNgiremovepj##################
	/**
	 * XElementpundoIuWFNg(removep)
	 */
	public class XUndoRemoveElement extends XUndoElement {
	/**
	 * RXgN^
	 * @param org IWiIuWFNg
	 * @param obj XVIuWFNg
	 * @param ref QƃIuWFNg
	 */
	public XUndoRemoveElement(XElementNS org, Node obj, Node ref) {
	super( org, obj, ref );
	}

	/**
	 * AhD
	 */
	public void undo() {
	mOrg.insertBeforeNoUndo((Node)mObj,(Node)mRef);
	}

	/**
	 * hD
	 */
	public void redo() {
	mOrg.removeChildNoUndo((Node)mObj);
	}
	}

	//## TuNXFAhDIuWFNgiattributepj###############
	/**
	 * XElementpundoIuWFNg(attributep)
	 */
	public class XUndoSetAttribute extends XUndoElement {
	/**
	 * RXgN^
	 * @param org IWiIuWFNg
	 * @param name Agr[g
	 * @param obj ݒl
	 * @param ref ݒO̒l
	 */
	public XUndoSetAttribute(XElementNS org, String name, String obj, String ref) {
	super( org, obj, ref );
	mName = name;
	}

	/**
	 * AhD
	 */
	public void undo() {
	String str = (String)mRef;
	if ( str.length()==0 ) {
		mOrg.removeAttributeNoUndo( mName );
	} else {
		mOrg.setAttributeNoUndo( mName, str );
	}
	}

	/**
	 * hD
	 */
	public void redo() {
	String str = (String)mObj;
	if ( str.length()==0 ) {
		mOrg.removeAttributeNoUndo( mName );
	} else {
		mOrg.setAttributeNoUndo( mName, str );
	}
	}
	
	//## Agr[g################################################
	/**
	 * Agr[g
	 */
	protected String mName = null ;

	}

	//## Agr[g################################################
    /**
     * vpeBt@C[bN
     * CxgĔ\̂ŁȀꍇ̓CxgʒmȂ悤
     * 邽߂̃tO
     */
	protected boolean 	mLock		= false;

    /**
     * vpeB`FWXi[
     */
	protected Vector	mListener	= new Vector();

    /**
     * nbVe[u
     */
	protected Hashtable mHash	= new Hashtable();
}
