/*
 * @(#)ZPath.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.geom;

import java.awt.Shape;

import java.awt.geom.PathIterator;

import java.util.Vector;

import jp.co.iti.fagot.util.ZDebug;

/**
 * geompbP[ẂAJava{f[^NX({double)𗘗p₷
 * NXgp̖̒Zk̂߂ƁA̓Ǝ\bhǉ̂߂
 * pB
 *
 * GeneralPath ̃|CgҏW₷邽߂̃NX
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class ZPath extends ZGeneralPath {

	/**
	 * RXgN^
	 */
	public ZPath() {
	super();
	}

	/**
	 * RXgN^
	 */
	public ZPath(int rule) {
	super(rule);
	}

	/**
	 * RXgN^
	 */
	public ZPath( int rule, int initialCapacity ) {
	super(rule, initialCapacity);
	}

	/**
	 * RXgN^
	 */
	public ZPath(int rule, int initialTypes, int initialCoord) {
	super(rule,initialTypes,initialCoord);
	}

	/**
	 * RXgN^
	 */
	public ZPath( Shape s ) {
	super(s);
	}

	/**
	 * RXgN^
	 */
	public ZPath( byte[] types, double[] coords ) {
	super();
	append(types,coords,true);
	}

	//## l ###########################################################
	/**
	 * pX̐ݒ
	 */
	public void setPath(ZPath path) {
	reset();
	append(path,false);
	}

	/**
	 * ^CvXg̐̎擾
	 */
	public int getNumTypes() {
		return numTypes;
	}

	/**
	 * ^CvXg̎擾
	 */
	public byte[] getTypes() {
		return pointTypes;
	}

	/**
	 * WXg̎擾
	 */
	public double[] getCoords() {
		return pointCoords;
	}

	/**
	 * pX̒ǉ
	 */
	public void append( byte[] types, double[] coords, boolean connect ) {
	int nAt = 0;
	for ( int nIndex=0 ; nIndex < types.length ; nIndex++ ) {
	    switch (types[nIndex]) {
		  case SEG_MOVETO:
			if (!connect || numTypes < 1 || numCoords < 2) {
				moveTo(coords[nAt+0], coords[nAt+1]);
				nAt += 2;
				break;
			}
			if (pointTypes[numTypes - 1] != SEG_CLOSE &&
				pointCoords[numCoords - 2] == coords[nAt+0] &&
				pointCoords[numCoords - 1] == coords[nAt+1]) {
			    // Collapse out initial moveto/lineto
				nAt += 2;
				break;
			}
			// NO BREAK;
	      case SEG_LINETO:
			lineTo(coords[nAt+0], coords[nAt+1]);
			nAt += 2;
			break;
		  case SEG_QUADTO:
			quadTo(coords[nAt+0], coords[nAt+1],
				   coords[nAt+2], coords[nAt+3]);
			nAt += 4;
			break;
		  case SEG_CUBICTO:
			curveTo(coords[nAt+0], coords[nAt+1],
					coords[nAt+2], coords[nAt+3],
					coords[nAt+4], coords[nAt+5]);
			nAt += 6;
			break;
		  case SEG_CLOSE:
			closePath();
			break;
	    }
	    connect = false;
	}
	}

	//## Agr[g ###############################################
    // For code simplicity, copy these constants to our namespace
    // and cast them to byte constants for easy storage.
    public static final byte SEG_MOVETO  = (byte) PathIterator.SEG_MOVETO;
    public static final byte SEG_LINETO  = (byte) PathIterator.SEG_LINETO;
    public static final byte SEG_QUADTO  = (byte) PathIterator.SEG_QUADTO;
    public static final byte SEG_CUBICTO = (byte) PathIterator.SEG_CUBICTO;
    public static final byte SEG_CLOSE   = (byte) PathIterator.SEG_CLOSE;

}
