/*
 * @(#)ZRectangle.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.geom;

import java.awt.Shape;

import java.awt.geom.Rectangle2D;
import java.awt.geom.Ellipse2D;

/**
 * geompbP[ẂAJava{f[^NX({double)𗘗p₷
 * NXgp̖̒Zk̂߂ƁA̓Ǝ\bhǉ̂߂
 * pB
 *
 * Rectangle
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class ZRectangle extends Rectangle2D.Double {

	/**
	 * RXgN^
	 */
	public ZRectangle() {
	}

	/**
	 * RXgN^
	 */
	public ZRectangle(double x,double y,double w,double h) {
	this();
	setRect(x,y,w,h);
	}

	/**
	 * RXgN^
	 */
	public ZRectangle( ZPoint pt1, ZPoint pt2 ) {
	this();
	setRect(Math.min(pt1.getX(),pt2.getX()),Math.min(pt1.getY(),pt2.getY()),
		  Math.abs(pt1.getX()-pt2.getX()),Math.abs(pt1.getY()-pt2.getY()) );
	}

	/**
	 * RXgN^
	 */
	public ZRectangle( Rectangle2D rect ) {
	this();
	setRect(rect.getX(),rect.getY(),rect.getWidth(),rect.getHeight());
	}

	/**
	 * RXgN^
	 */
	public ZRectangle( Shape sh ) {
	this();
	Rectangle2D rect = sh.getBounds2D();
	setRect(rect.getX(),rect.getY(),rect.getWidth(),rect.getHeight());
	}

	/**
	 * fobO
	 */
	public String toString() {
	return new String("jp.co.iti.fagot.geom.ZRectangle:" + 
					  "x="      + getX()      + "," +
					  "y="      + getY()      + "," +
					  "width="  + getWidth()  + "," +
					  "height=" + getHeight() ) ;
	}
	//## I[oCh #################################################
	/**
	 * XW̎擾
	 */
	public double getX() {
	return x;
	}

	/**
	 * YW̎擾
	 */
	public double getY() {
	return y;
	}

	/**
	 * ̎擾
	 */
	public double getWidth() {
	return width;
	}

	/**
	 * ̎擾
	 */
	public double getHeight() {
	return height;
	}

	/**
	 * 󂩔ۂ̔
	 */
	public boolean isEmpty() {
	    return (getWidth() <= 0.0) || (getHeight() <= 0.0);
	}

	/**
	 * `̐ݒ
	 */
	public void setRect(double x, double y, double w, double h) {
	this.x = x;
	this.y = y;
	this.width = w;
	this.height = h;
	}

	/**
	 * `̐ݒ
	 */
	public void setRect(Rectangle2D r) {
	setRect(r.getX(),r.getY(),r.getWidth(),r.getHeight());
	}

	/**
	 * w肵Ẅʒu𔻒肵܂
	 */
	public int outcode(double x, double y) {
	int out = 0;
	if (getWidth() <= 0) {
		out |= OUT_LEFT | OUT_RIGHT;
	} else if (x < getX()) {
		out |= OUT_LEFT;
	} else if (x > getX() + getWidth()) {
		out |= OUT_RIGHT;
	}
	if (getHeight() <= 0) {
		out |= OUT_TOP | OUT_BOTTOM;
	} else if (y < getY()) {
		out |= OUT_TOP;
	} else if (y > getY() + getHeight()) {
		out |= OUT_BOTTOM;
	}
    return out;
	}

	/**
	 * `̎擾
	 */
	public Rectangle2D getBounds2D() {
	    return new ZRectangle(this);
	}

	/**
	 * ʕ̋`̎擾
	 */
	public Rectangle2D createIntersection(Rectangle2D r) {
	Rectangle2D dest = new ZRectangle();
	Rectangle2D.intersect(this, r, dest);
	return dest;
	}

	/**
	 * aW̋`̎擾
	 */
	public Rectangle2D createUnion(Rectangle2D r) {
	Rectangle2D dest = new ZRectangle();
	Rectangle2D.union(this, r, dest);
	return dest;
	}

	//## ǉ\bh #################################################
	/**
	 * ړ
	 */
	public void translate(double x, double y) {
	setLocation(getX()+x,getY()+y) ;
	}

	/**
	 * ړ
	 */
	public void translate( ZPoint pt) {
	translate( pt.getX(), pt.getY() );
	}

	/**
	 * ړ
	 */
	public void setLocation(double x, double y ) {
	this.x = x;
	this.y = y;
	}

	/**
	 * ړ
	 */
	public void setLocation( ZPoint pt) {
	setLocation( pt.getX(), pt.getY() );
	}

	/**
	 * ړ
	 */
	public void setCenter(double x, double y ) {
	setLocation( x-getWidth()/2, y-getWidth()/2 );
	}

	/**
	 * ړ
	 */
	public void setCenter( ZPoint pt) {
	setCenter( pt.getX(), pt.getY() );
	}

	/**
	 * TCY̎擾
	 */
	public ZDimension getSize() {
	return( new ZDimension( getWidth(), getHeight() ) ) ;
	}

	/**
	 * `̃}[W
	 */
	public void union( ZRectangle rect ) {
	Rectangle2D unirect = createUnion(rect);
	setRect( unirect );
	}

	/**
	 * W܂ނH
	 */
	public boolean contains( ZPoint pt ) {
	return contains( pt.getX(), pt.getY() );
	}

	/**
	 * ʒu̎擾
	 */
	public ZPoint getTopLeft() {
	return new ZPoint( getX(), getY() );
	}

	/**
	 * ʒu̎擾
	 */
	public ZPoint getCenter() {
	return new ZPoint( getX()+getWidth()/2, getY()+getHeight()/2 );
	}

	/**
	 * ȉ~̎擾
	 */
	public Ellipse2D getEllipse2D() {
	return new Ellipse2D.Double( getX(),getY(),getWidth(),getHeight() );
	}

	//## FAGOT ########################################################
	/**
	 * XW̐ݒ
	 */
	public void setX( double x ) {
	this.x = x;
	}

	/**
	 * YW̐ݒ
	 */
	public void setY( double y ) {
	this.y = y;
	}

	/**
	 * ̐ݒ
	 */
	public void setWidth( double w ) {
	this.width = w;
	}

	/**
	 * ̐ݒ
	 */
	public void setHeight( double h ) {
	this.height = h;
	}

	//## Agr[g ###############################################
	/**
	 * XW
	 */
	protected double x;

	/**
	 * YW
	 */
	protected double y;

    /**
     * 
     */
	protected double width;

    /**
     * 
     */
	protected double height;
}
