/**
 * @(#)GOperationSelect.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.gob;

import java.util.Enumeration;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZDebug;
/**
 * IIy[V
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GOperationSelect extends GRectangle {

	/**
	 * RXgN^
	 */
	public GOperationSelect() {
		super();
	}

	//## ړ##########################################################
	/**
	 * 쎞̈ړ[h
	 * @param pt _W
	 */
	public byte getHitModeGob(ZPoint pt) {
	return GOperation.SELECTION;
	}

	/**
	 * Öړ[h
	 * @param pt _W
	 */
	public byte getPreMoveModeGob(ZPoint pt) {
	return GOperation.SELECTION;
	}

	/**
	 * ړ̏I
	 * @param grid ObhRg[
	 */
	public void moveEndGob( DocGridControler grid ) {
	ZRectangle rect = getMovingRectGob( grid ) ;

	// Gg̎擾
	DocPane editor = grid.getEditor();
	Enumeration elm = GobManager.getElement(editor.getPanelId()).elements() ;
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		if ( rect.contains( item.getTransformedBounds() ) ) {
			item.setSelect(true);
		}
	}
	}

	/**
	 * ړPath̎擾
	 * @param grid ObhRg[[
	 */
	public ZRectangle getMovingRectGob(DocGridControler grid) {
	return new ZRectangle( grid.getStartPoint(), grid.getMovePoint() );
	}

	//## Agr[g################################################
}
