/**
 * @(#)GOperationZoom.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.gob;

import java.awt.Point;
import java.awt.Dimension;

import javax.swing.JComponent;
import javax.swing.JViewport;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZDebug;

/**
 * gEkIy[V
 *
 * ړPath͑IIy[V(GOperationSelect)ƓȂ̂ŁA
 * GOperationSelect̔hNXƂ
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GOperationZoom extends GOperationSelect {

	/**
	 * RXgN^
	 * @param isZoom ĝƂTrue
	 */
	public GOperationZoom(boolean isZoom) {
		super();
		wIsZoom = isZoom;
	}

	//## l ###########################################################

	//## ʒu##########################################################

	//## ړ##########################################################
	/**
	 * 쎞̈ړ[h
	 * @param pt _W
	 */
	public byte getHitModeGob(ZPoint pt) {
	return GOperation.ZOOMON;
	}

	/**
	 * Öړ[h
	 * @param pt _W
	 */
	public byte getPreMoveModeGob(ZPoint pt) {
	if ( wIsZoom ) {
		return GOperation.ZOOMIN;
	}
	return GOperation.ZOOMOUT;
	}

	//## ړ##########################################################
	/**
	 * ړ̏I
	 * @param grid ObhRg[
	 */
	public void moveEndGob( DocGridControler grid ) {
	// ݍW̑ޔ
	ZPoint staPt = grid.getStartPoint();
	ZPoint curPt = grid.getMovePoint();
	ZPoint center = null;

	DocPane editor = grid.getEditor();
	JViewport port = (JViewport)editor.getParent();

	// ϊW{g|k}
	DocElement root = (DocElement)editor.getDocument().getRootElement(editor.getPanelId());
	double scale = root.getDisplayScale(editor.getPanelId());
	// NbN덷5sNZƂ
	double dd = 5;
	if ( staPt.getX()-dd < curPt.getX() &&
		 staPt.getX()+dd > curPt.getX() &&
		 staPt.getY()-dd < curPt.getY() &&
		 staPt.getY()+dd > curPt.getY() ) {
		// قƂǈړĂȂꍇ́ANbN_𒆉ɂ
		// g嗦̕ύX
//		ZDebug.trace("***sta="+staPt.toString()+"  curPt="+curPt.toString());
//		ZDebug.trace("-----------at.getScaleX()"+at.getScaleX());
		if ( wIsZoom ) {
			scale *= 1.25;
		} else {
			scale /= 1.25;
		}
		center = curPt;
	} else {
		// `w肳ꂽAw肳ꂽ̈\悤ɍWvZ
//		ZDebug.trace("---sta="+staPt.toString()+"  curPt="+curPt.toString());
		Dimension dim  = port.getSize();
		double dx = dim.width/ Math.max(1,Math.abs(staPt.getX()-curPt.getX()));
		double dy = dim.height/Math.max(1,Math.abs(staPt.getY()-curPt.getY()));
		scale = Math.min(dx,dy);
//		ZDebug.trace("dx="+staPt.getX()+"-"+curPt.getX()+"/"+dim.width);
//		ZDebug.trace("dy="+staPt.getY()+"-"+curPt.getY()+"/"+dim.height);
//		ZDebug.trace("dz="+dx+" ? "+dy);

		center = new ZPoint( (staPt.getX()+curPt.getX())/2,
							 (staPt.getY()+curPt.getY())/2 );
	}

	// ő/ŏTCYւ̕␳
//	ZDebug.trace("-----------at.getScaleX()"+at.getScaleX());
	if ( scale > 4.00 ) {
		scale = 4.00;
	} else if ( scale < 0.1 ) {
		scale = 0.1;
	}
//	ZDebug.trace("-----------at.getScaleX()"+at.getScaleX());

	// |[g̍ăCAEg
	root.setDisplayScale(editor.getPanelId(),scale);
	port.doLayout();

	// r[|[g̈ړ
	editor.setCenter( center );
	}

	/**
	 * ړ̊KvH
	 */
	public boolean needsMoveEnd() {
	return true;
	}

	//## Agr[g################################################
	/**
	 * {g|k}
	 * g̎True
	 */
	protected boolean wIsZoom = true;
}
