/*
 * @(#)PStyle.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.gob;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.FFloat;
import jp.co.iti.fagot.fob.FDouble;
import jp.co.iti.fagot.fob.FString;

/**
 * PnNX͕`敔i̕`摮(vpeB)i[
 *
 * http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtdɂ
 * PresentationAttributes-FillStroke ɑΉ
 *
 * Style
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class PStyle {
	/**
	 * RXgN^
	 */
	public PStyle() {
		//{{FAGOT_ATTR
		mFill             = new PFill();
		mStroke           = new PStroke();
		//}}FAGOT_ATTR
	}

	//## l ###########################################################
	/**
	 * ̐ݒ
	 */
	public void set(PStyle src) {
		mFill.set(src.getFill());
		mStroke.set(src.getStroke());
	}

	/**
	 * ̒ǉ
	 */
	public void add(PStyle src) {
		mFill.add(src.getFill());
		mStroke.add(src.getStroke());
	}

	/**
	 * hԂ̎擾
	 */
	public PFill getFill() {
		return mFill ;
	}

	/**
	 * ̎擾
	 */
	public PStroke getStroke() {
		return mStroke ;
	}

	//## qvf̒l : Fill ############################################
	// PȂpXX[\bh
	// qvf𓝍Kv邩H
	/**
	 * F̎擾
	 */
	public FColor getFillColor() {
		return getFill().getColor();
	}

	/**
	 * ߓx̎擾
	 */
	public FFloat getFillOpacity( ) {
		return getFill().getOpacity();
	}

	/**
	 * [̎擾
	 */
	public FString getFillRule( ) {
		return getFill().getRule();
	}

	/**
	 * F̐ݒ
	 */

	public void setFillColor( FColor color ) {
		getFill().getColor().set( color );
	}

	/**
	 * ߓx̐ݒ
	 */
	public void setFillOpacity( FFloat opacity ) {
		getFill().getOpacity().set( opacity );
	}

	/**
	 * [̐ݒ
	 */
	public void setFillRule( FString rule ) {
		getFill().getRule().set( rule );
	}

	//## qvf̒l : Stroke ##########################################
	/**
	 * F̎擾
	 */
	public FColor getStrokeColor() {
		return getStroke().getColor();
	}

	/**
	 * F̐ݒ
	 */

	public void setStrokeColor( FColor color ) {
		getStroke().getColor().set( color );
	}

	//## FAGOT ########################################################
	/**
	 * Fob}l[W̓o^([Uf[^̓pXX[)
	 * @param mgr }l[W
	 * @param usrData [Uf[^
	 */
	public void setFobManager(FobManager mgr, Object usrData) {
		//{{FAGOT_ATTR
		mFill.setFobManager(mgr,usrData);
		mStroke.setFobManager(mgr,usrData);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * ̍쐬
	 */
	public Object clone() {
	PStyle obj = new PStyle();
	obj.set(this);
	return obj;
	}

	//## Agr[g ###############################################
	/**
	 * hԂ
	 */
	protected PFill   mFill;

	/**
	 * 
	 */
	protected PStroke mStroke;

}
