/**
 * @(#)RUpdateManager.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : UpdateManager
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid;

import javax.swing.JTable;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.ui.UFrame;
import jp.co.iti.fagot.ui.UWindowManager;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocBar;
import jp.co.iti.fagot.doc.DocDocument;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.table.RTable;
import jp.co.nri.rid.table.LineNoRowHeader;

/**
 * UpdateManager
 * ʂ̍XVԂǗNX
 * [UANV̌Aupdate\bhĂяoƁA
 * <ul>
 * <li>^uV[g̃ANeBuȃpl
 * <li>DocBar
 * <li>vpeBEBhE
 * <li>L}
 * <li>c[o[enable
 * </ul>
 * ŐV̏ԂɍXVB
 */
public class RUpdateManager {

	/**
	 * ʂ̍XV
	 * @param nId XVID
	 */
	static public void update( int nId ) {
		update( nId, false );
	}

	/**
	 * ʂ̍XV
	 * @param nId     XVID
	 * @param bLayout ʕ\̍œK
	 */
	static public void update( int nId, boolean bLayout ) {
	String szActive = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );

	// ANeBupl̍XV
	boolean activePanelUpdate = false;
	if ( nId == 0 ) {
		nId = UPDATE_PROPERTY|UPDATE_PAN|UPDATE_DOCBAR;
		activePanelUpdate = true;
	} else if ( nId == PROPERTY_CHANGED ) {
		nId = 0;
		activePanelUpdate = true;
		mPropertyUpdate = true;
	}

	int nActivePanel = 0;
	int nChildWindow = 0;
	if ( activePanelUpdate ) {
		if ( szActive.equals(	 Rid.PANEL_ZONE			) ) { nId |= UPDATE_ZONE      ; nActivePanel = Rid.PANEL_ZONE_INDEX      ; nChildWindow = 1 ; }
		else if ( szActive.equals(Rid.PANEL_MAP			) ) { nId |= UPDATE_MAP       ; nActivePanel = Rid.PANEL_MAP_INDEX       ; nChildWindow = 1 ; }
		else if ( szActive.equals(Rid.PANEL_PAGES		) ) { nId |= UPDATE_PAGES     ; nActivePanel = Rid.PANEL_PAGES_INDEX     ; nChildWindow = 2 ; }
		else if ( szActive.equals(Rid.PANEL_RESOURCES	) ) { nId |= UPDATE_RESOURCES ; nActivePanel = Rid.PANEL_RESOURCES_INDEX ; nChildWindow = 2 ; }
		else if ( szActive.equals(Rid.PANEL_DOCUMENTS	) ) { nId |= UPDATE_DOCUMENTS ; nActivePanel = Rid.PANEL_DOCUMENTS_INDEX ; nChildWindow = 2 ; }
		else if ( szActive.equals(Rid.PANEL_PAGERES		) ) { nId |= UPDATE_PAGERES   ; nActivePanel = Rid.PANEL_PAGERES_INDEX   ; nChildWindow = 2 ; }
		else if ( szActive.equals(Rid.PANEL_LINKS		) ) { nId |= UPDATE_LINKS     ; nActivePanel = Rid.PANEL_LINKS_INDEX     ; nChildWindow = 2 ; }
		else if ( szActive.equals(Rid.PANEL_SEARCH		) ) { nId |= UPDATE_SEARCH    ; nActivePanel = Rid.PANEL_SEARCH_INDEX    ; nChildWindow = 2 ; }
	}

	// Zonepl̍XV
	if ( ( nId & UPDATE_ZONE )!=0 && szActive.equals(Rid.PANEL_ZONE) ) {
		DocPane zonePanel = (DocPane)ZInstance.map().get(Rid.PANEL_ZONE);
//		DocDocument siteDoc = zonePanel.getDocument();
		zonePanel.updateGobs();
		if ( bLayout ) {
			zonePanel.updateLayout();
		} else {
			zonePanel.repaint();
		}

		// Zonepl^Cg̍XV
		RidZoneTitlePane title = (RidZoneTitlePane)ZInstance.map().get(Rid.PANEL_ZONE_TITLE);
		title.restract();
	}

	// Mappl̍XV
	if ( ( nId & UPDATE_MAP )!=0 && szActive.equals(Rid.PANEL_MAP) ) {
		DocPane mapPanel = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
		DocDocument siteDoc = mapPanel.getDocument();
		mapPanel.updateGobs();
		if ( bLayout ) {
			mapPanel.updateLayout();
		} else {
			mapPanel.repaint();
		}

		// Mappl^Cg̍XV
		RidMapTitlePane title = (RidMapTitlePane)ZInstance.map().get(Rid.PANEL_MAP_TITLE);
		title.restract();
	}

	// PageXg̍XV
	if ( ( nId & UPDATE_PAGES )!=0  && szActive.equals(Rid.PANEL_PAGES) ) {
		RTable pageTable = (RTable)ZInstance.map().get(Rid.PANEL_PAGES);
		DocDocument siteDoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
		pageTable.reload(siteDoc);

		LineNoRowHeader header = (LineNoRowHeader)ZInstance.map().get(Rid.PANEL_PAGES_HEADER);
		header.resizeandrepaint();
	}

	// ResourceXg̍XV
	if ( ( nId & UPDATE_RESOURCES )!=0  && szActive.equals(Rid.PANEL_RESOURCES) ) {
		RTable resTable = (RTable)ZInstance.map().get(Rid.PANEL_RESOURCES);
		DocDocument resDoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
		resTable.reload(resDoc);

		LineNoRowHeader header = (LineNoRowHeader)ZInstance.map().get(Rid.PANEL_RESOURCES_HEADER);
		header.resizeandrepaint();
	}

	// DocumentXg̍XV
	if ( ( nId & UPDATE_DOCUMENTS )!=0  && szActive.equals(Rid.PANEL_DOCUMENTS) ) {
		RTable docTable = (RTable)ZInstance.map().get(Rid.PANEL_DOCUMENTS);
		DocDocument docDoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
		docTable.reload(docDoc);

		LineNoRowHeader header = (LineNoRowHeader)ZInstance.map().get(Rid.PANEL_DOCUMENTS_HEADER);
		header.resizeandrepaint();
	}

	// Page-ResourceΉ\̍XV
	if ( ( nId & UPDATE_PAGERES )!=0  && szActive.equals(Rid.PANEL_PAGERES) ) {
		RTable pageresTable = (RTable)ZInstance.map().get(Rid.PANEL_PAGERES);
		DocDocument resDoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
		pageresTable.reload(resDoc);

		LineNoRowHeader header = (LineNoRowHeader)ZInstance.map().get(Rid.PANEL_PAGERES_HEADER);
		header.resizeandrepaint();
	}

	// Link\̍XV
	if ( ( nId & UPDATE_LINKS )!=0  && szActive.equals(Rid.PANEL_LINKS) ) {
		RTable linkTable = (RTable)ZInstance.map().get(Rid.PANEL_LINKS);
		DocDocument siteDoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
		linkTable.reload(siteDoc);

		LineNoRowHeader header = (LineNoRowHeader)ZInstance.map().get(Rid.PANEL_LINKS_HEADER);
		header.resizeandrepaint();
	}

	UFrame frame = (UFrame)ZApp.getTheApp();
	UWindowManager wnd = frame.getWindowManager();
	// vpeBpl̍XV
	if ( ( nId & UPDATE_PROPERTY ) != 0 ) {

		if ( mPropertyUpdate ) {
			// vpeBpl̍XV̓vpeBplXVȂ
			mPropertyUpdate = false;
		} else if ( wnd != null ) {
			wnd.updateWindow(0);
		}
	}

	// ppl̍XV
	if ( ( nId & UPDATE_PAN ) != 0 && wnd != null ) {
		wnd.updateWindow(1);
	}

	// Docbar̍XV
	if ( ( nId & UPDATE_DOCBAR ) != 0 ) {
		DocBar bar = (DocBar)ZInstance.map().get(Rid.DOCBAR);
		bar.setPanel(nActivePanel);
	}

	// AvP[VNɂ͍XVȂ
	if ( ZInstance.map().get( Rid.DOCUMENT_SITE ) != null ) {
		// qEBhE̊J
		if ( wnd != null ) {
			if ( nChildWindow == 1 ) {
				frame.getWindowManager().openWindow();
			} else if ( nChildWindow == 2 ) {
				frame.getWindowManager().closeWindow();
			}

			// c[o[ɕ\ĂANV̍XV
			((ZAction)frame.getAction("undo")).update();
			((ZAction)frame.getAction("redo")).update();
			((ZAction)frame.getAction("cut")).update();
			((ZAction)frame.getAction("childwin0")).update();
			((ZAction)frame.getAction("childwin1")).update();
		}
	}

	}

	//## Agr[g ###############################################
	/**
	 * vpeBXVtO
	 */
	static protected boolean mPropertyUpdate = false;

	/**
	 * XVڒ`F][pl
	 */
	final static public int UPDATE_ZONE			= 0x0001;

	/**
	 * XVڒ`F}bvpl
	 */
	final static public int UPDATE_MAP			= 0x0004;

	/**
	 * XVڒ`FXgpl
	 */
	final static public int UPDATE_PAGES		= 0x0010;

	/**
	 * XVڒ`F\[Xpl
	 */
	final static public int UPDATE_RESOURCES	= 0x0020;

	/**
	 * XVڒ`FhLgpl
	 */
	final static public int UPDATE_DOCUMENTS	= 0x0040;

	/**
	 * XVڒ`Fy[W\[XΉ\pl
	 */
	final static public int UPDATE_PAGERES		= 0x0080;

	/**
	 * XVڒ`FNpl
	 */
	final static public int UPDATE_LINKS		= 0x2000;

	/**
	 * XVڒ`Fpl
	 */
	final static public int UPDATE_SEARCH		= 0x1000;

	/**
	 * XVڒ`FvpeBEBhE
	 */
	final static public int UPDATE_PROPERTY		= 0x0100;

	/**
	 * XVڒ`FL}
	 */
	final static public int UPDATE_PAN			= 0x0200;

	/**
	 * XVڒ`FhLgo[
	 */
	final static public int UPDATE_DOCBAR		= 0x0400;

	/**
	 * XVID`FhLg̍XV
	 */
	final static public int SET_DOCUMENT			= 0;

	/**
	 * XVID`FANeBupl̍XV
	 */
	final static public int PANEL_ACTIVE			= 0;

	/**
	 * XVID`FANeBupl̃XN[
	 */
	final static public int PANEL_SCROLL			= UPDATE_PAN;

	/**
	 * XVID`FvpeB̍XV
	 */
	final static public int PROPERTY_CHANGED		= 0xFFFF;

	/**
	 * XVID`F{^up
	 */
	final static public int UIADATPER_LBTNUP		= UPDATE_PROPERTY|UPDATE_PAN ;

	/**
	 * XVID`Fʂ̍XV(gobč쐬)
	 */
	final static public int CREATE_GOBS				= UPDATE_PROPERTY|UPDATE_PAN ;

	/**
	 * XVID`Fʂ̍XV(I̍XV)
	 */
	final static public int SELECT_GOBS				= UPDATE_PROPERTY;

	/**
	 * XVID`FZonepl̕\XV
	 */
	final static public int VIEWACTION_VIEWZONE		= UPDATE_ZONE;

	/**
	 * XVID`FMappl̕\XV
	 */
	final static public int VIEWACTION_VIEWMAPPAGE	= UPDATE_MAP;
}
