/*
 * @(#)Ridual.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-3 : Site map editor
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/10/23
 */
package jp.co.nri;

import java.awt.BorderLayout;

import java.text.DecimalFormat;

import java.io.*;

import java.util.Properties;
import java.util.Enumeration;
import java.util.Vector;
import java.util.Locale;
import java.util.Calendar;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.ZSplashWindow;
import jp.co.iti.fagot.ZSplashPanel;
import jp.co.iti.fagot.IZFileable;

import jp.co.iti.fagot.action.ZChildWindowAction;
import jp.co.iti.fagot.action.ZFileAction;
import jp.co.iti.fagot.action.ZUIAction;
import jp.co.iti.fagot.action.ZExitAction;
import jp.co.iti.fagot.action.ZGroupToggleButton;

import jp.co.iti.fagot.ui.UFrame;
import jp.co.iti.fagot.ui.UDialog;

import jp.co.iti.fagot.doc.DocBar;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.IApplication;

import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZMessage;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZScript;
import jp.co.iti.fagot.util.ZResource;

import jp.co.nri.Rid;
import jp.co.nri.rid.RWindowManager;
import jp.co.nri.rid.RidMIT;

import jp.co.nri.rid.action.RidFileAction;
import jp.co.nri.rid.action.RidToolAction;
import jp.co.nri.rid.action.RidClipAction;
import jp.co.nri.rid.action.RidUndoAction;
import jp.co.nri.rid.action.RidGobAction;
import jp.co.nri.rid.action.RidListAction;
import jp.co.nri.rid.action.RidZoomAction;
import jp.co.nri.rid.action.RidEnvAction;
import jp.co.nri.rid.action.RidViewAction;
import jp.co.nri.rid.action.RidHelpAction;
import jp.co.nri.rid.action.RidProjectConfigAction;

import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidDocumentSite;

import jp.co.nri.rid.environment.EnvironmentDialog;
import jp.co.nri.rid.environment.MessageDialog;

import jp.co.nri.rid.error.RidMessage;
/**
 * RidEditor Main Program
 */
public class Ridual extends UFrame implements IZFileable {

	/**
	 * S
	 */
	final static String mLogo = "Ridual_logo.gif";
	
	/**
     * o[W̎擾
	 */
	static String getVersionInfo() {
	String szVar = "Ridual ";
	szVar += RidMIT.mVerMajor+".";
	szVar += RidMIT.mVerMinor+" ";
	szVar += "build ";
	szVar += new DecimalFormat("0000").format( RidMIT.mBuild );
/*
	if ( !RidMIT.checkMIT() ) {
		szVar += " *** trial ***";
	}
*/
	int pages = RidMIT.checkMIT();
	switch(pages){
	case 0:		// 
		szVar += " *** unlimited ***";
		break;
	case -3:	// NO
		break;
	case -2:	// trial
		szVar += " *** trial ***";
		break;
	case -1:	// CZXُ
		szVar += " *** license error ***";
		break;
	default:
		szVar += " *** " + pages + "p ***";
	}
	/** t3-nishimura@nri.co.jp added **/
	//szVar += " pre1";

	return szVar;
	}

	/**
     * RXgN^Ft@Cw
     * @param szFile  [ht@C
     * @param bWindow EBhE[h
	 */
	public Ridual(String szFile, boolean bShow) {
	super("main");

	if ( bShow ) {
		// EBhE[h
		init();

		boolean bLoad = false;
		if ( szFile == null ) {
			// OɊJt@C̓ǂݍ
			szFile = getResource().getString("recent1");
		}

		if ( szFile != null ) {
			bLoad = open(szFile);
		}

		while ( !bLoad ) {
			ZResource res = getResource();
			Object[] msg = new Object[2];
			ButtonGroup group = new ButtonGroup();
			JRadioButton btnNew  = new JRadioButton(res.getString("tool.new.tooltip"));
			JRadioButton btnOpen = new JRadioButton(res.getString("tool.open.tooltip"));
			group.add( btnNew )  ; msg[0] = btnNew ; btnNew.setSelected(true);
			group.add( btnOpen ) ; msg[1] = btnOpen;
			int result = JOptionPane.showOptionDialog(null,
				msg,"Ridual",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE,null,null,null);

			if ( result == JOptionPane.YES_OPTION ) {
				if ( btnNew.isSelected() ) {
					bLoad = open(null);
				} else if ( btnOpen.isSelected() ) {
					bLoad = ((RidFileAction)getAction(ZFileAction.OPEN)).openImpl();
				} else {
					System.exit(0);
				}
			} else {
				System.exit(0);
			}
		}

		// qEBhE̕\
		getWindowManager().openWindow();

	} else {
		// R}h[h
		ZApp.setTheApp(this);

		createResource()	;		// \[X̍쐬
//		createUIFactory()	;		// UIt@Ng[̍쐬
		ZResource res = getResource();
		if ( mRidXDir != null ) {
			res.putString("app.install.path",mRidXDir);
		}

		ZDebug.trace("rid-x dir:"+res.getString("app.install.path"));
		ZDebug.trace("version  :"+getVersionInfo());

		// AvP[V̏
		mApplication = DocManager.createApplication();

		// uEUNIt
		res.putBoolean("generate.browser",false);

		if ( szFile != null ) {
			RidualScript app = new RidualScript();
			// hLgJ
			boolean bRet = app.open(szFile);
			if ( bRet ) {
				// R}hs
				RidToolAction act = null;

				if ( mImpPage || mImpResource || mImpDocument) {
					app.setProperty("import.page",mImpPage);
					app.setProperty("import.resource",mImpResource);
					app.setProperty("import.document",mImpDocument);

					app.execImport();
				}

				if ( mAnalyze ) {
					app.execAnalyze();
				}

				if ( mProduct || mPresent || mSitemap ) {
					app.setProperty("generate.product",mProduct);
					app.setProperty("generate.present",mPresent);
					app.setProperty("generate.sitemap",mSitemap);
					app.execGenerate();
				}

				// hLgۑ
				if ( mImpPage || mImpResource || mImpDocument || mAnalyze ) {
					app.save();
				}
			}
		} else if ( mScript != null ) {
			// XNvg̎s
			ZDebug.trace("start script:"+mScript);
			ZScript scr = new ZScript();
			scr.loadScript( mScript ) ;
			scr.invoke("main",null);
		}
	}
	}
	
	private PrintStream getLog() throws FileNotFoundException {
		ZResource res = getResource();
		
		File inst		= new File(res.getString("app.install.path"));
		File todayLog	= new File(inst, res.getString("log.today"));
		
		String dt = res.getString("log.date");
		Calendar	cal	= Calendar.getInstance();
		String		now	= cal.get(Calendar.YEAR)+"/"+
						(cal.get(Calendar.MONTH) + 1)+"/"+
						cal.get(Calendar.DATE);
		if(now.equals(dt))	return new PrintStream(new FileOutputStream(todayLog.getAbsolutePath(), true));
		
		File yesterdayLog = new File(inst, res.getString("log.yesterday"));
		yesterdayLog.delete();
		todayLog.renameTo(yesterdayLog);
		res.putString("log.date", now);
		return new PrintStream(new FileOutputStream(todayLog));
	}
	
	/**
	 * AvP[V̏
	 */
	protected void init() {
	ZApp.setTheApp(this);

	createResource();		// \[X̍쐬
	
	ZResource res = getResource();
	
//	ZDebug.setTraceFile(log.getAbsolutePath());
	
	// AvP[VN󋵃`FbN
	int nPreMajor = res.getInt("app.major",-1);
	int nPreMinor = res.getInt("app.minor",-1);
	int nPreBuild = res.getInt("app.build",-1);

	res.putInt("app.major",RidMIT.mVerMajor);
	res.putInt("app.minor",RidMIT.mVerMinor);
	res.putInt("app.build",RidMIT.mBuild);

	if ( mRidXDir != null ) {
		res.putString("app.install.path",mRidXDir);
	}
	
//	o[WAbvɃ_CAO\̂~߂
/*
	if ( nPreMajor == -1        ||	// N
		 nPreMajor < mVerMajor  ||	// Major up
		 nPreMinor < mVerMinor  ||	// Minor up
		 nPreBuild < mBuild     ){	// Build up
		// ݒ_CAO̕\
		EnvironmentDialog env = new EnvironmentDialog();
		env.EnvDialog();
	}
*/

	// L&F ݒiݒ_CAO\Oɍsj
//	setLookAndFeel()	;		// UȈ
	setTitle()			;		// t[^Cg̕\

	// CXg[ɏlݒ
	if ( nPreMajor == -1 ){
		initialSetting();
		// ݒ_CAO̕\
		try {
			res.putBoolean("env.first",true);
			EnvironmentDialog env = new EnvironmentDialog();
			env.EnvDialog();
			saveResource();
	    } catch (Throwable t) {
		}
	}
	
	// Oo
	try{
		PrintStream ps = getLog();
		
		System.setOut(ps);
		System.setErr(ps);
	} catch(FileNotFoundException e){ e.printStackTrace(); }
	
	ZDebug.trace("rid-x dir:"+res.getString("app.install.path"));
	ZDebug.trace("version  :"+getVersionInfo());
	
	System.out.println("java "+
				System.getProperty("java.version")+"/"+
				System.getProperty("java.vendor")+"("+
				System.getProperty("java.vendor.url")+")");
	System.out.println("java-specification: "+
				System.getProperty("java.specification.name")+" "+
				System.getProperty("java.specification.version")+"/"+
				System.getProperty("java.specification.vendor"));
	System.out.println("javaVM: "+
				System.getProperty("java.vm.name")+" "+
				System.getProperty("java.vm.version")+"/"+
				System.getProperty("java.vm.vendor"));
	System.out.println("VM-specification: "+
				System.getProperty("java.vm.specification.name")+" "+
				System.getProperty("java.vm.specification.version")+"/"+
				System.getProperty("java.vm.specification.vendor"));
	System.out.println("JITcompiler: "+System.getProperty("java.compiler"));
	System.out.println("os: "+System.getProperty("os.name")+" "+
				System.getProperty("os.version")+"/"+
				System.getProperty("os.arch"));
	System.out.println("language: "+System.getProperty("user.language"));
	
	// Rid-x Dir̃`FbN
	while ( !checkRidxDir() ) {
		String szRidxDir = res.getString("app.install.path");
        RidMessage ridMsg = new RidMessage();
		MessageDialog.showError(ridMsg.Error("E1011",szRidxDir));

		// ݒ_CAO̕\
		try {
			res.putBoolean("env.first",true);
			EnvironmentDialog env = new EnvironmentDialog();
			env.EnvDialog();
			saveResource();
	    } catch (Throwable t) {
		}
	}

	getResource().loadGeometry(this,"main");	// t[̈ʒu擾

	addFrameAdapter()	;		// t[A_v^̐ݒ
	createUIFactory()	;		// UIt@Ng[̍쐬

	getContentPane().setLayout(new BorderLayout());	// pl̏

	// UI R|[lg̏
	createAction();
	createMenuBar();
	createToolBar();

	// AvP[V̏
	mApplication = DocManager.createApplication();
	mApplication.initApplication(this);

	// c[o[̃O[v
	createGroupToolBar();

	// EBhE}l[W̏
	setWindowManager( new RWindowManager(this) );

	// OɊJt@Cj[UIXV
	updateRecent( null );
	}

	//## C #######################################################
	/**
     * CvO
	 */
	public static void main(String[] args) {
    try {
		// o[W`FbN
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.1.2") < 0) {
            System.out.println("!!!WARNING: Swing must be run with a " +
                               "1.1.2 or higher version VM!!!");
        }

		// pł̃eXg
//		ZDebug.trace("English version");
//		Locale.setDefault( Locale.ENGLISH );

		String szInitFile = null;
		boolean bShow = true;
		boolean bScript = false;
		if ( args.length > 0 ) {
			for( int nIndex=0; nIndex<args.length; nIndex++ ) {
				ZDebug.trace(args[nIndex]);
				String arg = args[nIndex].toLowerCase();
				if ( args[nIndex].startsWith("-ridx_dir=") ) {
					mRidXDir = args[nIndex].substring(10);
				} else if ( args[nIndex].startsWith("-script=") ) {
					mScript  = args[nIndex].substring(8);	bShow = false;
				} else if ( args[nIndex].equals("-script") ) {
					bScript = true;			bShow = false;
				} else if ( args[nIndex].equals("-import_page") ) {
					mImpPage = true;		bShow = false;
				} else if ( args[nIndex].equals("-import_resource") ) {
					mImpResource = true;	bShow = false;
				} else if ( args[nIndex].equals("-import_document") ) {
					mImpDocument = true;	bShow = false;
				} else if ( args[nIndex].equals("-analyze") ) {
					mAnalyze = true;		bShow = false;
				} else if ( args[nIndex].equals("-generate_product") ) {
					mProduct = true;		bShow = false;
				} else if ( args[nIndex].equals("-generate_present") ) {
					mPresent = true;		bShow = false;
				} else if ( args[nIndex].equals("-generate_sitemap") ) {
					mSitemap = true;		bShow = false;
				} else if ( args[nIndex].equals("-english") ) {
					ZDebug.trace("English version");
					Locale.setDefault( Locale.ENGLISH );
				} else {
					if ( bScript ) {
						mScript = args[nIndex];
					} else {
						szInitFile = args[nIndex];
					}
				}
			}
		}
		
		/* j[o[ʏ㕔ɏo */
		System.setProperty("com.apple.macos.useScreenMenuBar", "true");
		System.setProperty("apple.laf.useScreenMenuBar", "true");

/*
		// VXevpeB̃fobO
		Properties prop = System.getProperties();
		Enumeration elm = prop.keys();
		while ( elm.hasMoreElements() ) {
			String szKey = (String)elm.nextElement();
			String szVal = prop.getProperty( szKey );
			ZDebug.trace(szKey+"="+szVal);
		}
*/

		if ( bShow ) {
			// EBhE[h
			Ridual.showSplashWindow()	;	// XvbVEBhE̕\

			Ridual app = new Ridual(szInitFile, bShow);

			app.show();
//			app.updatePropertyFrame()	;	// ʍĕ`
			Ridual.hideSplashWindow()	;	// XvbVEBhȄI

		} else {
			// R}h[h
			ZDebug.trace("Command mode");
			Ridual app = new Ridual(szInitFile, bShow);

			System.exit(0);

		}
    } catch (Throwable t) {
        System.out.println("uncaught exception: " + t);
        t.printStackTrace();
    }
	}

	//## UI ###########################################################
	/**
	 * XvbVEBhE̕\
	 */
	static protected void showSplashWindow() {
	mSplashWindow = new ZSplashWindow(mLogo,getVersionInfo());
	}

	/**
	 * XvbVEBhȄI
	 */
	static protected void hideSplashWindow() {
	mSplashWindow.dispose();
	mSplashWindow = null ;
//	ZDebug.trace("XvbVEBhȄI");
	}

	/**
	 * o[W̕\
	 */
	public void showVersion() {
	UDialog dlg = new UDialog(this,"version");
	dlg.setComponent( new ZSplashPanel( mLogo, getVersionInfo() ),false );
	dlg.setControlPanel(UDialog.OK);
	dlg.getRootPane().setDefaultButton(dlg.getOKButton());
	dlg.doModal();
	}

	//## ŗL #########################################################
	/**
	 * ANV쐬
	 */
	public void createAction() {
    Action[] defaultActions = {
		// t@Cj[
			new RidFileAction(this,this,ZFileAction.NEW),
			new RidFileAction(this,this,ZFileAction.OPEN,"recent1",
					new ZFileFilter( new String("xml"), "XML File")),
			new RidFileAction(this,this,ZFileAction.SAVE,"recent1",
					new ZFileFilter( new String("xml"), "XML File")),
			new RidFileAction(this,this,ZFileAction.SAVEAS,"recent1",
					new ZFileFilter( new String("xml"), "XML File")),

			new RidGobAction(this,RidGobAction.SVG),
			new RidListAction(this,RidListAction.CSV_PANEL),
			new RidListAction(this,RidListAction.CSV_SITE),
			new RidListAction(this,RidListAction.CSV_RESOURCE),
			new RidListAction(this,RidListAction.CSV_DOCUMENT),
			new RidProjectConfigAction(this,RidProjectConfigAction.SET_HTMLDIR),
//			new RidProjectConfigAction(this,RidProjectConfigAction.CHG_HTMLDIR),
//			new RidProjectConfigAction(this,RidProjectConfigAction.CHG_HTMLBASE),
			new RidProjectConfigAction(this,RidProjectConfigAction.CHG_TOPZONEURL),

		// ҏWj[
			new RidClipAction(this,RidClipAction.CUT),

			new RidUndoAction(this,RidUndoAction.UNDO),
			new RidUndoAction(this,RidUndoAction.REDO),

			new RidGobAction(this,RidGobAction.UP),
			new RidGobAction(this,RidGobAction.DOWN),
			new RidGobAction(this,RidGobAction.GRID),
			new RidGobAction(this,RidGobAction.OMISSION_ZONE_ZONE),
			new RidGobAction(this,RidGobAction.OMISSION_MAP_PAGE),

			new RidEnvAction(this,RidEnvAction.SET_ENV),
			new RidEnvAction(this,RidEnvAction.SET_LOG),

		// c[j[
			new RidToolAction(this,RidToolAction.GENERATE),
			new RidToolAction(this,RidToolAction.ANALYZE_HTML),
			new RidToolAction(this,RidToolAction.IMPORT),
			new RidToolAction(this,RidToolAction.EXIST),

			new RidToolAction(this,RidToolAction.SNAPSHOT),
			new RidToolAction(this,RidToolAction.CLEANUP),
			new RidToolAction(this,RidToolAction.ACCESSLOG),
			new RidToolAction(this,RidToolAction.DOWNLOAD),

		// \j[
			new ZUIAction(this,this,ZUIAction.LF_METAL),
			new ZUIAction(this,this,ZUIAction.LF_MOTIF),
			new ZUIAction(this,this,ZUIAction.LF_WINDOWS),

			new RidZoomAction(this,RidZoomAction.ZOOM_025),
			new RidZoomAction(this,RidZoomAction.ZOOM_050),
			new RidZoomAction(this,RidZoomAction.ZOOM_075),
			new RidZoomAction(this,RidZoomAction.ZOOM_100),
			new RidZoomAction(this,RidZoomAction.ZOOM_125),
			new RidZoomAction(this,RidZoomAction.ZOOM_150),
			new RidZoomAction(this,RidZoomAction.ZOOM_200),
			new RidZoomAction(this,RidZoomAction.ZOOM_300),
			new RidZoomAction(this,RidZoomAction.ZOOM_400),

			new ZChildWindowAction(this,RWindowManager.PROPERTY),
			new ZChildWindowAction(this,RWindowManager.PANPANEL),

		// \IvV
			new RidViewAction(this,RidViewAction.LINK_VIRTUAL),
			new RidViewAction(this,RidViewAction.LINK_REAL),
			new RidViewAction(this,RidViewAction.LINK_SELECT),
			new RidViewAction(this,RidViewAction.ZONE_NAM),
			new RidViewAction(this,RidViewAction.ZONE_CMT),
			new RidViewAction(this,RidViewAction.ZONE_FIL),
			new RidViewAction(this,RidViewAction.PAGE_NAM),
			new RidViewAction(this,RidViewAction.PAGE_TTL),
			new RidViewAction(this,RidViewAction.PAGE_CMT),
			new RidViewAction(this,RidViewAction.PAGE_FIL),
			new RidViewAction(this,RidViewAction.URL_NAM),
			new RidViewAction(this,RidViewAction.URL_CMT),
			new RidViewAction(this,RidViewAction.PAGE_ACCESS),

		// wvj[
			new RidHelpAction(this,RidHelpAction.VERSION),
			new RidHelpAction(this,RidHelpAction.HELPDOC),
			new RidHelpAction(this,RidHelpAction.LICENSE),

		// Ō
			new ZExitAction(this)
   		 };

	addActions(defaultActions);

	addActions(DocManager.createAction());
	}

	//## public #######################################################
	/**
	 * t[̏I
	 * ~{^ꂽƂɌĂяoB
	 */
	public void exitFrame() {
	preExit( true );
	exit();
	}

	/**
	 * IO
	 */
	public boolean preExit( boolean bForce ) {
	// hLgXVĂꍇɂ́AZ[u邩₢킹
	if ( mApplication.isModified() && checkLicense(false) ) {
		int result = 0;
		String szMsg = getResource().getString("msg.asksave");
		if ( bForce ) {
			result = JOptionPane.showConfirmDialog(this,
				szMsg,"Ridual",JOptionPane.YES_NO_OPTION);
		} else {
			result = JOptionPane.showConfirmDialog(this,
				szMsg,"Ridual",JOptionPane.YES_NO_CANCEL_OPTION);
		}

		if (result==JOptionPane.YES_OPTION) {
			save();
		} else if ( result == JOptionPane.CANCEL_OPTION ) {
			return false;
		}
	}
	mApplication.exitApplication();

	// qt[\Ă΁ANɂ\悤A
	// \Ԃۑ
	getWindowManager().closeWindow();

	getResource().saveGeometry(this,"main");	// t[̈ʒuۑ
	saveResource();		// \[X̕ۑ
	return true;
	}

	/**
	 * AvP[V̏I
	 */
	public void exit() {
		System.exit(0);
	}

	//## IZFileableC^[tFCX ###################################
	/**
	 * t@CJ
	 * @param szFile Jt@C(null̎VK쐬)
	 */
	public boolean open(String szFile) {
	return mApplication.open(szFile);
	}

	/**
	 * t@C㏑ۑ
	 */
	public boolean save() {
	return mApplication.save();
	}

	/**
	 * t@Ctĕۑ
	 * @param szFile t@C
	 */
	public boolean saveAs(String szFile) {
	return mApplication.saveAs(szFile);
	}

	/**
	 * Z[u\H
	 * uVK쐬v̏ꍇAuݕsv̏ꍇ̂true
	 */
	public boolean canSave() {
	return mApplication.canSave();
	}

	/**
	 * OɊJt@C̐ݒ
	 * @param szRecentMenu j[ږ
	 * @param szRecentFile OɊJt@C
	 */
	public Action createRecentAction(String szRecentMenu,String szRecentFile) {
	if ( szRecentMenu.equals("recent") ) {
		return ( new ZFileAction( this,this,ZFileAction.OPEN,szRecentFile ) );
	}
	return ( null ) ;
	}

	/**
     * ŋߊJt@Cj[̍XV
     *
	 * ͍XVȂAdlg.setCurrentDirectorysăfBNg
	 * ύXɂȂƃj[\ŃG[ł邽߁AŃt@CXV
	 *
     * @param szFile t@Cij[̍XV݂̂̏ꍇnullj
	 */
	public void updateRecent(String szFile) {
	getUIFactory().updateRecent( this, "recent", szFile );
	}

	//## c[o[ ###################################################
	/**
	 * O[vc[o[̍쐬
	 */
	public void createGroupToolBar() {
	mViewtextZoneZone = new ZGroupToggleButton(this,getUIFactory(),
		new String[]{
			RidViewAction.ZONE_NAM,
			RidViewAction.ZONE_CMT,
			RidViewAction.ZONE_FIL
		});
	mViewtextZonePage = new ZGroupToggleButton(this,getUIFactory(),
		new String[]{
			RidViewAction.PAGE_NAM,
			RidViewAction.PAGE_TTL,
			RidViewAction.PAGE_CMT,
			RidViewAction.PAGE_FIL
		});
	mViewtextZoneUrl = new ZGroupToggleButton(this,getUIFactory(),
		new String[]{
			RidViewAction.URL_NAM,
			RidViewAction.URL_CMT
		});

	// 
	resetGroupToolBar();
	}

	/**
	 * O[vc[o[̏ݒ
	 */
	public void resetGroupToolBar() {

	if ( getAction(RidGobAction.GRID) != null ) {

		// Obh
		((RidGobAction)getAction(RidGobAction.GRID)).update();

		// N
		((RidViewAction)getAction(RidViewAction.LINK_VIRTUAL)).update();
		((RidViewAction)getAction(RidViewAction.LINK_REAL)).update();
		((RidViewAction)getAction(RidViewAction.LINK_SELECT)).update();

		// ANZXJEg
		((RidViewAction)getAction(RidViewAction.PAGE_ACCESS)).update();

		// Zone
		String szValue = getResource().getString("viewtext.Zone.ZoneUnit");
		if ( szValue.equals("Name") ) {
			mViewtextZoneZone.setState(RidViewAction.ZONE_NAM);
		} else if ( szValue.equals("Comment") ) {
			mViewtextZoneZone.setState(RidViewAction.ZONE_CMT);
		} else if ( szValue.equals("File") ) {
			mViewtextZoneZone.setState(RidViewAction.ZONE_FIL);
		}

		// Page
		szValue = getResource().getString("viewtext.Zone.PageUnit");
		if ( szValue.equals("Name") ) {
			mViewtextZonePage.setState(RidViewAction.PAGE_NAM);
		} else if ( szValue.equals("Title") ) {
			mViewtextZonePage.setState(RidViewAction.PAGE_TTL);
		} else if ( szValue.equals("Comment") ) {
			mViewtextZonePage.setState(RidViewAction.PAGE_CMT);
		} else if ( szValue.equals("File") ) {
			mViewtextZonePage.setState(RidViewAction.PAGE_FIL);
		}

		// Url
		szValue = getResource().getString("viewtext.Zone.UrlUnit");
		if ( szValue.equals("Name") ) {
			mViewtextZoneUrl.setState(RidViewAction.URL_NAM);
		} else if ( szValue.equals("Comment") ) {
			mViewtextZoneUrl.setState(RidViewAction.URL_CMT);
		}
	}
	}

	//## o[WAbv #############################################
	/**
	 * ݒ
	 */
	private void initialSetting() {
	ZResource res = getResource();
	String szOs = ( System.getProperty("os.arch").equals("ppc") )? ".mac" : ".win";
	
	// RID-X dir
	// ݒ葤Ŏݒ
//	if ( mRidXDir == null ) {
//		res.putString("app.install.path",res.getString("app.install.path"+szOs));
//	}

	// ignore key
	res.putString("rid.ignore.prefix",res.getString("rid.ignore.prefix.default"));
	
	// browser
	String szTmp = res.getString("generate.browser_command.1"+szOs);
	res.putString("generate.browser_command",szTmp);
	res.putString("generate.browser_command.1",szTmp);
	res.putString("generate.browser_command.2",res.getString("generate.browser_command.2"+szOs));

	// html editor
	szTmp = res.getString("command.html.editor.1"+szOs);
	res.putString("command.html.editor",szTmp);
	res.putString("command.html.editor.1",szTmp);
	res.putString("command.html.editor.2",res.getString("command.html.editor.2"+szOs));

	// text editor
	res.putString("command.text.editor",res.getString("command.text.editor"+szOs));

	// explorer
	res.putString("command.explorer",res.getString("command.explorer"+szOs));

	// documenter
	for ( int nAt=1 ; nAt < 100 ; nAt++ ) {
		String szApp = res.getString("command.doc.app."+nAt+".default");
		if ( szApp != null ) {
			res.putString("command.doc.app."+nAt,szApp);
			res.putString("command.doc.ext."+nAt,res.getString("command.doc.ext."+nAt+".default"));
			res.putString("command.doc.view."+nAt,res.getString("command.doc.view."+nAt+".default"));
			res.putString("command.doc.cmd."+nAt,res.getString("command.doc.cmd."+nAt+szOs));
		} else {
			break;
		}
	}

	}

	/**
	 * RID-XfBNg`FbN
	 * <ul>
	 * <li>Template Diȓ݃`FbN
	 * <li>Project Diȓ݃`FbN
	 * <li>Config Diȓ݃`FbN
	 * </ul>
	 */
	private boolean checkRidxDir() {
	ZResource res = getResource();
	String szRidxDir = res.getString("app.install.path");

	// Template Diȓ݃`FbN
	String szDir = szRidxDir + File.separator + res.getString("app.template.dir");
	File fDir = new File(szDir);
	if ( !fDir.exists() || !fDir.isDirectory() ) {
		ZDebug.err( "template dir bad:"+fDir.exists()+","+fDir.isDirectory());
		return false;
	}

	// Project Diȓ݃`FbN
	szDir = szRidxDir + File.separator + res.getString("app.project.dir");
	fDir = new File(szDir);
	if ( !fDir.exists() || !fDir.isDirectory() ) {
		ZDebug.err( "project dir bad:"+fDir.exists()+","+fDir.isDirectory());
		return false;
	}

	// Config Diȓ݃`FbN
	szDir = szRidxDir + File.separator + res.getString("app.config.dir");
	fDir = new File(szDir);
	if ( !fDir.exists() || !fDir.isDirectory() ) {
		ZDebug.err( "config dir bad:"+fDir.exists()+","+fDir.isDirectory());
		return false;
	}

	return true;
	}

	/**
	 * CZX̃`FbN
	 */
	public boolean checkLicense(boolean viewMsg) {
	int pages = RidMIT.checkMIT();
	if(-2 == pages)	pages = RidMIT.TCOUNT;
//	boolean bEnable = RidMIT.checkMIT();
//	if ( !bEnable ) {
	switch ( pages ) {
	case 0:		return true;	// 
	case -1:					// CZXȂ
	case -3:					// NO(肦Ȃꉞ)
		return false;
	default:
		RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get( Rid.DOCUMENT_SITE );
		RidElementZone top  = doc.getTopZone();
		Vector vec = top.getPages(true);
		if ( vec.size() <= pages )	return true;
		
		if ( viewMsg ) {
			// G[bZ[W\
			RidMessage ridMsg = new RidMessage();
			MessageDialog.showError(ridMsg.Error("E1010",""));
		}
		
		return false;
	}
//	return bEnable;
	}
	
	
	public static final String getHtmlDir(){
		try {
	   		DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
			String htmldir	= doc.getDocumentElement().getAttribute("HtmlDir");
			if(0 < htmldir.length())	return htmldir;
		} catch(NullPointerException e){}
		
		return ZInstance.prop().getProperty(Rid.PJ_DIR) + File.separator +
					ZApp.getTheApp().getResource().getString("rid.html.dir");
	}
	
	public static final String getHtmlDir2(){
		try {
	   		DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
			String htmldir	= doc.getDocumentElement().getAttribute("HtmlDir");
			if(0 < htmldir.length())	return htmldir;
		} catch(NullPointerException e){}
		
		return null;
	}
	
	public static final void setHtmlDir(String htmldir){
		setHtmlDir(htmldir, (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE));
		setHtmlDir(htmldir, (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE));
	}
	
	private static final void setHtmlDir(String htmldir, DocDocument doc){
		doc.beginTransaction();
		try {
			if(null == htmldir) doc.getDocumentElement().removeAttribute("HtmlDir");
			else doc.getDocumentElement().setAttribute("HtmlDir", htmldir.replace(File.separatorChar, '/') );
			doc.commit();
		} catch(NullPointerException e){ doc.rollback(); }
	}
	
	public static final String getHtmlDirPIP(){
		try {
	   		DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
			String htmldir	= doc.getDocumentElement().getAttribute("HtmlDirPIP");
			if(0 < htmldir.length())	return htmldir;
		} catch(NullPointerException e){}
		
		return null;
	}
	
	public static final void setHtmlDirPIP(String htmldir){
		String[] docs = new String[]{ Rid.DOCUMENT_SITE, Rid.DOCUMENT_RESOURCE };
		
		for(int i = docs.length - 1; 0 <= i; i--){
	   		DocDocument doc = (DocDocument)ZInstance.map().get(docs[i]);
			doc.beginTransaction();
			try {
				if(null == htmldir)	doc.getDocumentElement().removeAttribute("HtmlDirPIP");
				else doc.getDocumentElement().setAttribute("HtmlDirPIP", htmldir.replace(File.separatorChar, '/') );
				doc.commit();
			} catch(NullPointerException e){ doc.rollback(); }
		}
	}
	
	public static final String getTopZoneURL(){
		try {
	   		DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
			String url	= doc.getDocumentElement().getAttribute("TopZoneURL");
			if(0 < url.length())	return url.endsWith("/") ? url : (url + "/");
		} catch(NullPointerException e){}
		
		return null;
	}
	
	public static final void setTopZoneURL(String url){
   		DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
		doc.beginTransaction();
		try {
			if(null == url)	doc.getDocumentElement().removeAttribute("TopZoneURL");
			else doc.getDocumentElement().setAttribute("TopZoneURL", url);
			doc.commit();
		} catch(NullPointerException e){ doc.rollback(); }
	}

	//## Agr[g ###############################################
    /**
     * AvP[VNX
     */
	protected IApplication	mApplication		= null;

	/**
	 * SplashWindow
	 */
	protected static ZSplashWindow mSplashWindow = null;

    /**
     * Zone\ic[o[̃O[vIuWFNgj
     */
	protected ZGroupToggleButton mViewtextZoneZone = null;

    /**
     * Page\ic[o[̃O[vIuWFNgj
     */
	protected ZGroupToggleButton mViewtextZonePage = null;

    /**
     * Url\ic[o[̃O[vIuWFNgj
     */
	protected ZGroupToggleButton mViewtextZoneUrl = null;

    /**
     * NIvVFRID-X fBNg
     */
	static protected String  mRidXDir		= null;

    /**
     * NIvVFC|[gy[W
     */
	static protected boolean mImpPage		= false;

    /**
     * NIvVFC|[g\[X
     */
	static protected boolean mImpResource	= false;

    /**
     * NIvVFC|[ghLg
     */
	static protected boolean mImpDocument	= false;

    /**
     * NIvVFAiCY
     */
	static protected boolean mAnalyze		= false;

    /**
     * NIvVFw
     */
	static protected boolean mProduct		= false;

    /**
     * NIvVFŋ
     */
	static protected boolean mPresent		= false;

    /**
     * NIvVFTCg}bv
     */
	static protected boolean mSitemap		= false;

    /**
     * NIvVFNXNvg
     */
	static protected String  mScript		= null;
}
