/*
 * @(#)RidFileAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid file action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/21
 */
package jp.co.nri.rid.action;

import java.awt.Frame;
import java.awt.Point;

import java.io.File;
import java.io.IOException;

import javax.swing.Action;
import javax.swing.JFileChooser;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZFileFilter;

import jp.co.iti.fagot.action.ZFileAction;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.IZFileable;

import jp.co.nri.rid.RUpdateManager;
/**
 * fBNgwopen\ɂ邽߂̃NX
 *
 * uJvANVɃfBNgI\Ƃ
 * uVK쐬vRidApplication.openɂāAp[^null̏ꍇɑΉ
 */
public class RidFileAction extends ZFileAction {
	/**
	 * ftHgRXgN^(new)
	 * @param app      AvP[VNX
	 * @param cmp      R|[lg
	 * @param szAction ANV
	 */
	public RidFileAction(IZApp app,IZFileable cmp,String szAction) {
    super(app,cmp,szAction);
	}

	/**
	 * \[X璼OɊJt@C擾ꍇ̃L[{
	 * t@CtB^ݒp̃RXgN^(open)
	 * @param app      AvP[VNX
	 * @param cmp      R|[lg
	 * @param szAction ANV
	 * @param szRecent \[XL[
	 * @param filter   t@CtB^
	 */
	public RidFileAction(IZApp app,IZFileable cmp,String szAction,
		String szRecent,ZFileFilter filter) {
    super(app,cmp,szAction,szRecent,filter);
	}

	//## I[oCh #################################################
	/**
	 * J
	 */
	protected void open() {
		openImpl();
	}

	/**
	 * J
	 */
	public boolean openImpl() {
    Frame   frame = getApp().getFrame();

    if (mDialog == null) {
		ZResource res = getApp().getResource();

		mDialog = new JFileChooser();
		// t@CtB^̐ݒ
		if ( mFileFilter != null ) {
			mDialog.setFileFilter(mFileFilter);
		}

		// fBNg̐ݒ
/*		if ( mRecent != null ) {
			String szFile = res.getString(mRecent);
			if ( szFile != null ) {
				mDialog.setCurrentDirectory(
					new File(ZFile.getParent(szFile) ) );
			}
		}
*/
		String szFile = res.getString("app.install.path")+File.separator
			   +res.getString("app.project.dir") ;
		mDialog.setCurrentDirectory(new File(szFile));
	}

	if ( frame.isShowing()) {
		// ʒuC
	    Point p = frame.getLocationOnScreen();
		mDialog.setLocation(p.x + 10, p.y +10);
	}

	// fBNgI\ɂ
	mDialog.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);

	// _CAOJ
	boolean bRet = false;
	int nRet = mDialog.showOpenDialog(frame);
	if ( nRet == JFileChooser.APPROVE_OPTION) {
		// t@CJ
		File fFile = mDialog.getSelectedFile();
		String szFile = null ;
		try {
			szFile = fFile.getCanonicalPath();
	    } catch ( java.io.IOException e) {
			szFile = fFile.getAbsolutePath();
		}
		bRet = mCmp.open( szFile );
	} else {
		RUpdateManager.update(RUpdateManager.SET_DOCUMENT);
	}
	return bRet;
	}

	//## Agr[g ###############################################
    /**
     * _CAO{bNX
     */
    protected JFileChooser mDialog = null;
}
