/*
 * @(#)RidZoomAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid zoom action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import javax.swing.JComponent;
import javax.swing.JViewport;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElement;
/**
 * Rid ZoomnANV`
 */
public class RidZoomAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidZoomAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {

	// Y[XP[擾
	if ( getActionName().startsWith( "zoom_" ) ) {
		String szZoom = getActionName().substring(5);
		int nZoom = ZString.parseInt(szZoom,0);
		if ( nZoom >= 25 && nZoom <= 400 ) {
			onZoom( ((double)nZoom)/100 );
		}
	}
	}

	/**
	 * \{̐ݒ
	 * @param scale \{
	 */
	protected void onZoom( double scale ) {
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͂Ƃ肠삵Ȃ
		return;
	}
	DocPane editor = (DocPane)active;
	editor.getDocument().beginTransaction();

	// Wꎞۑ
	ZPoint pt  = editor.getCenter();

	// \{̐ݒ
	DocElement root = (DocElement)editor.getDocument().getRootElement(editor.getPanelId());
	root.setDisplayScale(editor.getPanelId(),scale);

	// r[|[g̍ăCAEg
	JViewport port = (JViewport)editor.getParent();
	port.doLayout();

	// WĐݒ
	editor.setCenter(pt);

	// ĕ`
	editor.updateGobs();
	editor.repaint();
	}

	/**
	 * UIXV
	 */
	public void update() {
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͂Ƃ肠삵Ȃ
		firePropertyChange(ZAction.ENABLED,null,new Boolean(false));
		firePropertyChange(ZAction.CHECKED,null,new Boolean(false));
		return;
	}
	DocPane editor = (DocPane)active;

	// \{̎擾
	DocElement root = (DocElement)editor.getDocument().getRootElement(editor.getPanelId());
	double scale = root.getDisplayScale(editor.getPanelId());

	// Y[XP[擾
	if ( getActionName().startsWith( "zoom_" ) ) {
		String szZoom = getActionName().substring(5);
		int nZoom = ZString.parseInt(szZoom,0);
		firePropertyChange(ZAction.ENABLED,null,new Boolean(true));
		if ( ((double)nZoom/100) == scale ) {
			firePropertyChange(ZAction.CHECKED,null,new Boolean(true));
		} else {
			firePropertyChange(ZAction.CHECKED,null,new Boolean(false));
		}
	}
	}

	//## Agr[g ###############################################
    /**
     * ANVi\{̕ύXjF25%
     */
	final static public String ZOOM_025			= "zoom_025" ;

    /**
     * ANVi\{̕ύXjF50%
     */
	final static public String ZOOM_050			= "zoom_050" ;

    /**
     * ANVi\{̕ύXjF75%
     */
	final static public String ZOOM_075			= "zoom_075" ;

    /**
     * ANVi\{̕ύXjF100%
     */
	final static public String ZOOM_100			= "zoom_100" ;

    /**
     * ANVi\{̕ύXjF125%
     */
	final static public String ZOOM_125			= "zoom_125" ;

    /**
     * ANVi\{̕ύXjF150%
     */
	final static public String ZOOM_150			= "zoom_150" ;

    /**
     * ANVi\{̕ύXjF200%
     */
	final static public String ZOOM_200			= "zoom_200" ;

    /**
     * ANVi\{̕ύXjF300%
     */
	final static public String ZOOM_300			= "zoom_300" ;

    /**
     * ANVi\{̕ύXjF400%
     */
	final static public String ZOOM_400			= "zoom_400" ;
}
