/**
 * @(#)BaseURL.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * Base URL
 * @author  Intelligent Technology Inc.
 * @version 1.00 2003/07/03
 */
package	jp.co.nri.rid.analyzer;

import	java.net.*;
import	java.io.*;

/**
 */

public class BaseURL{
	private static final String[] IGNORE_HEADER_STRINGS = { " ", "news:", "mail:", "telto:", "tel:", "mailto:", "javascript:" };
	private static final char[]	IGNORE_HEADER_CHARS = { '?', '<', '#' };
	private static final char[]	SEPARATORCHARS = { '#' ,'?'};
	
	private String	protocol	= null;
	private String	host		= null;
	private String	path		= null;
	private int		port		= -1;
	private int		pathlen		= 0;
	
	public BaseURL(String str) throws MalformedURLException {
		URL base = new URL(str);
		
		protocol= base.getProtocol();
		host	= base.getHost();
		path	= base.getPath();
		port	= base.getPort();
		pathlen	= path.length();
	}
	
	/**
	 * pXւ̕ϊ.
	 * pXɕϊłȂ(TCgO -> UrlUnit)ꍇnullԂ.
	 * 
	 * @param	parentStr	
	 * @param	childStr	
	 * 
	 * @return	nullȂTCgO(UrlUnit)
	 */
	
	public String getInnerPath(String parentStr, String childStr){
//System.out.println("basePath: "+path);
//System.out.println("parent: "+parentStr);
//System.out.println("child: "+childStr);
		try{
			int headChar = childStr.charAt(0);
			
			for(int i = IGNORE_HEADER_CHARS.length - 1; 0 <= i; i--){
				if(IGNORE_HEADER_CHARS[i] == headChar)	return null;
			}
			
			String lowerurl = childStr.toLowerCase();
			for(int i = IGNORE_HEADER_STRINGS.length - 1; 0 <= i; i--){
				if(lowerurl.startsWith(IGNORE_HEADER_STRINGS[i]))	return null;
			}
			
		}
		catch(NullPointerException e){}
		catch(IndexOutOfBoundsException e){}
		
		int qpos = childStr.indexOf('?');
		int spos = childStr.indexOf('#');
		
		if(0 > qpos){
			if(0 <= spos)	childStr = childStr.substring(0, spos);
		}else{
			if(0 <= spos){
				childStr = childStr.substring(0, (qpos < spos) ? qpos : spos);
			} else childStr = childStr.substring(0, qpos);
		}
		
		try{
			URL child = new URL(childStr);
			
			String cProtocol = child.getProtocol();
			
			if(0 < cProtocol.length()){	// tURL?
				if(!cProtocol.equalsIgnoreCase(protocol))	return null;
				if(!child.getHost().equalsIgnoreCase(host))	return null;
				if(child.getPort() != port)					return null;
				String cPath = child.getPath();
				if(0 >= cPath.length()) cPath = "/";
				if(!cPath.startsWith(path))					return null;
				
				String ret = cPath.substring(pathlen);
				
				return (ret.startsWith("/")) ? ret : ("/" + ret);
			}
		} catch(MalformedURLException e){}
		// ΃pX
		childStr = childStr.replace(File.separatorChar, '/');
		File cFile = (childStr.startsWith("/")) ? new File(childStr) :
				new File(new File(path, parentStr).getParentFile(), childStr);
		String cPath = cFile.getPath();
		if('/' != File.separatorChar)	cPath = cPath.replace(File.separatorChar, '/');
		try { cPath = new URI(cPath).normalize().toString(); }
		catch(URISyntaxException use){
			try{
				return new URL(protocol, host, port, cPath).toExternalForm();
			} catch(MalformedURLException mue){ return null; }
		}
		
//System.out.println("cPath: "+cPath);
		try{
			if(!cPath.startsWith(path))		return new URL(protocol, host, port, cPath).toExternalForm();
		} catch(MalformedURLException mue){ return null; }
		
		String ret = cPath.substring(pathlen);
		
		return (ret.startsWith("/")) ? ret : ("/" + ret);
	}
	
	public String getOuterPath(String inner){
		String pathstr = new File(path, inner).getPath();
		return ('/' != File.separatorChar) ? pathstr.replace(File.separatorChar, '/') : pathstr;
	}
}
