/**
 * @(#)BaseURL.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * Base URL
 * @author  Intelligent Technology Inc.
 * @version 1.00 2003/07/03
 */
package	jp.co.nri.rid.analyzer;

import	java.util.*;

// W3C DOM
import	org.w3c.dom.*;

/**
 */

public class LinkList{
	private static final String	LINK		= "Link";
	private static final String	LINKUNIT	= "LinkUnit";
	private static final String	CONNECT0	= "Connect0";
	private static final String	CONNECT1	= "Connect1";
	private static final String	KEY			= "Key";
	
	private Hashtable	list = null;
	private String		from = null;
	private NodeList	linkNodeList;
	private Document	document;
	private Element		linkTag;
	
	public LinkList(Element root){
		document	= root.getOwnerDocument();
		linkTag		= getLinkTag(root);
		linkNodeList= linkTag.getElementsByTagName(LINKUNIT);
	}
	
	/**
	 * N悪tõNjbgԂ.
	 * 
	 * @param	to	N
	 * 
	 * @return	Njbg
	 */
	
	public Element get(String to){
		if(null == list)	buildList();
		return (Element)list.get(to.toLowerCase());
		
	}
	
	/**
	 * ÑXgZbg.
	 * <br>
	 * ̃\bhł̓Njbg̎W͂ȂȂ.<br>
	 * NjbgresetŏgetŎW.
	 * 
	 * @param	from	N
	 * 
	 */
	public void reset(String from){
		this.from	= from;
		list		= null;
	}
	
	/**
	 * Njbgǉ.
	 * <br>
	 * Njbg쐬hLgANXgoɒǉ.<br>
	 * NresetŐݒ肳ꂽ̂g.<br>
	 * 
	 * @param	to	N
	 * 
	 */
	public Element appendUnit(String to){
		Element connect0	= document.createElement(CONNECT0);
		connect0.setAttribute(KEY	,from);
		
		Element connect1	= document.createElement(CONNECT1);
		connect1.setAttribute(KEY	,to);
		
		Element linkunit	= document.createElement(LINKUNIT);
		linkunit.appendChild(connect0);
		linkunit.appendChild(connect1);
		
		linkTag.appendChild(linkunit);
		
		list.put(to.toLowerCase(), linkunit);
		
		return linkunit;
	}
	
	private String getChildAttribute(Element element, String tag, String attr){
		NodeList nl = element.getElementsByTagName(tag);
		
		if(0 >= nl.getLength())	return null;
		Element child = (Element)nl.item(0);
		return child.getAttribute(attr);
	}
	
	private Element getLinkTag(Element root){
		NodeList	nl	= root.getChildNodes();
		
		Element		linktag	= null;
		Node		n;
		for(int i = nl.getLength() - 1; 0 <= i; i--){
			 n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			
			if( LINK.equals(n.getNodeName()) ){
				linktag = (Element)n;
				break;
			}
		}
		
		if(null==linktag){
			linktag	= document.createElement(LINK);
			root.appendChild(linktag);
		}
		
		return linktag;
	}
	
	private void buildList(){
		list = new Hashtable();
		
		for(int i = linkNodeList.getLength() - 1; 0 <= i;i--){
			Element linkunit = (Element)linkNodeList.item(i);
			String connect0 = getChildAttribute(linkunit, CONNECT0, KEY);
			try{
				if( !from.equalsIgnoreCase(connect0) )	continue;
				String connect1 = getChildAttribute(linkunit, CONNECT1, KEY);
				list.put(connect1.toLowerCase(), linkunit);
			}catch(NullPointerException e){}
		}
	}
}
