/**
 * @(#)MapXmlAnalizer.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : xxxx_map.xml Analizer
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/04/25
 * @see 
 */
package	jp.co.nri.rid.analyzer;

/* JAVA */
import	java.util.*;

/* W3C */
import	org.w3c.dom.Document;

/* rid */
import	jp.co.nri.rid.xml.*;

/**
 * xxxx_map.xml͂NX
 */

class MapXmlAnalizer{
	private static final String MAPATTRDATA	= "MapAttrData";
	private static final String INTAG		= "inTag";
	private documentBooster	myDocument;
	
	/**
	 * @param	document	Site.xmlDocumentIuWFNg
	 * @since	1.00
	 */
	public MapXmlAnalizer(Document document){
		myDocument = new documentBooster(document);
	}
	
	/**
	 * @param	document	Site.xmldocumentBoosterIuWFNg
	 * @since	1.00
	 */
	public MapXmlAnalizer(documentBooster document){
		myDocument = document;
	}
	
	public String[] getInTag(){
		elementBooster[] elements = myDocument.root().offspring(MAPATTRDATA);
		if(null==elements)	return null;
		
		int i=elements.length;
		String[] intags = new String[i];
		for(i--;0<=i;i--)	intags[i] = elements[i].attribute(INTAG);
		
		return intags;
	}
}
