/**
 * @(#)SWFMappingScript.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : SWF Mapping Script
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/04/09
 * @see 
 */
package	jp.co.nri.rid.analyzer;

import	java.util.HashMap;

import	jp.co.nri.*;
import	jp.co.iti.fagot.*;
import	jp.co.iti.fagot.util.*;
import	jp.co.nri.rid.xml.*;
import	jp.co.nri.rid.importer.*;
import	java.net.*;
import	java.io.*;
import	jp.co.nri.rid.error.*;
import	jp.co.iti.swf.*;

/**
 * SWFt@Cn̑lSWFt@CoASWFt@C͂
 */

public class SWFMappingScript implements iMappingScript ,iExceptionCode{
	private static final String[]	names = { "object.movie" ,"embed.src" };
	private static final String KEY_HTML	= "rid.html.dir";
	private static final String	PAGEUNIT	= "PageUnit";
	private static final String	LINK		= "Link";
	private static final String	LINKUNIT	= "LinkUnit";
	private static final String	DIRECTION	= "Direction";
	private static final String	CONNECT0	= "Connect0";
	private static final String	CONNECT1	= "Connect1";
	private static final String	ZONEUNIT	= "ZoneUnit";
	private static final String	URLUNIT		= "UrlUnit";
//	private static final String	FILE		= "File";
	private static final String	NAME		= "Name";
	private static final String	KEY			= "Key";
	private static final String	EXIST		= "Exist";
	private static final String	TOP			= "Top";
	private static final String	PAGETYPE	= "PageType";
	private static final String	ZEROTOONE	= "";
	private static final String	ONETOZERO	= "";
	private static final String	BOTH		= "both";
	private static final String	TRUE		= "true";
	private static final String	FALSE		= "false";
	private static final String	SERVER		= "server";
	private static final String	INTENSITY	= "Intensity";
	private static final String	REAL		= "Real";
	
	private	elementBooster			myElement;
	private	elementBooster			resRoot;
	private	String					myHtmldir;
	private	HashMap					swfMap;
	private	HyperLinkMappingScript	hlms;
	private	ResourceMappingScript	resms;
	private BaseURL					baseURL;
	
//--------[[ constructor ]]----------------------------------------------------
	/**
	 * @param	root	MappingXML̃[gElement
	 * @see		elementBooster
	 */
	public SWFMappingScript(elementBooster root, BaseURL baseURL, HyperLinkMappingScript hlms, ResourceMappingScript resms, HashMap swfMap) throws RidException {
		myElement	= root;
		this.hlms	= hlms;
		this.resms	= resms;
		this.swfMap	= swfMap;
		this.baseURL= baseURL;
		
		try{
//			myHtmldir	= ZInstance.prop().getProperty(Rid.PJ_DIR)+File.separator+ZApp.getTheApp().getResource().getString(KEY_HTML);
			myHtmldir	= Ridual.getHtmlDir();
		}catch(NullPointerException	e){
			 throw new RidException(new RidMessage().Error(ERR_NotFoundResourceKey,KEY_HTML));
		}
	}
	
//--------[[ open method ]]----------------------------------------------------
	/**
	 * ScriptcatchattributeB
	 * @return	attributez
	 * @since	1.00
	 */
	public String[] names(){ return names; }
	
	/**
	 * names\bhattributehitƂɋNB
	 * @param	file	HTMLt@C
	 * @param	name	attribute
	 * @param	text	attributel
	 */
	public void hit(String file ,String name ,elementBooster element)
		throws RidException ,RWarningException
	{
		String text = element.text();
		if(null==text)	return;
		
		// tpXURL -> ΃pX
		if(null != baseURL){
			String innerPath = baseURL.getInnerPath(file, text);
			if(null != innerPath) text = innerPath;
		}
		
		if(!(text.toLowerCase().endsWith(".swf")))	return;
		
		String swfname	= fusion(file ,text);
		
		String[] urls = getURLs(myHtmldir + File.separator + swfname);
		if(null==urls)	return;
		
//		HyperLinkMappingScript	hyperlinkms	= new HyperLinkMappingScript(myElement);
//		SWFMappingScript		swfms		= new SWFMappingScript(myElement, resms, swfMap);
		
		int mx = urls.length;
		for(int i=0;i<mx;i++){
			String urlstr = urls[i];
			if(FileNameStudio.skip(urlstr))		continue;	// skip ?
			if(RIgnoreFiles.ignorefile(urlstr))	continue;	// Ot@C ?
			
			elementBooster swfelement = element.newElement("swf");
			if(FileNameStudio.isURL(urlstr))	swfelement.text(urlstr);	// Full URL
			else{
				String url;
				if(urlstr.startsWith("/"))	url = urlstr;
				else{
					try{
						String fusion = FileNameStudio.fusion(file ,urlstr);
						if(null==fusion)	continue;
						url = "/"+ fusion;
					}
					catch(java.lang.ArrayIndexOutOfBoundsException e){
						continue;
					}
				}
				
				if(null != baseURL){
					String outerPath = baseURL.getOuterPath(url);
					if(null != outerPath) url = outerPath;
				}
				
				if(FileNameStudio.isResource(url))	resms.hitForFlash(file ,url ,"flash");
				swfelement.text(url);
				if(url.toLowerCase().endsWith(".swf")){
//					swfms.hit(file ,"swf" ,swfelement);
					hit(file ,"flash" ,swfelement);
					continue;
				}
			}
//			hyperlinkms.hit(file ,"swf"		,swfelement);
			hlms.hit(file ,"flash" ,swfelement);
		}
		// SWFt@CȂċA
		// eHTMLSWFt@CقȂfBNgɑ݂SWF̑΃pXłꍇAHTML̑΃pXɕϊKv
		// HTML̑΃pXŃNjbg or HyperLinkMappingScriptŏ
	}
	
//--------[[ close method ]]----------------------------------------------------
	private String fusion(String file ,String text) throws RidException{
		if(FileNameStudio.skip(text))		return null;	// skip ?
		if(FileNameStudio.isURL(text))		return null;	// Full URL ?
		if(RIgnoreFiles.ignorefile(text))	return null;	// Ot@C ?
		
		// URL
		String fusionurl = null;
		if(text.equals("/"))			fusionurl = null;				// "/"̂
		else if(text.startsWith("/")){
			try{ fusionurl = FileNameStudio.fusion("/" ,text); }
			catch(java.lang.ArrayIndexOutOfBoundsException e){ return null; }
		}
		else{
			try{ fusionurl = FileNameStudio.fusion(file ,text); }
			catch(java.lang.ArrayIndexOutOfBoundsException e){ return null; }
		}
		
		return fusionurl;
	}
	
	private	String[] getURLs(String name) throws RidException{
		File file = new File(name);
		
		if(!swfMap.containsKey(file)){
			SWFDocument swfdoc;
			try{ swfdoc	= new SWFDocument(name); }	// SWFhLgJ
			catch(Exception e){
				ZDebug.trace("SWFI[vG[:"+name);
				e.printStackTrace();
				return null;
			}
			
			String[] urls = swfdoc.getURLs();					// SWFhLgURL擾
			swfMap.put(file, urls);
			
			return urls;
		} else return (String[])swfMap.get(file);
	}
}
