/*
 * @(#)MapMinorTree.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Map Calc Minor Tree
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/10/29
 */
package jp.co.nri.rid.doc;

import java.util.Vector;
import java.util.Enumeration;

import jp.co.iti.fagot.util.ZDebug;
/**
 * Map Viewɂqm[hԂ̋ZNX
 */
public class MapMinorTree {

	/**
	 * RXgN^
	 */
    public MapMinorTree() {
	mVector = new Vector();
    }

	/**
	 * Kw̒ǉ
	 */
	public void add( double dMinor ) {
	mVector.add( 0, new MinMax( dMinor ) );
	}

	/**
	 * Kw̃}[W
	 * @param src }[WΏۂMapTree
	 */
	public void marge( MapMinorTree src ) {
	Vector marge = new Vector();
	Enumeration myElm  = mVector.elements();
	Enumeration srcElm = src.getVector().elements();
	while ( myElm.hasMoreElements() ) {
		MinMax myData = (MinMax)myElm.nextElement();
		if ( srcElm.hasMoreElements() ) {
			MinMax srcData = (MinMax)srcElm.nextElement();
			MinMax newData = new MinMax( Math.min( srcData.getMin(),myData.getMin() ),
										 Math.max( srcData.getMax(),myData.getMax() ) );
			marge.add(newData);
		} else {
			marge.add(myData);
		}
	}
	while ( srcElm.hasMoreElements() ) {
		MinMax srcData = (MinMax)srcElm.nextElement();
		marge.add(srcData);
	}
	mVector = marge;
	
	// ŏICfg̈p
	setLastIndent( src.getLastIndent() ) ;
	}

	/**
	 * KwԂ̋̌vZ
	 * @param src vZΏۂMapTree
	 * src̕ɂ邱ƂOƂ
	 * @return 
	 */
	public double distance( MapMinorTree src ) {
//	ZDebug.trace();
//	ZDebug.trace("   mytree:"+toString());
//	ZDebug.trace("  srctree:"+src.toString());
	Enumeration myElm  = mVector.elements();
	Enumeration srcElm = src.getVector().elements();

	MinMax myData = (MinMax)myElm.nextElement();
	MinMax srcData = (MinMax)srcElm.nextElement();

//	double dist = Math.min( Math.abs(myData.getMin()-srcData.getMax()),
//							Math.abs(myData.getMax()-srcData.getMin()) );
	double dist = srcData.getMin()-myData.getMax();

	while ( myElm.hasMoreElements() ) {
		myData = (MinMax)myElm.nextElement();
		if ( srcElm.hasMoreElements() ) {
			srcData = (MinMax)srcElm.nextElement();
//			double dist2 = Math.min( Math.abs(myData.getMin()-srcData.getMax()),
//									 Math.abs(myData.getMax()-srcData.getMin()) );
			double dist2 = srcData.getMin()-myData.getMax();
			if ( dist2 < dist ) {
				dist = dist2;
			}
		} else {
			break;
		}
	}
//	ZDebug.trace(" distance:"+dist);
	return dist;
	}

	/**
	 * ڂ̎q̔̒l
	 */
	public double getChildHarf() {
	Enumeration elm = mVector.elements();
	MinMax data = (MinMax)elm.nextElement();
	return (data.getMax()+data.getMin())/2;
	}

	/**
	 * őMinorԍ̎擾
	 * @return őMinorԍ
	 */
	public double getMaxMinor() {
	Enumeration elm = mVector.elements();
	MinMax data = (MinMax)elm.nextElement();
	double dMax = data.getMax();
	while ( elm.hasMoreElements() ) {
		data = (MinMax)elm.nextElement();
		if ( dMax < data.getMax() ) {
			dMax = data.getMax();
		}
	}
	return dMax;
	}

	/**
	 * ŏMinorԍ̎擾
	 * @return ŏMinorԍ
	 */
	public double getMinMinor() {
	Enumeration elm = mVector.elements();
	MinMax data = (MinMax)elm.nextElement();
	double dMin = data.getMin();
	while ( elm.hasMoreElements() ) {
		data = (MinMax)elm.nextElement();
		if ( dMin < data.getMin() ) {
			dMin = data.getMin();
		}
	}
	return dMin;
	}

	//## l ###########################################################
	/**
	 * KwVector̎擾
	 */
	public Vector getVector() {
	return mVector;
	}

	/**
	 * Kw̐[̎擾
	 */
	public int getDepth() {
	return mVector.size();
	}

	/**
	 * ŏICfg̎擾
	 */
	public boolean getLastIndent() {
	return mLastIndent;
	}

	/**
	 * ŏICfg̐ݒ
	 */
	public void setLastIndent(boolean bIndent) {
	mLastIndent = bIndent ;
	}

	/**
	 * 
	 */
	public String toString() {
	String szRet = "MapTree";
	Enumeration elm = mVector.elements();
	while( elm.hasMoreElements() ) {
		MinMax data = ( MinMax ) elm.nextElement();
		szRet += ":" + data.getMin() + "," + data.getMax();
	}
	return szRet;
	}

	//## Agr[g ###############################################
	/**
	 * Kwf[^
	 */
	protected Vector mVector = null;

	/**
	 * ŏIGg̃Cfg
	 */
	protected boolean mLastIndent = false;

	//## TuNXFŏől #######################################
	/**
	 * eKw̍ŏAőMinorԍێNX
	 */
	public class MinMax {
	/**
	 * RXgN^Fݒp
	 * @param dValue ŏl=ől
	 */
    public MinMax(double dValue) {
	mMin = dValue;
	mMax = dValue;
    }

	/**
	 * RXgN^
	 * @param dMin ŏl
	 * @param dMax ől
	 */
    public MinMax(double dMax, double dMin) {
	mMin = dMax;
	mMax = dMin;
    }

	/**
	 * ől̎擾
	 */
    public double getMax() {
	return mMax;
    }

	/**
	 * ŏl̎擾
	 */
    public double getMin() {
	return mMin;
    }

	//## Agr[g ###############################################
	/**
	 * ŏl
	 */
	protected double mMin = 0;

	/**
	 * ől
	 */
	protected double mMax = 0;
	}

}
