/*
 * @(#)RidAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JRadioButton;

import jp.co.iti.fagot.doc.DefaultAction;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocBar;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidDocumentSite;
/**
 * Rid Action
 */
public class RidAction extends DefaultAction {

	/**
	 * ftHgRXgN^
	 */
	protected RidAction() {
	}

	//## ^[Qbg擾 ###############################################
	/**
	 * ^[Qbg̎擾
	 */
	protected Vector getTargets() {
	return (Vector)ZInstance.map().get("doc.rmenu.target");
	}

	/**
	 * 擪̃^[Qbg̎擾
	 */
	protected DocElement getTarget() {
	return (DocElement)(getTargets().firstElement());
	}

	/**
	 * ^[Qbg̃TCY
	 */
	protected int getTargetsSize() {
	return ((Vector)ZInstance.map().get("doc.rmenu.target")).size();
	}

	/**
	 * IԂ̕ύX
	 * @param top     gbv][
	 * @param targets IԂɂGgQ
	 */
	protected void setSelect(RidElementZone top, Vector targets) {
	top.setChildUnSelect();
	RidDocumentSite doc = (RidDocumentSite)top.getOwnerDocument();
	doc.setLinksUnSelect();
	if ( targets != null ) {
		Enumeration elm = targets.elements();
		while ( elm.hasMoreElements() ) {
			DocElement target = (DocElement)elm.nextElement();
			target.setSelect(null, true);
		}
	}
	}

	/**
	 * ANeBu}bv̕ύX
	 * @param top     gbv][
	 * @param szMap   }bvʎq
	 */
	protected void setActiveMap(DocElement top, String szMap) {
	DocElement map = (DocElement)top.getChildElement(".ViewInfo.Map",null);
	DocBar bar = (DocBar)ZInstance.map().get( Rid.DOCBAR );
	JRadioButton site = (JRadioButton)bar.getToolItem("Sitemap");
	JRadioButton hier = (JRadioButton)bar.getToolItem("Hiermap");
	JRadioButton circle = (JRadioButton)bar.getToolItem("Circlemap");

	if ( szMap.equals( "site" ) ) {
		map.setAttribute("Active","Site");
		if ( site!=null ) {
			hier.setSelected(false);
			circle.setSelected(false);
			site.setSelected(true);
		}
	} else if ( szMap.equals( "hier" ) ) {
		map.setAttribute("Active","Hier");
		if ( site!=null ) {
			site.setSelected(false);
			circle.setSelected(false);
			hier.setSelected(true);
		}
	} else if ( szMap.equals( "circle" ) ) {
		map.setAttribute("Active","Circle");
		if ( site!=null ) {
			site.setSelected(false);
			hier.setSelected(false);
			circle.setSelected(true);
		}
	}
	}

	//## Agr[g################################################
}
