/*
 * @(#)RidDocumentSite.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Document
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;
import java.awt.Dimension;

import java.awt.geom.AffineTransform;

import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZReverseEnumeration;

import jp.co.nri.Rid;
import jp.co.nri.rid.RUpdateManager;
/**
 * Rid Document(Sitep)
 */
public class RidDocumentSite extends RidDocument {

	/**
	 * ftHgRXgN^
	 */
	public RidDocumentSite() {
	}

	//## IDocument ####################################################
	/**
	 * 
	 */
	public void initDocument() {
	super.initDocument();

	ZResource res = ZApp.getTheApp().getResource();

	// Qƃt@C
	Element refElement = createElementNS(null,"ReferenceUnit");

	// \[Xt@C
	Element resElement = createElementNS(null,"FileUnit");
	resElement.setAttribute("Type","resource");
	resElement.setAttribute("Name",res.getString("rid.resource.xml"));
	refElement.appendChild(resElement);

	// hLgt@C
	Element docElement = createElementNS(null,"FileUnit");
	docElement.setAttribute("Type","document");
	docElement.setAttribute("Name",res.getString("rid.document.xml"));
	refElement.appendChild(docElement);

	// XibvVbgt@C
	Element snpElement = createElementNS(null,"FileUnit");
	snpElement.setAttribute("Type","snapshot");
	snpElement.setAttribute("Name",res.getString("rid.snapshot.xml"));
	refElement.appendChild(snpElement);

	getDocumentElement().appendChild(refElement);

	// gbv][
	Element topElement = createElementNS(null,"ZoneUnit");
	topElement.setAttribute("Name","_top");
	getDocumentElement().appendChild(topElement);

	// gbvN
	Element linkElement = createElementNS(null,"Link");
	getDocumentElement().appendChild(linkElement);

	// gbvViI
	Element scenarioElement = createElementNS(null,"Scenario");
	getDocumentElement().appendChild(scenarioElement);

	}

	//## plĂяo郁\bh ###############################
	/**
	 * wiF̎擾
	 * @param szPanelId plʎq
	 */
	public Color getBackground(String szPanelId) {
	ZResource res = ZApp.getTheApp().getResource();

	
	if ( szPanelId != null ) {
		// ][pl̔wi̓[g][̐F
		if ( szPanelId.equals(Rid.PANEL_ZONE) ) {
			RidElement zone = (RidElement)getRootElement(Rid.PANEL_ZONE);
			return zone.getBackgroundColor();
		} else if ( szPanelId.startsWith(Rid.PANEL_MAP) ) {
			return res.getColor("panel.color."+szPanelId);
		}
	}
	return super.getBackground(szPanelId);
	}

	/**
	 * R|[lg̘_IȍœKTCYԂ܂
	 * ̒l͊gk\̗Lɂ炸ŒłB
	 *
	 * getPreferredSize͊g\Ƒ傫ȂAk\ƏȂ܂
	 */
	public Dimension getLogicalSize() {
	return new Dimension(8000*Rid.PANELSIZE,6000*Rid.PANELSIZE);
	}

	//## root #########################################################
	/**
	 * ݃[g̐ݒ(][pl̂ݎgp)
	 * @param szPanelId plID
	 * @param elm       [gGg
	 */
	public void setRootElement(String szPanelId, Element elm) {

	if ( elm != null ) {
		mRoot.put(szPanelId,elm);
	} else {
		mRoot.remove(szPanelId);
	}

	// ʂ𒆉Ɉړ
/*
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͕`悵Ȃ
		return;
	}
	DocPane panel = (DocPane)active;
*/

	// 20020909 pl\ʒúADocPaneŐݒ肵Ă̂ŁAł͐ݒ肵Ȃ
//	panel.setCenter(new ZPoint(4000*Rid.PANELSIZE,3000*Rid.PANELSIZE));
	}

	/**
	 * ݃[g̎擾
	 *
	 * Zoneplł́A݃][̃GgԂ
	 * Pageplł́A݃y[W̃GgԂ
	 * Mapplł́AgetDocumentElement()Ԃ
	 *
	 * @param szPanelId plʎq
	 */
	public Element getRootElement(String szPanelId) {
	Element root =(Element)mRoot.get(szPanelId);
	// [gy[Wݒς݂ō폜Ă΁A
	if ( root != null && ((RidElement)root).getStatus().equals("remove") ) {
//		ZDebug.trace();
		mRoot.remove( szPanelId );
	}

	if ( root == null ) {
//		ZDebug.trace();
		root = getTopZone();
	}

	return root;
	}

	/**
	 * gbvy[W̐ݒ(CircleMap̂ݎgp)
	 * @param szPanelId plʎq
	 * @param szFile    gbvy[WFileAgr[g
	 */
	public void setTopPage(String szPanelId, String szFile) {
	DocElement root = getTopZone();
	// DOMɊi[Ă郋[gGg擾
	DocElement map = (DocElement)root.getChildElement(".ViewInfo."+szPanelId,null);
	map.setAttribute("Top", szFile);
	}

	/**
	 * gbvy[W̎擾
	 *
	 * y[WplE}bvplɂČ݂̊y[W擾
	 *
	 * @param szPanelId plʎq
	 */
	public RidElementPage getTopPage(String szPanelId) {
	RidElementPage topPage = null;
	DocElement root = getTopZone();
	// DOMɊi[Ă郋[gGg擾
	String szTop = root.getChildElementAttribute(".ViewInfo."+szPanelId,null,"Top");
	if ( szTop.length() > 0 ) {
//		topPage = (RidElementPage)root.findChildElement("PageUnit","File="+szTop);
		topPage = (RidElementPage)findChildElementInZone("PageUnit",szTop);

		// DOMɊi[Ăgbvy[WȂꍇ́AɍĐݒ
		if ( topPage == null ) {
			setTopPage( szPanelId,"");
			// gbvy[WȂȂꍇ́AANZXJEg̍XV
			requestUpdateAccessCount();
		}
	}
	
	// Ȃ gbv][TopvpeBQƂ
	if ( topPage == null ) {
		topPage = getDefaultTopPage(szPanelId);
/*
		ZDebug.trace("defaultTop:"+topPage.getAttribute("File"));
	} else {
		ZDebug.trace("Top:"+topPage.getAttribute("File"));
*/
	}
	return topPage;
	}

	/**
	 * ftHggbvy[W̎擾
	 *
	 * y[WplE}bvplɂăftHg̊y[W擾
	 *
	 * @param szPanelId plʎq
	 */
	public RidElementPage getDefaultTopPage(String szPanelId) {
	RidElementZone root = getTopZone();
	return root.getDefaultTopPage();
	}

	//## MapModel #####################################################
	/**
	 * MapModel̐ݒ
	 * @param szPanelId plID
	 * @param model     f
	 */
//	public void setMapModel(String szPanelId, MapModel model) {
//	mMapModel.put(szPanelId,model);
//	}

	/**
	 * MapModel̎擾
	 * @param szPanelId plID
	 */
	public MapModel getMapModel(String szPanelId) {
	MapModel model = (MapModel)mMapModel.get(szPanelId);
	if ( model == null ) {
		Dimension dim = getLogicalSize();
		model = new MapModel();
		if ( szPanelId.endsWith("Site") ) {
			model.setObjectTransform(new AffineTransform(1,0.75,0,1,0,0));
			model.setCoordTransform(new AffineTransform(80,-60,80,60,0,0));
			model.setLinkOffset(new ZPoint(0.5,1));
			model.setBasePoint(new ZPoint(dim.width/3,dim.height*2/3));
		} else if ( szPanelId.endsWith("Hier") ) {
			model.setCoordTransform(new AffineTransform(0,100,100,0,0,0));
			model.setBasePoint(new ZPoint(dim.width/2,300));
		} else if ( szPanelId.endsWith("Circle") ) {
			model.setCoordTransform( null );
			model.setBasePoint(new ZPoint(dim.width/2,dim.height/2));
		}
		mMapModel.put( szPanelId, model );
	}
	return model;
	}

	//## ViI #####################################################
	/**
	 * ViI̍쐬
	 */
	public void createScenario() {
	ZResource res = ZApp.getTheApp().getResource();

	String szMsg1 = res.getString("msg.askscenarioname1");
	String szMsg2 = res.getString("msg.askscenarioname2");
	JFrame frame  = (JFrame)ZInstance.map().get( Rid.FRAME );
	String result = JOptionPane.showInputDialog(frame,
		szMsg1,"Ridual",JOptionPane.QUESTION_MESSAGE);
	DocElement scene = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Scenario",null);
	while ( result != null && result.length()>0 ) {
		result = ZString.trimLeft( result );
		if ( result.length()==0 ) {
			break;
		}
		XElementNS unit = scene.findChildElement(".ScenarioUnit","Name="+result );
		if ( unit == null ) {
			beginTransaction();

			// ViIjbg̍쐬
			unit = (XElementNS)createElementNS(null,"ScenarioUnit");
			unit.setAttribute("Name",result);
			scene.appendChild( unit );

			// 쐬ViIJgViIɐݒ
			setScenarioName( result );

			commit();
			break;
		}
		// OdĂ̂ŁAē
		result = JOptionPane.showInputDialog(frame,
				result+" "+szMsg2,"Ridual",JOptionPane.WARNING_MESSAGE);
	}
	}

	/**
	 * ViI̍폜
	 */
	public void deleteScenario() {
	// 쐬ViIJgViIɐݒ
	String szName = getScenarioName() ;

	if ( szName.length()>0 ) {
		beginTransaction();
		DocElement scene = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Scenario",null);
		XElementNS unit = scene.findChildElement(".ScenarioUnit","Name="+szName );
		scene.removeChild( unit );
		setScenarioName("");
		commit();
	}
	}

	/**
	 * ViI̐ݒ
	 */
	public void setScenarioName(String szName) {
	DocElement top = getTopZone();
	XElementNS elm = top.getChildElement(".ViewInfo.Map",null );
	elm.setAttribute("Scenario",szName);

	RUpdateManager.update(RUpdateManager.UPDATE_MAP);
	}

	/**
	 * ViI̎擾
	 */
	public String getScenarioName() {
	DocElement top = getTopZone();
	XElementNS elm = top.getChildElement(".ViewInfo.Map",null );
	return elm.getAttribute("Scenario");
	}

	/**
	 * ViI̎擾
	 */
	public RidElementScenario getScenario(String szName) {
	RidElementScenario scenario = null;
	if ( szName.length()>0 ) {
		DocElement scene = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Scenario",null);
		scenario = (RidElementScenario)scene.findChildElement(".ScenarioUnit","Name="+szName );
	}
	return scenario;
	}

	//## ` #########################################################
	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createGobs(String szPanelId) {
	Vector gobs = new Vector(); ;
	if ( szPanelId.equals(Rid.PANEL_ZONE) ) {
		// Gob쐬OɑSẴGgMainGob𖳌ɂ
		DocElement top = getTopZone();
		top.preCreateGobs( szPanelId ) ;

		// ǉGob̍폜
		// ǉGob́AcreateLinkGobs̓rŒǉ
		GobManager.list(szPanelId,"additional").removeAllElements();
		RidElement.mAllUnits = null;

		// `Gg̎擾
		gobs.addAll( super.createGobs(szPanelId) );

		// NGg̎擾
		Vector links = createLinkGobs( szPanelId );

		// ǉGob̒ǉFNGg̎擾ɍ쐬
		gobs.addAll( GobManager.list(szPanelId,"additional"));

		// NGg̒ǉ
		gobs.addAll( links );

	} else if ( szPanelId.startsWith(Rid.PANEL_MAP) ) {
		RidElementPage page = getTopPage(szPanelId);
		if ( page == null ) {
			return gobs;
		}

		// Gob쐬OɑSẴGgMainGob𖳌ɂ
		// 20020430 MapʂɃN𒣂邱ƂɂȂ̂ŁAKvɂȂ
		DocElement top = getTopZone();
		top.preCreateGobs( szPanelId ) ;

		// ANZXO`悷ɂA`揇ɐ񂪏oĂ̂ŁȀŕ`悷
		// @iIEs̐ACirclẻ~܂ށj
		// AKw̐[iʃxKẃjy[W
		Vector gobVec = new Vector();
		gobVec.add( new Vector() ) ; // Gobi[̈
		// T[N}bv̏ꍇ̓[gP
		if ( szPanelId.endsWith("Circle") ) {
			page.preCreateMapGobs(szPanelId);
			page.createMapGobs(szPanelId,1,gobVec);
		} else {
			if ( page.getMapParent(szPanelId,"Auto").equals("root") ) {
				// gbv[g̏ꍇ̓y[Wꗗ`悷
				Vector pages = getTopZone().getPages(true);
				Vector tops = new Vector();
				Enumeration elm = pages.elements();
				while ( elm.hasMoreElements() ) {
					page = (RidElementPage)elm.nextElement();
					if ( page.getMapParent(szPanelId,"Auto").equals("root") ) {
						page.preCreateMapGobs(szPanelId);
						tops.add(page);
					}
				}
				if ( szPanelId.endsWith("Site") ) {
					// ANZXJEgől̍XV
					updateAccessCount(szPanelId,tops);
				}
				elm = tops.elements();
				while ( elm.hasMoreElements() ) {
					page = (RidElementPage)elm.nextElement();
					page.createMapGobs(szPanelId,1,gobVec);
				}
			// gbv[głȂΕ\
			} else {
				page.preCreateMapGobs(szPanelId);
				if ( szPanelId.endsWith("Site") ) {
					// ANZXJEgől̍XV
					Vector tops = new Vector();
					tops.add( page );
					updateAccessCount(szPanelId,tops);
				}
				page.createMapGobs(szPanelId,1,gobVec);
			}
		}

		// W߂Ăgobsɒǉ
		Vector lineGobs = (Vector)gobVec.elementAt(0);
		gobVec.removeElementAt(0);
		gobs.addAll( lineGobs );
		// W߂ĂKwƂ̃y[Wtgobsɒǉ
		Enumeration gobElm = new ZReverseEnumeration( gobVec );
		while ( gobElm.hasMoreElements() ) {
			gobs.addAll( (Vector)gobElm.nextElement() );
		}

		// Rg̕`
		page = getTopPage(szPanelId);
		DocElement comments = (DocElement)page.findChildElement(".Comments",null);
		if ( comments != null ) {
			for ( int nIndex=0; nIndex<comments.getLength() ; nIndex++ ) {
				Node elm = (Node)comments.item(nIndex);
				if ( elm instanceof DocElement ) {
					gobs.addAll(((DocElement)elm).createGobs( szPanelId,false ));
				}
			}
		}

		// ViIGg̎擾i擪ɒǉj
		Vector scenes = createScenarioGobs( szPanelId );
		scenes.addAll( gobs );
		gobs = scenes;

		// NGg̎擾
		Vector links = createLinkGobs( szPanelId );
		gobs.addAll( links );
	}

	return gobs;
	}

	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createSkeltonGobs(String szPanelId) {
	Vector gobs = new Vector(); ;
	if ( szPanelId.equals(Rid.PANEL_ZONE) ) {
		gobs.addAll(super.createSkeltonGobs(szPanelId));

	} else if ( szPanelId.startsWith(Rid.PANEL_MAP) ) {
		RidElementPage page = getTopPage(szPanelId);
		// T[N}bv̏ꍇ̓[gP
		if ( szPanelId.endsWith("Circle") ) {
			if ( page != null ) {
				gobs.addAll(page.createMapSkeltonGobs(szPanelId));
			}
		} else {
			if ( page != null ) {
				if ( page.getMapParent(szPanelId,"Auto").equals("root") ) {
					// y[Wꗗ擾
					Vector pages = getTopZone().getPages(true);
					Enumeration elm = pages.elements();
					while ( elm.hasMoreElements() ) {
						page = (RidElementPage)elm.nextElement();
						if ( page.getMapParent(szPanelId,"Auto").equals("root") ) {
							gobs.addAll(page.createMapSkeltonGobs(szPanelId));
						}
					}
				// gbv[głȂΕ\
				} else {
					gobs.addAll(page.createMapSkeltonGobs(szPanelId));
				}
			}
		}
	}

	return gobs;
	}

	/**
	 * NGg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createLinkGobs(String szPanelId) {
	DocElement link = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Link",null);
	Vector gobs = new Vector();
	if ( link != null ) {
		// qm[h̕`
		for ( int nIndex=0; nIndex<link.getLength() ; nIndex++ ) {
			Node elm = (Node)link.item(nIndex);
			if ( elm instanceof RidElementLink ) {
				gobs.addAll(((RidElementLink)elm).createGobs( szPanelId ));
			}
		}
	}
	return gobs;
	}

	/**
	 * ViIGg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createScenarioGobs(String szPanelId) {
	RidElementScenario scene = getScenario(getScenarioName());
	Vector gobs = new Vector();
	if ( scene != null ) {
		// qm[h̕`
		for ( int nIndex=0; nIndex<scene.getLength() ; nIndex++ ) {
			Node elm = (Node)scene.item(nIndex);
			if ( elm instanceof RidElementScenarioItem ) {
				gobs.addAll(((RidElementScenarioItem)elm).createGobs( szPanelId ));
			}
		}
	}
	return gobs;
	}

	//## ANZXJEg #############################################
	/**
	 * ANZXJEgől̍XV
	 * CreateGobOcall
	 *
	 * @param szPanelId plʎq
	 * @param pages gbvy[WQ
	 */
	protected void updateAccessCount( String szPanelId, Vector pages ) {
	MapModel model = getMapModel(szPanelId);

//	ANZXO\ȂꍇAŃANZXO\邩Ȃ̂ŁA
//	ANZXJEg̍ő吔
	AccessCounts acc = null;
	if ( mUpdateAccessCount ) {
		// ANZXO`惋[̎擾
		DocElement top = getTopZone();
		String szLogList = top.getAttribute("AccessLogList");
		String szLogType = top.getAttribute("AccessLogType");
		boolean[] bLogList = null;
		if ( szLogList.length() > 0 ) {
			bLogList = new boolean[szLogList.length()] ;
			for ( int nAt=0 ; nAt<szLogList.length() ; nAt++ ) {
				bLogList[nAt] = ( szLogList.charAt(nAt) != 'n' ) ;
			}
		}

		Enumeration elm = pages.elements();
		while ( elm.hasMoreElements() ) {
			RidElementPage page = (RidElementPage)elm.nextElement();
			AccessCounts acc2 = page.getMaxAccessCount(szPanelId,bLogList);
			if ( acc == null ) {
				acc = acc2 ;
			} else {
				acc.margeMax( acc2 );
			}
		}
		if ( acc != null ) {
			acc.setLogType( szLogType );
			acc.calcMaxCount();
		}
		model.setAccessCounts( acc );

	}
	mUpdateAccessCount = false;
	}

	/**
	 * ANZXJEgőlČvZ
	 */
	public void requestUpdateAccessCount() {
	mUpdateAccessCount = true;
	}

	//##  #########################################################
	/**
	 * ][jbǧ
	 * @param szTag ^O
	 * @param szKey L[
	 */
	protected RidElement findChildElementInZone( String szTag, String szKey ) {
	RidElement parent = getTopZone();
	String[] szKeys = ZString.tokenize(szKey,"/");

	// q][ǂ
	for ( int nAt=0; nAt<(szKeys.length-1) ; nAt++ ) {
		parent = (RidElement)parent.findChildElement( ".ZoneUnit", "Name="+szKeys[nAt] );
		if ( parent == null ) {
			return null;
		}
	}

	// ŌɌΏۃjbg擾
	return (RidElement)parent.findChildElement( "."+szTag, "File="+szKey );
	}

	//## Link #########################################################
	/**
	 * Ñy[Wݒ肵Ă郊NQ߂
	 * @param page         Ny[W
	 * @param szPanelId    Mapʂɂey[Wۂ`FbNꍇ̃plʎq
	 *                     (ČvZ̎̂false)
	 * @ret NQ
	 */
	public Vector getToLink( RidElementPage page, String szPanelId ) {
	Vector    linkTo     = new Vector();
	Hashtable linkToHash = new Hashtable();

	DocElement linklist = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Link",null);
	if ( linklist != null ) {
		NodeList list = linklist.getChildNodes();
		for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
			Node child = list.item(nAt);
			if ( child instanceof RidElementLink ) {
				RidElementLink linkUnit = (RidElementLink)child;
				RidElement toPage = linkUnit.getLinkToElement(page);
				if ( toPage != null && ( toPage instanceof RidElementPage ) ) {
					// ꂼ̃NjbgɂāAdȂ悤ɒǉ
					if ( szPanelId != null ) {
						if ( !page.getAttribute("File").equals(((RidElementPage)toPage).getMapParent(szPanelId,null)) ) {
							continue;
						}
					}

					String szToFile = toPage.getAttribute("File");
					RidElementLink linkPrev = (RidElementLink)linkToHash.get( szToFile );
					if ( linkPrev == null ) {
						// ǉ
						linkTo.add( linkUnit );
						linkToHash.put( szToFile, linkUnit );
					} else if ( !linkPrev.getAttribute("Intensity").equals("Virtual") &&
								 linkUnit.getAttribute("Intensity").equals("Virtual") ) {
						// ւ
						linkTo.remove( linkPrev );
						linkTo.add( linkUnit );
						linkToHash.put( szToFile, linkUnit );
					} else {
						// Ȃ
					}
				}
			}
		}
	}
	return linkTo;
	}

	/**
	 * Ñy[W߂
	 * @param page Ny[W
	 * @ret Ñy[WQ
	 */
	public Vector getFromPage( RidElementPage page ) {
	Vector pageFrom = new Vector();
	Hashtable pageFromHash = new Hashtable();

	DocElement linklist = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Link",null);
	if ( linklist != null ) {
		NodeList list = linklist.getChildNodes();
		for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
			Node child = list.item(nAt);
			if ( child instanceof RidElementLink ) {
				RidElementLink linkUnit = (RidElementLink)child;
				RidElement fromPage = linkUnit.getLinkFromElement(page);
				if ( fromPage != null && ( fromPage instanceof RidElementPage ) ) {
					String szFromFile = fromPage.getAttribute("File");
					RidElementPage pagePrev = (RidElementPage)pageFromHash.get( szFromFile );
					if ( pagePrev == null ) {
						// ǉ
						pageFrom.add( fromPage );
						pageFromHash.put( szFromFile, fromPage );
					}
				}
			}
		}
	}
	return pageFrom;
	}

	/**
	 * NGgׂĖIɐݒ
	 */
	public void setLinksUnSelect() {
	DocElement link = (DocElement)((DocElement)getDocumentElement()).findChildElement(".Link",null);
	Vector gobs = new Vector();
	if ( link != null ) {
		// qm[h̕`
		for ( int nIndex=0; nIndex<link.getLength() ; nIndex++ ) {
			Node elm = (Node)link.item(nIndex);
			if ( elm instanceof RidElementLink ) {
				RidElementLink linkUnit = (RidElementLink)elm;
				linkUnit.setSelect(null,false);
			}
		}
	}
	}

	//## l`o #######################################################
	/**
	 * ČvZNGXg
	 */
	public void requestRecalcMap() {
	// SẴ}bvČvZ
	// Site
	DocElement root = (DocElement)getRootElement( Rid.PANEL_MAP+".Site" );
	DocElement map  = (DocElement)root.getChildElement(".ViewInfo.Map.Site",null);
	map.setAttribute("Calc","none");
	// Hier
	root = (DocElement)getRootElement( Rid.PANEL_MAP+".Hier" );
	map  = (DocElement)root.getChildElement(".ViewInfo.Map.Hier",null);
	map.setAttribute("Calc","none");
	// Circle
	root = (DocElement)getRootElement( Rid.PANEL_MAP+".Circle" );
	map  = (DocElement)root.getChildElement(".ViewInfo.Map.Circle",null);
	map.setAttribute("Calc","none");
	}

	/**
	 * ČvZ(ČvZΏۃy[W̑I)
	 * @param szPanelId plʎq
	 * @param isZoneBase ][DASY
	 */
	public void requestUpdateAccessCount(String szPanelId,boolean isZoneBase) {
	}
	
	/**
	 * ČvZ(ČvZΏۃy[W̑I)
	 * @param szPanelId plʎq
	 * @param isZoneBase ][DASY
	 */
	public ZRectangle recalcMap(String szPanelId,boolean isZoneBase) {
	// ANZXJEg̍XV
	requestUpdateAccessCount();

	// gbvy[W(؂̍ƂȂy[W)̐ݒ
	RidElementPage topPage = null ;
	if ( szPanelId.endsWith("Circle") ) {
		topPage = getTopPage( szPanelId );
	} else {
		topPage = getDefaultTopPage( szPanelId );
	}
	if ( topPage == null ) {
		// y[WPȂ̂ŁAČvZsv
		return null;
	}
//	ZDebug.trace("Recalc:"+topPage.getAttribute("Key"));

	// MapModel̏
	MapModel model = getMapModel(szPanelId);
	model.clearOffset();

	// y[WꗗpagesɎ擾AMapԍ̃NAATopy[Wpages̐擪ɎĂ
	RidElementZone top = getTopZone();
	Vector pageAll = top.getPages(true);
	Vector pages = new Vector();
	Enumeration elmPages = pageAll.elements();
	while ( elmPages.hasMoreElements() ) {
		RidElementPage page = (RidElementPage)elmPages.nextElement();
		page.clearMap(szPanelId);
		if ( page != topPage ) {
			pages.add( page );
		}
	}
	pages.add( 0, topPage );

	// ČvZSTEP1:Majorԍ̕t^ƁAe
	Vector topPages = null;
	if ( szPanelId.endsWith("Circle") ) {
		// CircleMap̓[g1݂łȂ
		topPages = new Vector();
		topPages.add( topPage );
		recalcMapMajor( szPanelId, isZoneBase, topPages );
	} else {
		topPages = recalcMapMajor( szPanelId, isZoneBase, pages );
	}

	// ČvZSTEP2:ȑOMinorɕוςAMinorԍ̐ݒ
	MapMinorTree tree = recalcMapMinor( szPanelId, topPages, 1, false );

	// [oĂ
	DocElement elm = (DocElement)topPage.getChildElement(".ViewInfo."+szPanelId,null);
	elm.setIntAttr("Depth",tree.getDepth());

	// ČvZ̃R~bg
	ZRectangle rtAll = null;
	elmPages = pages.elements() ;
	while ( elmPages.hasMoreElements() ) {
		RidElementPage page = (RidElementPage)elmPages.nextElement();
		ZRectangle rtPage = page.recalcMapEnd(szPanelId,tree.getMaxMinor());
		if ( rtAll == null ) {
			rtAll = rtPage;
		} else {
			rtAll.union( rtPage );
		}
	}
	
	if ( rtAll != null ) {
		// ``킩̂ŁAplTCYɂ킹悤ɕ␳
		// rtAll inset
		double INSET = 20;
		ZRectangle rtInset = new ZRectangle( rtAll.getX()-INSET,
											 rtAll.getY()-INSET,
											 rtAll.getWidth()+INSET*2,
											 rtAll.getHeight()+INSET*2 );
		rtAll = model.fitToPanel( rtInset, getLogicalSize() );
	}

	return rtAll;
	}

	/**
	 * STEP1:Majorԍ̐ݒƐe
	 * @param szPanelId  plʎq
	 * @param isZoneBase ][DASY
	 * @param pages      Topy[WɂȂ\̂y[W
	 */
	public Vector recalcMapMajor(String szPanelId,boolean isZoneBase,Vector pages) {
	Vector topPages = new Vector();
	Enumeration elmPages = pages.elements();
	int nTopLevelId = 1;
	while ( elmPages.hasMoreElements() ) {
		RidElementPage page = (RidElementPage)elmPages.nextElement();

		boolean isCalced = page.recalcMapMajor( szPanelId, null, isZoneBase, nTopLevelId );
		// ܂vZĂȂ΃xP̃y[WȂ̂ŁArootPagesɒǉ
		if ( isCalced ) {
			topPages.add( page );
		}
		nTopLevelId++;
	}
	return topPages;
	}

	/**
	 * STEP2:Minorԍt^AZԂ̌ԂΖ߂āAMapTreeԂ
	 *
	 * @param szPanelId plʎq
	 * @param brothers  Zy[W
	 * @param minor     Jnminor ԍ
	 * @param bIndent   L
	 */
	public MapMinorTree recalcMapMinor(String szPanelId,Vector brothers,double minor, boolean bIndent) {
	// Z\[g
	Collections.sort(brothers,new PreMinorSorter());
	MapMinorTree tree = null;

	// ꂼ̌Zy[Wɂ
	Enumeration elm = brothers.elements();
	while ( elm.hasMoreElements() ) {
		RidElementPage page = (RidElementPage)elm.nextElement();
		
		// q̃y[WMapTreevZ
		double childMinor = (tree==null)?minor:tree.getMaxMinor()+1;
		MapMinorTree tree2 = page.recalcMapMinor(szPanelId, childMinor, bIndent);
		if ( tree == null ) {
//			ZDebug.trace("first tree:"+page.getAttribute("File"));
			tree = tree2;
		} else {
			if ( !szPanelId.endsWith("Circle") ) {
				// Qlڈȍ~̎q̏ꍇ́AԂ߂āAMapTreeČvZ
				double distance = tree.distance( tree2 );
//				ZDebug.trace("next tree:"+page.getAttribute("File")+",distance:"+distance);
				if ( distance > 1 ) {
					tree2 = page.recalcMapMinorMove( szPanelId, 1 - distance );
				} else if ( distance <= 0 ) {
					// ԂȂꍇ͊Ԃ
					tree2 = page.recalcMapMinorMove( szPanelId, 1 - distance );
				}
			}
			tree.marge( tree2 );
		}
		
		// Ƃ肠ZԂ̃Cfg
		// ĥŁACfg͂߂̂ł́H
		bIndent = (!bIndent);
	}
	return tree;
	}

	//## \[gpTuNX ###########################################
	public class PreMinorSorter implements Comparator {
	/**
	 * r
	 */
	public int compare(Object o1, Object o2) {
	RidElementPage p1 = (RidElementPage)o1;
	RidElementPage p2 = (RidElementPage)o2;
	int nRet = 0;
	double diff = p1.wMinorPre-p2.wMinorPre;
	if ( diff > 0 ) {
		nRet = 1;
	} else if ( diff < 0 ) {
		nRet = -1;
	}
	return nRet;
	}

	/**
	 * \[^ƓH
	 */
	public boolean equals(Object obj) {
	return (obj instanceof PreMinorSorter );
	}
	
	}

	//## Agr[g################################################
	/**
	 * `惋[gGg
	 * Xg[WɊi[Ȃf[^
	 */
	protected Hashtable mRoot = new Hashtable();

	/**
	 * Mapf
	 */
	protected Hashtable mMapModel = new Hashtable();

	/**
	 * ANZXOőlɍXVKvtO
	 */
	protected boolean mUpdateAccessCount = true;
}
