/*
 * @(#)RidElementUrl.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Element
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;

import java.util.Vector;

import org.w3c.dom.DOMException;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.fob.FColor;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GEllipse;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.GRectangle;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.error.RidException;

import jp.co.nri.rid.environment.MessageDialog;
/**
 * Rid Element(Urlp)
 */
public class RidElementUrl extends RidElement {

	/**
	 * ftHgRXgN^
	 */
	public RidElementUrl() throws DOMException {
	}

	/**
	 * L[Agr[g̎擾
	 */
	public String getAttribute(String name) {
	if ( name.equals("Key" ) ) {
		return super.getAttribute("Name");
	}
	return super.getAttribute(name);
	}

	/**
	 * L[Agr[g̎擾
	 */
	public void setAttribute(String name,String value) {
	if ( name.equals("Key" ) ) {
		setAttribute("Name",value);
	} else {
		super.setAttribute(name,value);
	}
	}

	/**
	 * DOM폜
	 */
	public void removeFromDocTree() {
	super.removeFromDocTree();
	updateLink(null);
	}

	//## IGobContainerFqbg ########################################
	/**
	 * vfɐڑ邩H
	 * @param gob NGXgGob
	 * @param pt  _W
	 * @param obj  ڑΏ
	 */
	public byte getConnectMode(GElement gob,ZPoint pt,Object obj) {
	return getConnectModeImpl(gob, pt, obj ) ;
	}

	//## IGobContainerFړ ##########################################
	/**
	 * ړ̊
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) {
	// 擾WńA][Wn
	ZRectangle rect = new ZRectangle(getMovingPath(gob,grid).getBounds2D());
	DocPane editor = grid.getEditor();
	RidDocument doc = (RidDocument)editor.getDocument();

	// CGob̏ꍇ
	if ( isGobId(gob,"zone") || isGobId(gob,"new") ) {
		switch ( grid.getMoveMode() ) {
		  case GOperation.NEW:		// VK쐬
			// gbv][mF
			DocElement root = (DocElement)doc.getRootElement(editor.getPanelId());
			RidElementZone top = ((RidDocument)doc).getTopZone();
			if ( top == root ) {
				// ǉ
				setAttribute("Creator","Operator");
				setSelect(null,true);
				setDocument( doc );
				top.appendChild( this );
				treeChanged();
			} else {
				// TopȊOZoneURL͔zuł܂
				RidMessage ridMsg = new RidMessage();
				MessageDialog.showError(ridMsg.Error("E1200",""));
			}
			break;
		}
		setRect( editor.getPanelId(),rect ) ;

	// ̃][ւ̎ʑGob̏ꍇ
	} else {
		String szRoot = gob.getGobId().substring(4);
		setRect( editor.getPanelId(),szRoot,rect ) ;
	}
	}

	//## ` #########################################################
	/**
	 * `Gg̎擾
	 *
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L(˂false)
	 */
	public Vector createGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();

	if ( !hasRect(szPanelId) ) {
		ZPoint pt = getSpace(szPanelId);
		ZRectangle rt = new ZRectangle( pt.getX(), pt.getY(), 20, 20 );
		setRect(szPanelId,rt);
	}

	GRectangle gRect = new GRectangle();
	// `̐ݒ
	ZRectangle rect = getRect( szPanelId );
	gRect.setRect( rect );
	// wiF̐ݒ
	Color col = getBackgroundColor();
	gRect.getStyle().setFillColor( new FColor( col ));
	gRect.getStyle().setStrokeColor( new FColor( Color.black ));
	gRect.setSelect(isSelect());
	gRect.setEditOption(GRectangle.NORESIZE);
	gRect.setContainer(this);
	gRect.setGobId("zone");
	gobs.add(gRect);
	setMainGob(szPanelId,gRect);

	// ^Cg̕\
	Vector children = new Vector();
	ZResource res = ZApp.getTheApp().getResource();
	String szTextType = res.getString("viewtext.Zone."+getTagName());
	String szText = getAttribute(szTextType);
	if ( szText != null && szText.length() > 0 ) {
//System.out.println(szText);
		double dTitleHeight = getTitleHeight();

		// ␳FTCYƓɂ
		ZDimension dim = getTextPreferredSize(null,0,szText,null,0);

		ZRectangle rttxt =
			new ZRectangle(rect.getX()+LINE+TTLIN,rect.getY()+rect.getHeight()+LINE+TTLIN,
						   dim.getWidth()+szText.length(),dTitleHeight);
//		ZDebug.trace("str:"+szText+",,,"+rttxt);
		GString str = new GString();
		str.setText( szText );
		str.getStyle().setFillColor( new FColor( Color.black ));
		str.setFormat( GString.SINGLE|GString.LEFT|GString.MIDDLE );
		str.setRect( rttxt );
		children.add(str);
		gRect.addForeChildren(children);
	}

	return gobs;
	}

	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́AgwiƂĕ`悷
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createSkeltonGobs(String szPanelId,boolean isRoot) {
	return new Vector();
	}

	//## IGobContainerFړ ##########################################
	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
	ZRectangle rect = ((GRectangle)gob).getMovingRectGob(grid);

	if ( grid.getMoveMode() == GOperation.NEW ) {
		ZPoint pt = grid.getMoveGrid() ;
		rect = new ZRectangle(pt.getX(),pt.getY(),20,20);
	}
	return  new ZPath( rect );
	}

	//## Agr[g################################################
}
