/*
 * @(#)RidRootAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : [gؑ֌n Action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/09
 */
package jp.co.nri.rid.doc;

import java.awt.event.ActionEvent;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JTabbedPane;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidDocumentSite;

import jp.co.nri.rid.RUpdateManager;
/**
 * Rid plؑ֌n Action
 */
public class RidRootAction extends RidAction {
	/**
	 * ANVs
	 */
	public void doAction(ActionEvent evt) {
	String szAction = getActionName();
	Vector targets  = getTargets();
	JTabbedPane     tab = (JTabbedPane)ZInstance.map().get(Rid.PANEL_TAB);
	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
	RidElementZone  top = doc.getTopZone();

	boolean isTran = doc.isTransaction();
	if ( !isTran ) {
		doc.beginTransaction();
	}

	if ( szAction.equals( ZONE ) ) {
		// ^uV[g̈ړ
		tab.setSelectedIndex(Rid.PANEL_ZONE_INDEX);

		// SẴGg𖢑IԂ
		setSelect( top, null );

		// Zonepl̎擾
		DocPane  editor = (DocPane)ZInstance.map().get(Rid.PANEL_ZONE);
		DocElement root = (DocElement)doc.getRootElement(editor.getPanelId());

		// TCghLg̃[gIꂽ][ɐݒ
		RidElementZone zone = (RidElementZone)getTarget() ;
		
		if ( zone != root ) {
			// updatechangeRootōŝŕsv
			zone.changeRoot(editor);
		} else {
			// ANeBupl̍ĕ`
//			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE, true);
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
		}

	} else if ( szAction.equals( SITE   ) ||
				szAction.equals( HIER   ) ||
				szAction.equals( CIRCLE ) ) {
		// ^uV[g̈ړ
		tab.setSelectedIndex(Rid.PANEL_MAP_INDEX);

		// ANeBu}bv̕ύX
		String[] szMap = ZString.tokenize( szAction, "_" );
		setActiveMap( top, szMap[1] );

		// IԂ̕ύX
		setSelect( top, targets );

		// Mappl̎擾
		DocPane editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
		RidElementPage newTop     = (RidElementPage)getTarget();
		RidElementPage currentTop = doc.getTopPage(editor.getPanelId());

		// gbvy[W̕ύX
		if ( newTop != currentTop ) {
			// updatechangeTopōŝŕsv
			newTop.changeTop( editor );
		} else {
			// ANeBupl̍ĕ`
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE, true);
		}
	}

	if ( !isTran ) {
		doc.commit();
	}
	}

	/**
	 * UIXV
	 */
	public void update() {
	String szAction = getActionName();
	boolean bState = true;
	if ( szAction.equals( ZONE ) ) {
		if ( getTargetsSize() != 1 ) {
			bState = false;
		}
	}

	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## Agr[g ###############################################
    /**
     * ANVFzone̕\
     */
	final static public String ZONE		= "view_zone" ;

    /**
     * ANVFsite̕\
     */
	final static public String SITE		= "view_site" ;

    /**
     * ANVFhier̕\
     */
	final static public String HIER		= "view_hier" ;

    /**
     * ANVFcircle̕\
     */
	final static public String CIRCLE	= "view_circle" ;
}
