/*
 * @(#)DocumentTypeDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X FhLg^Cv_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * hLg^Cv_CAO
 */

public class DocumentTypeDialog {

    /** Cpl        **/
    protected JPanel      mPanel  = null;
    /** Application         **/
    protected JTextField  mTApp   = null;
    /** Command             **/
    protected JTextField  mTCmd   = null;
    /** Command fileChooser **/
    protected JButton     mBCmd   = null;
    /** Extension           **/
    protected JTextField  mTExt   = null;
    /** View Extension      **/
    protected JTextField  mTVext  = null;

    /**
      * ftHgRXgN^
      */
      public DocumentTypeDialog() {  }

    /**
      * VK_CAO
      *
      * @param  DocumentType    label     DocumentTypeNX
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean newDocument(DocumentType dt) {

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, "Document Type (New)");

        //CR|[lg
        mPanel = crtPanel();
        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            //f[^ݒ
            setDocumentType(dt);
        }   
        return ret;
    }


    /**
      * ҏW_CAO
      *
      * @param  DocumentType    label     DocumentTypeNX
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean editDocument(DocumentType dt) {

        String app,cmd,ext,view;
        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, "Document Type (Edit)");

        if (dt.app  != null) app  = dt.app;  else app  = "";
        if (dt.cmd  != null) cmd  = dt.cmd;  else cmd  = "";
        if (dt.ext  != null) ext  = dt.ext;  else ext  = "";
        if (dt.view != null) view = dt.view; else view = "";

        //CR|[lg
        mPanel = crtPanel();

        //f[^ݒ
        mTApp.setText(app);
        mTApp.setColumns(Math.max(20, app.length()));
        
        mTCmd.setText(cmd); 
        mTCmd.setColumns(Math.max(20, cmd.length()));
        
        mTExt.setText(ext);
        mTExt.setColumns(Math.max(20, ext.length()));
        
        mTVext.setText(view);
        mTVext.setColumns(Math.max(20, view.length()));

        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            //f[^ݒ
            setDocumentType(dt);
        }   
        return ret;
    }

    /**
      * _CAO
      *
      * @return JPanel
      */
    public JPanel crtPanel() {

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints lgbc = createLabelConstraints();
        GridBagConstraints cgbc = createComponentConstraints();

        //x
        lgbc.gridx      = 0;
        lgbc.gridy      = 0;
        JLabel label = new JLabel("Application");
        mLayout.setConstraints(label, lgbc);
        mPanel.add( label );

        //Application
        cgbc.gridx      = 1;
        cgbc.gridy      = 0;
        mTApp = new JTextField("",20);
        mLayout.setConstraints(mTApp, cgbc);
        mPanel.add( mTApp );

        //x
        lgbc.gridx      = 0;
        lgbc.gridy      = 1;
        label = new JLabel("Command");
        mLayout.setConstraints(label, lgbc);
        mPanel.add( label );

        //Command
        cgbc.gridx      = 1;
        cgbc.gridy      = 1;
        mTCmd = new JTextField("",20);
        mLayout.setConstraints(mTCmd, cgbc);
        mPanel.add( mTCmd );

        //x
        lgbc.gridx      = 0;
        lgbc.gridy      = 2;
        label = new JLabel("Extension");
        mLayout.setConstraints(label, lgbc);
        mPanel.add( label );

        //Command fileChooser
        cgbc.gridx      = 2;
        cgbc.gridy      = 1;
        cgbc.weightx = 0.0 ;
        mBCmd = new JButton("...");
        mLayout.setConstraints(mBCmd, cgbc);
        mPanel.add( mBCmd );
        mBCmd.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { fileChooser(); }
            }
        );

        //Extension
        cgbc.gridx      = 1;
        cgbc.gridy      = 2;
        mTExt = new JTextField("",20);
        mLayout.setConstraints(mTExt, cgbc);
        mPanel.add( mTExt );

        //x
        lgbc.gridx      = 0;
        lgbc.gridy      = 3;
        label = new JLabel("View Extension");
        mLayout.setConstraints(label, lgbc);
        mPanel.add( label );

        //View Extension
        cgbc.gridx      = 1;
        cgbc.gridy      = 3;
        mTVext = new JTextField("",20);
        mLayout.setConstraints(mTVext, cgbc);
        mPanel.add( mTVext );

        return mPanel;
    }


    /**
      * hLg^Cv̐ݒ
      *
      * @param  DocumentType    label     DocumentTypeNX
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public void setDocumentType(DocumentType dt) {
        dt.app  = getAppText();    //Application̕擾
        dt.cmd  = getCmdText();    //Command̕擾
        dt.ext  = getExtText();    //Extension̕擾
        dt.view = getVExtText();   //View Extension̕擾
    }

    /**
      * xpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0 ;
        gbc.insets  = new Insets(0,10,0,10) ;
        return gbc;
    }


    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
        gbc.insets    = new Insets(0,0,0,10) ;
        return gbc;
    }

    /**
      * fileChooser
      *
      * @return void
      */
    public void fileChooser() {
        // FileChooser
        EnvFileChooser fileChooser = new EnvFileChooser();
        String szFile = fileChooser.show(ZApp.getTheApp().getFrame(), getCmdText(), JFileChooser.FILES_AND_DIRECTORIES);
        // [OK]{^̏ꍇA
        if (szFile != null) mTCmd.setText(szFile);
    }

    /**
      * Application̕擾
      *
      * @return String
      */
    private String getAppText(){
        String szTmp = mTApp.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * Command̕擾
      *
      * @return String
      */
    private String getCmdText(){
        String szTmp = mTCmd.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * Extension̕擾
      *
      * @return String
      */
    private String getExtText(){
        String szTmp = mTExt.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * View Extension̕擾
      *
      * @return String
      */
    private String getVExtText(){
        String szTmp = mTVext.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }
}
