/*
 * @(#)EnvColorEditor.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : J[R[h̓GA
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/11/07
 */
package jp.co.nri.rid.environment;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

import javax.swing.JComponent;
import javax.swing.JColorChooser;
import jp.co.iti.fagot.util.ZGraphicUtil;

/**
  *J[R[h̓GA
  **/
public class EnvColorEditor extends JPanel {
    /** pl **/
    protected JPanel        mPanel    = null;
    /** ̓GA **/
    protected JTextField    mText     = null;
    /** {^ **/
    protected JToggleButton mTButton  = null;

    /**
      *  TEXT̈̍쐬
      */
    public EnvColorEditor(String value) {

        // pl̐
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        //gbc.insets   = new Insets(0,10,0,10) ;

        // TextField̐
        mText = new JTextField(value);
        setTextColor();
        mText.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { setTextColor(); }
            }
        );
        mPanel.add(mText);

        //gbc.fill    = GridBagConstraints.HORIZONTAL; 
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 0;
        mLayout.setConstraints(mText, gbc);


        mTButton = new JToggleButton("Edit");
        mTButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { colorChooser(); }
            }
        );
        gbc.fill    = GridBagConstraints.NONE;
        gbc.weightx = 0.0;
        gbc.gridx   = 1;
        mLayout.setConstraints(mTButton, gbc);
        mPanel.add(mTButton);
    }


    /**
      * JPanel̎擾
      */
    public JPanel getPanel(){
        return mPanel;
    }

    /**
      * JTextField̎擾
      */
    public JTextField getTextField() {
        return mText;
    }


    /**
      * JTextFieldl̐ݒ
      * @param szValue ݒ蕶
      */
    public void setString( String szValue ){
        mText.setText( szValue );
    }

    /**
      * JTextFieldl̎擾
      */
    public String getString(){
        String szTmp = mText.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * JToggleButton̎擾
      */
    public JToggleButton getTButton() {
        return mTButton;
    }


    /**
      *@{^ꂽƂ̏
      */
    public void colorChooser() {

        Color  current = ZGraphicUtil.stringToColor(getString());
        Color  c = JColorChooser.showDialog(mPanel,"Choose a color",current);
        //Color  c = JColorChooser.showDialog(this,"Choose a color",current);
        //JDialog dlg = JColorChooser.createDialog(c ,"Choose a color" ,true ,this ,this ,this);
        if ( c != null && c != current ) {
            setString( ZGraphicUtil.colorToString(c) );
            setTextColor();
        }
        mTButton.setSelected(false);

      }


    /**
      * eLXg̃obNJ[ύX
      */
    public void setTextColor() {
        Color col = ZGraphicUtil.stringToColor(getString());
        if ( col != null ) {
            mText.setForeground(ZGraphicUtil.inverseColor(col));
            mText.setBackground(col);
        } else {
            mText.setForeground(Color.black);
            mText.setBackground(Color.white);
        }
    }
}
