/*
 * @(#)EnvDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Generator Dialog
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;


/**
 * Rid Generator  Dialog
 */
public class EnvDialog extends JDialog {

    /** _CAO  **/
    public JFrame mFrame;
    /** _CAO  **/
    public String mDialogName ;
    /**  **/
    public boolean mIsOK = false ;
    /**CR|[lg */
    protected JComponent mComponent = null ;
    /** XN[R|[lg */
    protected JScrollPane mScroll = null ;
    /** {^pl */
    protected JPanel     mButtonPanel = null ;
    /** Ok{^ */
    protected JButton    mOk     = null ;
    /** Cancel{^ */
    protected JButton    mCancel = null ;

    /**
      * RXgN^
      * @param app     AvP[V
      * @param szName  _CAO
      */
    public EnvDialog(JFrame frame, String title) {

        // mo-modalŐݒ
        super(frame, false);

        // AvP[V̐ݒ
        mFrame      = frame ;
        mDialogName = title;

        //^Cg\
        setTitle();
    }

    /**
      * [_s
      */
    public boolean doModal() {
      setModal(true);

      // ʒɕ\
      pack();
      Dimension dim = getToolkit().getScreenSize();
      int ww = (int)(dim.width * 0.9);
      int hh = (int)(dim.height * 0.9);
      int width  = Math.min(ww, getWidth());
      int height = Math.min(hh, getHeight());
      setSize(new Dimension(width,height));
      setLocation( dim.width/2 - getWidth()/2, dim.height/2 - getHeight()/2 );

      //enterL[Ŏs
      getRootPane().setDefaultButton(mOk);

      //ʕ\
      show();
  
      // OK{^ꂽH
      return isOK() ;
    }

    /**
      * OK{^ꂽH
      */
    public boolean isOK() {
        return mIsOK;
    }

    /**
      * ^Cg̕\,ACR̕\
      */
    protected void setTitle() {
        // ^Cg̕\
        setTitle( mDialogName );
    }

    /**
      * _CAȌI
      * ~{^ꂽƂɌĂяoB
      */
    public void hide() {
        super.hide();
    }

    /**
      * R|[lg̐ݒ
      * @param cmp CR|[lg
      * @param isScroll XN[̗L
      */
    public void setComponent( JComponent cmp,  boolean isScroll ){
        mComponent = cmp;
        if ( isScroll ) {
            mScroll = new JScrollPane();
            mScroll.setViewportView( mComponent );
            getContentPane().add("Center",mScroll);
        } else {
            getContentPane().add("Center",mComponent);
        }
    }

    /**
      * uOKv{^
      */
      public void onOK() {
        mIsOK = true;
        setVisible(false);
      }

    /**
      * uCancelv{^
      */
      public void onCancel() {
        mIsOK = false ;
        setVisible(false);
      }

    /**
      * ʐݒ
      * @param cmp R|[lg
      */
      public void setControlPanel(JComponent cmp) {

          JPanel control = createControlPanel();

          getContentPane().setLayout(new BorderLayout());

          //getContentPane().add(cmp,     BorderLayout.CENTER );
          setComponent(cmp, true);
          getContentPane().add(control, BorderLayout.SOUTH );
      }

    /**
      * ʐݒ
      * 
      */
      public JPanel createControlPanel() {

          mButtonPanel = new JPanel();

          mOk     = new JButton("Ok");
          mCancel = new JButton("Cancel");

          mOk.addActionListener(
              new ActionListener() {
                  public void actionPerformed(ActionEvent e) { onOK(); }
              }
          );

          mCancel.addActionListener(
              new ActionListener() {
                  public void actionPerformed(ActionEvent e) { onCancel(); }
              }
          );
          
          mButtonPanel.add( mOk );
          mButtonPanel.add( mCancel );

          return mButtonPanel;
      }

    /**
      * _CAO̎擾
      */
      public String getDialogName() {
          return mDialogName;
      }

    /**
      * OK{^̎擾
      */
      public JButton getOKButton() {
          return mOk;
      }

    /**
      * OK{^̕ݒ
      */
      public void setOkText(String value) {
          mOk.setText(value);
      }

    /**
      * OK{^̕ݒ
      */
      public String getOkText() {
          return mOk.getText();
      }
    /**
      * Cancel{^̕ݒ
      */
    public void setCancelText(String value) {
        mCancel.setText( value );
    }
    /**
      * Cancel{^̕ݒ
      */
    public String getCancelText() {
        return mCancel.getText();
    }
    /**
      * {^pl̎擾
      */
    public JPanel getButtonPanel() {
        return mButtonPanel;
    }
    /**
      * Cancel{^̎擾
      */
    public JButton getCancelButton() {
        return mCancel;
    }
    /**
      * R|[lg̎擾
      */
    public JComponent getComponent() {
        return mComponent;
    }
    /**
      * XN[R|[lg̎擾
      */
    public JScrollPane getScrollComponent() {
        return mScroll;
    }
}

