
/*
 * @(#)EnvFileChooser.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : t@C`[U̍쐬
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/05/23
 */
package jp.co.nri.rid.environment;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;

/**
  *t@C`[U̍쐬
  **/
public class EnvFileChooser {

    /**
      * fileChooser
      * @param  parent          eR|[lg
      * @param  path            vWFNgfBNg
      * @param  selectionMode   ZNg[h
      * @return String          null̓LZ{^
      */
    public String show(Component parent, String path, int selectionMode) {

        if (path == null) path = "";

        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(path));
        jFileChooser.setFileSelectionMode(selectionMode);
        int nRet = jFileChooser.showOpenDialog(parent);

        // {^
        String szFile = null;
        if ( nRet == JFileChooser.APPROVE_OPTION) {
            // [OK]{^̏ꍇA
            File fFile = jFileChooser.getSelectedFile();
            try {
              szFile = fFile.getCanonicalPath();
            } catch ( java.io.IOException evt) {
              szFile = fFile.getAbsolutePath();
            }
        }
        return szFile;
    }
}
