/*
 * @(#)AnalyzerDialog
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : HTML Dir ݒ _CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/04
 * 			1.10 2003/05/19 Detail Info@\ǉɔύX
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;

import	javax.xml.transform.*;	// Transformer TransformerFactory TransformerConfigurationException TransformerException
import	javax.xml.transform.stream.*;	// StreamResult StreamSource
import	javax.xml.transform.dom.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.*;
import jp.co.nri.*;


/**
 * AiCU_CAO
 */

public class HtmlDirDialog {

    final static private String MSG_TITLE	= "msg.htmldir.title";
    final static private String MSG_HTMLDIR	= "msg.htmldir.htmldir";
    final static private String MSG_ATPIP	= "msg.htmldir.atpip";
    final static private String MSG_SET		= "msg.htmldir.set";
    final static private String MSG_CANCEL	= "msg.htmldir.cancel";
    final static private String MSG_DEFAULT	= "msg.htmldir.default";
    final static private String MSG_REF		= "msg.htmldir.ref";
    final static private String MSG_INFO	= "msg.htmldir.info";
    final static private String MSG_ERROR_SAVE		= "msg.htmldir.error.save";
    final static private String MSG_ERROR_LICENSE	= "msg.htmldir.error.license";
    
    /** pl      **/
    private JTextField	htmlDir	= new JTextField();
    private JTextField	atPip	= new JTextField();
	
	private JDialog gdlg;
	private JFileChooser chooser = null;
	
    /**
      * ftHgRXgN^
      */
	public HtmlDirDialog(){
		
        ZResource res = ZApp.getTheApp().getResource();

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        gdlg = new JDialog(frame, res.getString(MSG_TITLE));
		
		JPanel	panel	= new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        panel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints label_gbc = createLabelConstraints();
        GridBagConstraints compo_gbc = createComponentConstraints();
        GridBagConstraints compo_gbc2= createComponentConstraints2();
        GridBagConstraints compo_gbc3= createComponentConstraints3();
        GridBagConstraints info_gbc = createInfoConstraints();

        label_gbc.gridy      = 0;
        label_gbc.gridx      = 0;
        JLabel label = new JLabel(res.getString(MSG_HTMLDIR));
        mLayout.setConstraints(label, label_gbc);
        panel.add( label );
		
        compo_gbc2.gridy      = 1;
        compo_gbc2.gridx      = 0;
        mLayout.setConstraints(htmlDir, compo_gbc2);
        panel.add( htmlDir );
        
		compo_gbc3.gridy      = 1;
        compo_gbc3.gridx      = 1;
		JButton btn = new JButton(new RefAction(res.getString(MSG_REF), gdlg));
        mLayout.setConstraints(btn, compo_gbc3);
        panel.add( btn );
		
        label_gbc.gridy      = 2;
        label_gbc.gridx      = 0;
        label = new JLabel(res.getString(MSG_ATPIP));
        mLayout.setConstraints(label, label_gbc);
        panel.add( label );
		
        compo_gbc.gridy      = 3;
        compo_gbc.gridx      = 0;
        mLayout.setConstraints(atPip, compo_gbc);
        panel.add( atPip );
		
		label = new JLabel(res.getString(MSG_INFO));
		label.setForeground(Color.BLUE);
//		JPanel infopanel = new JPanel();
//        infopanel.add(label);
		
		info_gbc.gridy      = 4;
        info_gbc.gridx      = 0;
		
        mLayout.setConstraints(label, info_gbc);
        panel.add( label );
		
		JPanel bpanel = new JPanel();
		
		bpanel.add(new JButton(new SetAction(res.getString(MSG_SET), gdlg)));
		bpanel.add(new JButton(new CancelAction(res.getString(MSG_CANCEL), gdlg)));
		bpanel.add(new JButton(new DefaultAction(res.getString(MSG_DEFAULT), gdlg)));
		
        compo_gbc.gridy      = 5;
        compo_gbc.gridx      = 0;
        mLayout.setConstraints(bpanel, compo_gbc);
        panel.add( bpanel );
		gdlg.setContentPane(panel);
		gdlg.setModal(true);
	}
	
    /**
      * AiCU_CAO
      *
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public void show() {
		String htmldir	= Ridual.getHtmlDir2();
		String pip		= Ridual.getHtmlDirPIP();
		
		htmlDir.setText((null == htmldir) ? "" : htmldir);
		atPip.setText((null == pip) ? "" : pip);
		
		gdlg.pack();
		Dimension dim = gdlg.getToolkit().getScreenSize();
		gdlg.setLocation( dim.width/2 - gdlg.getWidth()/2, dim.height/2 - gdlg.getHeight()/2 );
		gdlg.show();
		
    }
    
	/**
      * xpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.SOUTHWEST;
        gbc.weightx = 0.0 ;
        gbc.insets  = new Insets(4,4,0,4) ;
        return gbc;
    }

	/**
      * CtH[VpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createInfoConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.SOUTH;
        gbc.weightx = 0.0 ;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets  = new Insets(0,32,0,32) ;
        return gbc;
    }

    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets    = new Insets(0,4,4,4) ;
        return gbc;
    }
    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints2() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
        gbc.insets    = new Insets(0,4,4,0) ;
        return gbc;
    }
    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints3() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 0.0 ;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets    = new Insets(0,0,4,4) ;
        return gbc;
    }
	
	private	void createIndex1() throws
		TransformerConfigurationException, TransformerException
	{
		ZResource res	= ZApp.getTheApp().getResource();
		
		File configdir	= new File(res.getString("app.install.path") ,res.getString("app.config.dir"));
		File appdir		= new File(configdir ,"application");
		
		StreamSource	xsl = new StreamSource(new File(appdir, "index_1.xsl"));
		
		TransformerFactory factory = TransformerFactory.newInstance();
		
			Transformer transformer = factory.newTransformer(xsl);
			transformer.setOutputProperty("method", "html");
			transformer.setOutputProperty("encoding", "Shift_JIS");
			
			File dir = new File(ZInstance.prop().getProperty( Rid.PJ_DIR ) ,res.getString("rid.admin.dir"));
			transformer.transform(new DOMSource((DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE)), new StreamResult(new File(dir, "index_1.html")));
	}
	
	private	boolean setHtmlDir(String htmldir, String pip){
		Ridual ridual = (Ridual)ZApp.getTheApp();
		
//		if(!ridual.checkLicense(true))	return false;
		if(!ridual.checkLicense(false)){
			JOptionPane.showMessageDialog(gdlg, ZApp.getTheApp().getResource().getString(MSG_ERROR_LICENSE));
			return false;
		}
		
		String mes = "";
		
		try{
			Ridual.setHtmlDir(htmldir);
			Ridual.setHtmlDirPIP(pip);
			
			if(ridual.save()){
				createIndex1();
				return true;
			} else mes = ZApp.getTheApp().getResource().getString(MSG_ERROR_SAVE);
		} catch(Throwable t){
			t.printStackTrace();
			mes = t.getMessage();
		}
		
		try{ JOptionPane.showMessageDialog(gdlg, mes); }
		catch(HeadlessException he){ he.printStackTrace(); }
		
		return false;
	}
	
	private class SetAction extends AbstractAction{
		private JDialog dlg;
		public SetAction(String name, JDialog dlg){
			super(name);
			this.dlg = dlg;
		}
		public void actionPerformed(ActionEvent evt){
			String htmldir	= htmlDir.getText();
			String pip		= atPip.getText();
			
			if(setHtmlDir((0 < htmldir.length()) ? htmldir : null, (0 < pip.length()) ? pip : null)) dlg.hide();
		}
	}
	
	private class CancelAction extends AbstractAction{
		private JDialog dlg;
		public CancelAction(String name, JDialog dlg){
			super(name);
			this.dlg = dlg;
		}
		
		public void actionPerformed(ActionEvent evt){
			dlg.hide();
		}
	}
	
	private class DefaultAction extends AbstractAction{
		private JDialog dlg;
		public DefaultAction(String name, JDialog dlg){
			super(name);
			this.dlg = dlg;
		}
		public void actionPerformed(ActionEvent evt){
			if(setHtmlDir(null, null))	dlg.hide();
		}
	}
	
	private class RefAction extends AbstractAction{
		private JDialog dlg;
		public RefAction(String name, JDialog dlg){
			super(name);
			this.dlg = dlg;
		}
		public void actionPerformed(ActionEvent evt){
	    	if (chooser == null) {
				chooser = new JFileChooser();
				
				// fBNgIɂ
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			}
			
/*
			File htmldir = new File(htmlDir.getText());
			chooser.setSelectedFile(htmldir);
			File parent	= htmldir.getParentFile();
			chooser.setCurrentDirectory( (null == parent) ? htmldir : parent );
*/
			chooser.setCurrentDirectory(new File(Ridual.getHtmlDir()));
			
			// _CAOJ
			if ( chooser.showOpenDialog(dlg) != JFileChooser.APPROVE_OPTION) return;
			
			File file = chooser.getSelectedFile();
			htmlDir.setText(file.getAbsolutePath());
		}
	}
}
