/*
 * @(#)ExportCsvDialog
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Export Csv Dialog
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 200?/??/??
 */
package jp.co.nri.rid.export;

import java.io.*;
import javax.swing.*;
import java.awt.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZInstance;

import jp.co.nri.Rid;
import jp.co.nri.rid.action.*;

/**
 * Rid Export Csv Dialog
 * EXPORTp_CAO
 */
public class ExportCsvDialog {

    protected JPanel     mPanel         = null;  //Cpl
    protected JTextField mImportComment = null;  //Rg

    /**
     * ftHgRXgN^
     */
    public ExportCsvDialog() { }

    /**
     * _CAO
     */
    public boolean show(String filename) {

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        ExportDialog gdlg = new ExportDialog(frame, "CSV");

        //CR|[lg
        mPanel = new JPanel();

        //LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        //CAEg̐
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        gbc.insets = new Insets(10, 0, 0, 0);

        //Rg
        gbc.gridx = 0;
        gbc.gridy = 0;
        mPanel.add(new JLabel("Comment"));

        gbc.gridx = 1;
        mImportComment = createImportComment();
        mLayout.setConstraints(mImportComment, gbc);
        mPanel.add(mImportComment);

        //CR|[lgɃplǉ
        gdlg.setControlPanel(mPanel);

		// ftHg{^̐ݒ
		gdlg.getRootPane().setDefaultButton( gdlg.getOKButton() );

        //_CAO\
        gdlg.doModal();

        //[OK]{^ꂽꍇ
        boolean result = gdlg.isOK();
        if (result){ showCSV(filename); }

        return result;
    }

    /**
     * [csv.comment]擾
     */
    private JTextField createImportComment() {

        ZResource result = ZApp.getTheApp().getResource();
        String comment = result.getString("csv.comment");
        JTextField text = new JTextField(comment, 35);
        return text;
    }

    /**
     * [csv.comment]̕擾
     */
    private String getCSVComment() {

        String szTmp = mImportComment.getText();
        if(szTmp == null || szTmp.equals("")) return null;
        return szTmp;
    }

    /**
     * [CSV]ݒ肷
     */
    private void showCSV(String filename) {

        ZResource result = ZApp.getTheApp().getResource();

        /* Rg̐ݒ */
        /* [csv.comment]ݒ */
        result.putString("csv.comment", getCSVComment() );

        /*Documentɒǉ*/
        DocDocument docdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
        docdoc.beginTransaction();
        try {
            String      projectdir  = ZInstance.prop().getProperty(Rid.PJ_DIR);
            ZResource   ress        = ZApp.getTheApp().getResource();
            String      dir         = projectdir + File.separator + ress.getString("rid.docs.dir");

            exporter importer = new exporter();
            importer.export(dir, filename, 2);
            docdoc.commit();
        } catch ( Throwable t ) {
            ZDebug.trace("failed");
            t.printStackTrace();
            docdoc.rollback();
        }
    }
}
