/*
 * @(#)ExportSvgDialog
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Svg Dialog
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 200?/??/??
 */
package jp.co.nri.rid.export;

import java.io.*;
import javax.swing.*;
import java.awt.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZInstance;

import jp.co.nri.Rid;
import jp.co.nri.rid.action.*;

import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;

import jp.co.nri.rid.doc.RidExecAction;
/**
 * Rid Export Svg Dialog
 * EXPORTp_CAO
 */
public class ExportSvgDialog {

    protected JPanel      mPanel            = null;     //CR|[lg
    protected JCheckBox   mBrowser          = null;     //vEU`FbN{bNX
    protected JComboBox   mBrowserLst       = null;     //vEUR{{bNX
    protected JTextField  mImportComment    = null;     //Rg

    /**
     *ftHgRXgN^
     */
    public ExportSvgDialog() {  }

    /**
     *_CAO
     */
    public boolean show(String filename, boolean type) {

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        ExportDialog gdlg = new ExportDialog(frame, "SVG");

        //CR|[lg
        mPanel = new JPanel();

        //LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        //CAEg̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill   = GridBagConstraints.BOTH;
        gbc.insets = new Insets(10, 0, 0, 0);

        //_mapSVGt@CꍇDocumentɒǉ邽߂̃Rgڒǉ
        if (type) {
            //Rg
            gbc.gridx = 0;
            gbc.gridy = 0;
            JLabel label = new JLabel("Comment");
            mPanel.add(label);

            gbc.gridx = 1;
            mPanel.add(new JLabel(" "));

            gbc.gridx = 2;
            mImportComment = createImportComment();
            mLayout.setConstraints(mImportComment, gbc);
            mPanel.add( mImportComment );
        }

        //vEU`FbN{bNX
        gbc.gridx = 0;
        gbc.gridy = 1;
        JLabel label2 = new JLabel("Browser:");
        mLayout.setConstraints(label2, gbc);
        mPanel.add(label2);

        gbc.gridx = 1;
        mBrowser = createBrowserCheckBox();
        mLayout.setConstraints(mBrowser, gbc);
        mPanel.add(mBrowser);

        //vEUXg
        gbc.gridx      = 2;
        gbc.gridwidth  = 2;
        gbc.gridheight = 1;
        mBrowserLst = createBrowserComboBox();
        mLayout.setConstraints(mBrowserLst, gbc);
        mPanel.add(mBrowserLst);

        //CR|[lgɃplǉ
        gdlg.setControlPanel(mPanel);
        //gdlg.mCancel.setVisiable(false);

		// ftHg{^̐ݒ
		gdlg.getRootPane().setDefaultButton( gdlg.getOKButton() );

        //_CAO\
        gdlg.doModal();

        //[OK]{^ꂽꍇ
        boolean result = gdlg.isOK();
        if (result) showSVG(filename, type);

        return result;
    }

    /**
      * uEŨ`FbN{bNX쐬
      */
    private JCheckBox createBrowserCheckBox() {

        ZResource result = ZApp.getTheApp().getResource();
        boolean browser = result.getBoolean("svg.browser");
        JCheckBox chk = new JCheckBox();
        chk.setSelected(browser);        
        return chk;
    }

    /**
      * [svg.comment]擾
      */
    private JTextField createImportComment() {

        ZResource result = ZApp.getTheApp().getResource();
        String  comment = result.getString("svg.comment");
        JTextField text = new JTextField(comment, 35);
        return text;
    }

    /**
      * [svg.comment]̕擾
      */
    private String getSVGComment(){

        String szTmp = mImportComment.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * uEŨR{{bNX쐬
      */
    private JComboBox createBrowserComboBox() {

        JComboBox comboBox = new JComboBox();

        //\[Xt@CuEUR}h̃Xgݒ肷
        ZResource res = ZApp.getTheApp().getResource();
        for ( int i = 1; ; i++ ) {
            String  command = "generate.browser_command." + Integer.toString(i);
            String  browser_command = res.getString(command);
            if (browser_command == null) break;
            //ڂ̒ǉ
            comboBox.addItem(makeObj(browser_command));
        }
        return comboBox;
    }

    /**
      * StringObject֕ϊ
      */
    private Object makeObj(final String item)  {
        return new Object() { public String toString() { return item; } };
    }

    /**
     * [SVG]ݒ肷
     */
     private void showSVG(String filename, boolean type) {

         ZResource result = ZApp.getTheApp().getResource();

         /* uEU̐ݒ */
         /* [svg.browser]ݒ */
         result.putBoolean("svg.browser", mBrowser.isSelected());

         /* uEUR}h̐ݒ */
         /* [generate.browser_command]ݒ */
         int index = mBrowserLst.getSelectedIndex();
         String command = "generate.browser_command." + Integer.toString(index+1);
         result.putString("generate.browser_command", result.getString(command));

         if (type) {
             /* [svg.comment]ݒ */
             result.putString("svg.comment", getSVGComment() );
         }

         /*vEŰN*/
         if (mBrowser.isSelected()) {
			String szCmd  = result.getString("generate.browser_command")+" ";
			try{ filename = new File(filename).toURL().toExternalForm(); }
			catch( java.net.MalformedURLException ex){ ex.printStackTrace(); }
			if ( !RidExecAction.exec( szCmd, filename ) ) {
				RidMessage ridMsg = new RidMessage();
				MessageDialog.showError(ridMsg.Error("E1901",szCmd+" "+filename));
			}
/*
             try {
                 String szCmd  = result.getString("generate.browser_command")+" ";
                 Runtime.getRuntime().exec(szCmd + filename);
             } catch ( IOException io ) {
                 ZDebug.trace("browser start failed");
             }
*/
         }
         
         /*Documentɒǉ*/
         if (type) {
             DocDocument docdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
             docdoc.beginTransaction();
             try {
                 String      projectdir  = ZInstance.prop().getProperty(Rid.PJ_DIR);
                 ZResource   ress        = ZApp.getTheApp().getResource();
                 String      dir         = projectdir + File.separator + ress.getString("rid.docs.dir");

                 exporter importer = new exporter();
                 importer.export(dir, filename, 1);
                 docdoc.commit();

             } catch ( Throwable t ) {
                 ZDebug.trace("failed");
                 t.printStackTrace();
                 docdoc.rollback();
             }
         }
     }
}
