/**
 * @(#)exporter.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/08/09
 */
package jp.co.nri.rid.export;

import java.io.*;
import java.util.*;
import java.text.*;
import javax.swing.*;

import org.w3c.dom.*;

import jp.co.nri.Rid;
import jp.co.nri.rid.xml.*;
import jp.co.nri.rid.table.editor.filter.*;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.*;

import jp.co.iti.fagot.doc.DocDocument;
import jp.co.nri.rid.doc.RidElement;

/**
 * CSV,SVGGLX|[gc[
 */
public class exporter{

    protected String            COMMENT; 
    protected Exportelement     myElement;

    /**
     * RXgN^
     */
    public exporter(){

        //TopElement𒊏o
        Exportdocument document = new Exportdocument((Document)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT));
        myElement = document.root().child("ZoneUnit");
    }

    /**
     * l̐ݒ
     * @param String dirname ƃfBNgpX
     * @param String f_name  exportt@CpX
     * @param int    id      ID(1:SVG 2:CSV)
     */
    public void export(String dirname, String f_name, int id){

        File filename = new File(f_name);
        if (filename.exists()==false) return;
        File dir      = new File(dirname);
        if(id == 1)       COMMENT     = "svg.comment";
        else if(id == 2)  COMMENT     = "csv.comment";
        if(null==myElement)  return;       

        //ƃpX쐬
        String dirPath = dir.getAbsolutePath();
        String filePath = filename.getParent();
        String workPath = filePath.substring(dirPath.length());

        exportRecursive(workPath, myElement, filename);
    }

    /* ꏊ
     * @param File          dir      ƃfBNg
     * @param Exportelement element  ƃGg
     * @param File          filename exportt@C
     */
    protected void exportRecursive(String dir, Exportelement element, File filename) {

        //\ŕ
        StringTokenizer st = new StringTokenizer(dir, File.separator);
        File fileParent = filename.getParentFile();

        if (!(st.hasMoreElements())) {
            addElement(filename, element);
            return;
        } else {
            String zoneName = st.nextToken();
            Exportelement[] children = element.children("ZoneUnit");
            if (children != null) {
                for (int i = 0; i < children.length; i++) {
                    if(zoneName.equalsIgnoreCase(children[i].attribute("Name"))) {
                         //nameZONEUNIT݂̂ł̎qɈڂ
                         exportRecursive(dir.substring(zoneName.length() + 1), children[i], filename);
                    }
                }
            }
            exportRecursive(dir.substring(zoneName.length() + 1), childCreate("ZoneUnit" ,zoneName ,element), filename);
        } 
    }

    /**
     *  NODE`FbN
     *@@param String        unit   jbg
     *  @param String        name   (Name)
     *  @param Exportelement parent eGg
     */
    protected Exportelement childCreate(String unit ,String name ,Exportelement parent){

        //parent̉NODE邩ǂׂ
        Exportelement[] children = parent.children(unit);

        if(null==children) {
            return newchild(unit ,name ,parent);
        }

        int mx = children.length;
        for(int i=0;i<mx;i++){
            //̂return
            if(name.equalsIgnoreCase(children[i].attribute("Name"))) {
                return children[i];
            }
        }
        return newchild(unit ,name ,parent);
    }

    /**
     * NODE쐬
     * @param String        unit ZONEUNIT
     * @param String        name tH_
     * @param Exportelement parent eGg
     */
    protected Exportelement newchild(String unit ,String name ,Exportelement parent){
        //eݒ肷
        Attributes attr = new Attributes();
        attr.add("Name" ,name);
        attr.add("Creator" ,"operator");
        attr.add("Comment" ,ZApp.getTheApp().getResource().getString(COMMENT));
        attr.add("Exist"   ,"true");

        return parent.add(unit ,attr);
    }

    /**
     * ǉ
     * @param File          file     t@C
     * @param Exportelement element@Gg
     */
    protected void addElement(File file ,Exportelement element){

        //t@CpXt@C擾
        String name = file.getName();
        Exportelement child = childCreate("DocumentUnit" ,name ,element);
        //t@Ĉ݂̑
        child.attribute("Size" ,String.valueOf(file.length()));
        child.attribute("Date" ,DateFormat.getDateTimeInstance().format(new Date(file.lastModified())));
    }
}